/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.secid.SPSecID;
import com.secure.sportal.secid.SPSecIDExtAppInfo;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPSecIDUserInfo;
import com.secure.sportal.secid.SPTOtpTokenInfo;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SPSecIDTianjiSDK {
    private static final String TAG = "SPSecIDTianjiSDK";
    private static SparseArray<String> ErrCode = new SparseArray();
    private static final String DATA_SVR_HOST = "svr_host";
    private static final String DATA_SVR_PORT = "svr_port";
    private static final String DATA_USERNAME = "username";
    private static final String DATA_OTP_OFFLINE = "otp_offline";
    private static final String DATA_OFFSET_TIME = "offset_time";
    public static final String PROPERTIES_USERNAME = "username";
    public static final String PROPERTIES_USERPASS = "password";
    public static final String PROPERTIES_SMS_CODE = "checkcode_sms";
    public static final String PROPERTIES_EMAIL_CODE = "checkcode_mail";
    public static final String RESPONSE_OTP = "totp";
    public static final String RESPONSE_OTP_TIME_LEFT = "left_seconds";
    public static final int RESULT_ERROR = -1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_NEED_LOGIN = 1;
    public static final int RESULT_NEED_SMS = 2;
    public static final int RESULT_NEED_EMAIL = 3;
    public static final int RESULT_NEED_ITS_OTP = 4;
    public static final int RESULT_NEED_RESET_PASS = 5;
    private static String sharedperferences_name = "";
    private static SharedPreferences sp = null;
    private static SharedPreferences.Editor edit = null;
    private static String access_token = "";
    private static int req_code = 0;
    private static List<SPSecIDExtAppInfo> app_portal_list = null;
    private static String devid = "";
    private static JSONObject result = new JSONObject();
    private static SPSecIDUID mUID = null;

    public static JSONObject login(Context context, Properties params) {
        Result result = null;
        String host = "";
        int port = 0;
        String username = "";
        String auth_cert_base64 = "";
        Log.i((String)TAG, (String)"sdk login.");
        host = params.getProperty("server_host", "");
        port = Integer.valueOf(params.getProperty("server_port", "0"));
        auth_cert_base64 = params.getProperty("auth_cert_base64", "");
        if (!TextUtils.isEmpty((CharSequence)auth_cert_base64)) {
            params.setProperty("username", auth_cert_base64.substring(0, 19));
        }
        username = params.getProperty("username", "");
        if (TextUtils.isEmpty((CharSequence)host) || port < 1 || TextUtils.isEmpty((CharSequence)username)) {
            Log.e((String)TAG, (String)"sdk login input params error");
            JSONObject ret = SPSecIDTianjiSDK.setResult(-1, "\u4f20\u5165SDK\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!");
            return ret;
        }
        result = SPSecIDTianjiSDK.initialize(context, true);
        JSONObject ret = result.errorCode == 1 ? SPSecIDTianjiSDK.loginStep(context, host, port, params) : SPSecIDTianjiSDK.setResult(result.errorCode, result.errorMessage);
        return ret;
    }

    public static JSONObject logout(Context context) {
        JSONObject ret = new JSONObject();
        Log.i((String)TAG, (String)"sdk logout.");
        if (mUID == null && !SPSecIDTianjiSDK.loadData(context)) {
            try {
                ret.put("errcode", 0);
                ret.put("errmsg", (Object)"\u767b\u51fa\u6210\u529f!");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return ret;
        }
        Log.i((String)TAG, (String)("do logout " + SPSecIDTianjiSDK.mUID.username + "@" + SPSecIDTianjiSDK.mUID.svr_host + ":" + SPSecIDTianjiSDK.mUID.svr_port));
        SPSecID.logout(context, mUID);
        try {
            ret.put("errcode", 0);
            ret.put("errmsg", (Object)"\u767b\u51fa\u6210\u529f!");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ret;
    }

    public static JSONObject request(Context context, String reqid, Properties params) {
        Result result = null;
        JSONObject ret = new JSONObject();
        Log.d((String)TAG, (String)("sdk request " + reqid + " params is " + params.toString()));
        if (mUID == null) {
            result = SPSecIDTianjiSDK.initialize(context, false);
            try {
                ret.put("errcode", result.errorCode);
                ret.put("errmsg", (Object)result.errorMessage);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (result.errorCode != 0) {
                Log.e((String)TAG, (String)("user is already logout, errcode " + ret.optInt("errcode") + ", errmsg " + ret.optString("errmsg")));
                return ret;
            }
        }
        if (reqid.equals("get_otp")) {
            result = SPSecIDTianjiSDK.generateToken(context);
            try {
                ret.put("errcode", result.errorCode);
                ret.put("errmsg", (Object)result.errorMessage);
                ret.put("otp", (Object)result.data.getProperty(RESPONSE_OTP, ""));
                int lefts = Integer.parseInt(result.data.get(RESPONSE_OTP_TIME_LEFT).toString());
                ret.put(RESPONSE_OTP_TIME_LEFT, lefts);
            }
            catch (JSONException lefts) {}
        } else if (reqid.equals("get_authcode")) {
            SPMsgRsp<String> rsp = SPSecIDTianjiSDK.getAuthCode(context, params.getProperty("package_name", ""), params);
            String authCode = "";
            if (rsp != null) {
                if (rsp.errcode == 0) {
                    authCode = rsp.data();
                    Log.d((String)TAG, (String)("authCode is " + authCode));
                }
                try {
                    ret.put("errcode", rsp.errcode);
                    if (!TextUtils.isEmpty((CharSequence)rsp.errmsg)) {
                        ret.put("errmsg", (Object)rsp.errmsg);
                    } else {
                        ret.put("errmsg", (Object)SPSecIDTianjiSDK.getError(rsp.errcode));
                    }
                    ret.put("authcode", (Object)authCode);
                }
                catch (JSONException jSONException) {}
            } else {
                try {
                    ret.put("errcode", -1);
                    ret.put("errmsg", (Object)"\u83b7\u53d6authcode\u5931\u8d25,\u6d88\u606f\u8fd4\u56de\u7a7a");
                    ret.put("authcode", (Object)"");
                }
                catch (JSONException jSONException) {}
            }
        } else if (reqid.equals("unbind")) {
            SPMsgRspEmpty rsp = SPSecIDTianjiSDK.unbind(context);
            if (rsp != null) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)rsp.errmsg)) {
                        ret.put("errmsg", (Object)rsp.errmsg);
                    } else {
                        ret.put("errmsg", (Object)SPSecIDTianjiSDK.getError(rsp.errcode));
                    }
                    ret.put("errcode", rsp.errcode);
                }
                catch (JSONException jSONException) {}
            } else {
                try {
                    ret.put("errcode", -1);
                    ret.put("errmsg", (Object)"\u89e3\u7ed1\u8bbe\u5907\u5931\u8d25,\u89e3\u7ed1\u6d88\u606f\u8fd4\u56de\u7a7a");
                    ret.put("authcode", (Object)"");
                }
                catch (JSONException jSONException) {}
            }
        } else {
            try {
                ret.put("errcode", -1);
                ret.put("errmsg", (Object)("reqid[" + reqid + "] is invailed."));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Log.d((String)TAG, (String)("request " + reqid + " end: errcode " + ret.optInt("errcode") + ", errmsg " + ret.optString("errmsg")));
        return ret;
    }

    public static JSONObject resetPassword(Context context, String pass_new, String pass_old) {
        if (mUID == null && !SPSecIDTianjiSDK.loadData(context)) {
            return SPSecIDTianjiSDK.setResult(-1, "\u7528\u6237\u672a\u767b\u5f55");
        }
        Log.d((String)TAG, (String)(SPSecIDTianjiSDK.mUID.username + "@" + SPSecIDTianjiSDK.mUID.svr_host + ":" + SPSecIDTianjiSDK.mUID.svr_port + " resetPassword"));
        SPMsgRspEmpty rsp = SPSecID.secidResetPassword(context.getApplicationContext(), mUID, pass_new, pass_old, "");
        if (TextUtils.isEmpty((CharSequence)rsp.errmsg)) {
            rsp.errmsg = SPSecIDTianjiSDK.getError(rsp.errcode);
        }
        return SPSecIDTianjiSDK.setResult(rsp.errcode, rsp.errmsg);
    }

    private static Result initialize(Context context, boolean login_now) {
        SPMsgRsp<SPSecIDUserInfo> rsp = null;
        int errcode = 0;
        Log.i((String)TAG, (String)"initialize...");
        Result ret = new Result();
        if (context == null) {
            Log.e((String)TAG, (String)"initialize error: context is null");
            ret.errorMessage = "context is null";
            return ret;
        }
        if (!SPSecIDTianjiSDK.loadData(context)) {
            Log.d((String)TAG, (String)"initialize need user login");
            ret.errorCode = 1;
            ret.errorMessage = "\u7528\u6237\u672a\u767b\u5f55";
            return ret;
        }
        if (login_now) {
            ret.errorCode = 1;
            ret.errorMessage = "";
            return ret;
        }
        rsp = SPSecID.refreshToken(context.getApplicationContext(), mUID);
        errcode = rsp.errcode;
        Log.d((String)TAG, (String)("refreshToken errcode is " + errcode + ", errmsg is " + SPSecIDTianjiSDK.getError(errcode)));
        if (rsp.data() == null) {
            Log.e((String)TAG, (String)"refreshToken userinfo is null");
        }
        ret.errorCode = errcode;
        ret.errorMessage = SPSecIDTianjiSDK.getError(errcode);
        return ret;
    }

    public static JSONObject loginStep(Context mContext, String host, int port, Properties authdata) {
        SPMsgRsp<SPSecIDUserInfo> login_rsp = null;
        SPSecIDUserInfo userInfo = null;
        String sms_code = "";
        String mail_code = "";
        String otp = "";
        if (null == mContext) {
            Log.e((String)TAG, (String)"login:context is null");
            return SPSecIDTianjiSDK.setResult(-1, "\u4f20\u5165context\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)host) || port == 0) {
            return SPSecIDTianjiSDK.setResult(-1, "\u4f20\u5165\u5730\u5740\u6216\u7aef\u53e3\u9519\u8bef");
        }
        otp = authdata.getProperty("extra_its_otp", "");
        Log.d((String)TAG, (String)("do login " + authdata.getProperty("username", "") + "@" + host + ":" + port + ", req_code " + req_code + ", otp " + otp));
        if (TextUtils.isEmpty((CharSequence)otp)) {
            req_code = 0;
        }
        if (req_code > 0) {
            authdata.setProperty("req_code", String.valueOf(req_code));
            if (req_code == 3 || req_code == 4) {
                sms_code = authdata.getProperty("check_code_sms", "");
                mail_code = authdata.getProperty("check_code_mail", "");
                Log.d((String)TAG, (String)("check_code_sms is " + sms_code + ", check_code_mail is " + mail_code));
                if (TextUtils.isEmpty((CharSequence)sms_code) || TextUtils.isEmpty((CharSequence)mail_code)) {
                    return SPSecIDTianjiSDK.setResult(-1, "\u9a8c\u8bc1\u7801\u672a\u4f20\u5165");
                }
            }
        }
        authdata.setProperty("virus", "1");
        authdata.setProperty("access_token", access_token);
        login_rsp = SPSecID.loginServer(mContext.getApplicationContext(), host, port, authdata);
        Log.d((String)TAG, (String)("loginServer response errCode " + login_rsp.errcode + ", errMsg " + SPSecIDTianjiSDK.getError(login_rsp.errcode)));
        userInfo = login_rsp.data();
        if (userInfo == null) {
            return SPSecIDTianjiSDK.setResult(login_rsp.errcode, SPSecIDTianjiSDK.getError(login_rsp.errcode));
        }
        req_code = userInfo.req_code;
        Log.i((String)TAG, (String)("loginServer response login_step is " + req_code));
        Result result = new Result();
        result.errorCode = login_rsp.errcode;
        if (login_rsp.errcode == 0) {
            if (userInfo.access_token != null && !userInfo.access_token.isEmpty()) {
                access_token = userInfo.access_token;
            }
            if (mUID == null) {
                mUID = new SPSecIDUID();
            }
            SPSecIDTianjiSDK.mUID.svr_host = userInfo.host;
            SPSecIDTianjiSDK.mUID.svr_port = userInfo.port;
            SPSecIDTianjiSDK.mUID.username = userInfo.username;
            if (req_code == 0) {
                access_token = "";
                app_portal_list = userInfo.apps;
                SPSecIDTianjiSDK.getDeviceID(userInfo.bind_dev_list);
                SPSecIDTianjiSDK.saveData(userInfo);
            } else if (req_code == 2) {
                result.errorMessage = "\u9700\u8981\u6740\u6bd2";
            } else if (userInfo.req_code == 3) {
                result.errorCode = 2;
                result.errorMessage = "\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55";
            } else if (userInfo.req_code == 4) {
                result.errorCode = 3;
                result.errorMessage = "\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55";
            } else if (userInfo.req_code == 5) {
                result.errorCode = 5;
                result.errorMessage = "\u9700\u8981\u4fee\u6539\u5bc6\u7801";
            } else if (userInfo.req_code == 7) {
                result.errorCode = 4;
                result.errorMessage = "\u9700\u8981ITS-OTP\u8ba4\u8bc1";
            }
        } else {
            result.errorMessage = SPSecIDTianjiSDK.getError(login_rsp.errcode);
        }
        Log.i((String)TAG, (String)("sdk loginStep end: errcode " + result.errorCode + ", errmsg " + result.errorMessage));
        JSONObject ret = SPSecIDTianjiSDK.setResult(result.errorCode, result.errorMessage);
        try {
            ret.put("passPolicy", (Object)userInfo.pass_policy.toJSON().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static Result generateToken(Context mContext) {
        SPTOtpTokenInfo token_info = null;
        if (null == mContext) {
            Log.e((String)TAG, (String)"generateToken: context is null");
            return SPSecIDTianjiSDK.errorNotInitialized();
        }
        Log.i((String)TAG, (String)("generateToken " + SPSecIDTianjiSDK.mUID.username + "@" + SPSecIDTianjiSDK.mUID.svr_host + ":" + SPSecIDTianjiSDK.mUID.svr_port));
        token_info = SPSecID.totpGenerateToken(mUID);
        Result result = new Result();
        result.errorCode = token_info.errcode;
        result.errorMessage = SPSecIDTianjiSDK.getError(token_info.errcode);
        result.data.put(RESPONSE_OTP, token_info.token);
        result.data.put(RESPONSE_OTP_TIME_LEFT, (Object)token_info.left);
        Log.i((String)TAG, (String)("totpGenerateToken errcode is " + SPSecIDTianjiSDK.getError(token_info.errcode) + ", totp is " + token_info.token + ", left is " + token_info.left));
        return result;
    }

    private static SPMsgRsp<String> getAuthCode(Context context, String package_name, Properties params) {
        return SPSecID.secidRequestAuthCode(context.getApplicationContext(), mUID, SPSecIDTianjiSDK.searchAppid(package_name), params);
    }

    private static SPMsgRspEmpty unbind(Context context) {
        Log.d((String)TAG, (String)("user " + SPSecIDTianjiSDK.mUID.username + "@" + SPSecIDTianjiSDK.mUID.svr_host + ":" + SPSecIDTianjiSDK.mUID.svr_port + " unbind devid " + devid));
        return SPSecID.secidUnbindDevID(context, mUID, devid);
    }

    private static Result errorNotInitialized() {
        Result r = new Result();
        r.errorCode = -1;
        r.errorMessage = "\u672a\u521d\u59cb\u5316";
        return r;
    }

    private static boolean loadData(Context context) {
        if (mUID == null) {
            mUID = new SPSecIDUID();
        }
        if (sp == null) {
            sharedperferences_name = context.getPackageName() + ".secid_sdk_db";
            Log.i((String)TAG, (String)("loadData: init sharedperferences_name is " + sharedperferences_name));
            sp = context.getApplicationContext().getSharedPreferences(sharedperferences_name, 0);
        }
        SPSecIDTianjiSDK.mUID.svr_host = sp.getString(DATA_SVR_HOST, "");
        SPSecIDTianjiSDK.mUID.svr_port = sp.getInt(DATA_SVR_PORT, 443);
        SPSecIDTianjiSDK.mUID.username = sp.getString("username", "");
        SPSecIDTianjiSDK.mUID.otp_offline = sp.getBoolean(DATA_OTP_OFFLINE, false);
        SPSecIDTianjiSDK.mUID.offset_time = sp.getLong(DATA_OFFSET_TIME, 0L);
        Log.i((String)TAG, (String)("loadData: svr_host[" + SPSecIDTianjiSDK.mUID.svr_host + "], svr_port[" + SPSecIDTianjiSDK.mUID.svr_port + "], username[" + SPSecIDTianjiSDK.mUID.username + "], otp_offline[" + SPSecIDTianjiSDK.mUID.otp_offline + "], offset_time[" + SPSecIDTianjiSDK.mUID.offset_time + "]"));
        if (TextUtils.isEmpty((CharSequence)SPSecIDTianjiSDK.mUID.svr_host) || TextUtils.isEmpty((CharSequence)SPSecIDTianjiSDK.mUID.username)) {
            Log.e((String)TAG, (String)"loadData => user is not login");
            return false;
        }
        return true;
    }

    private static void saveData(SPSecIDUserInfo userInfo) {
        SharedPreferences.Editor editor = null;
        if (sp == null) {
            Log.e((String)TAG, (String)"saveData sp is null");
            return;
        }
        Log.i((String)TAG, (String)"saveData");
        editor = sp.edit();
        editor.putString(DATA_SVR_HOST, userInfo.host);
        editor.putInt(DATA_SVR_PORT, userInfo.port);
        editor.putString("username", userInfo.username);
        editor.putBoolean(DATA_OTP_OFFLINE, userInfo.otp_offline);
        editor.putLong(DATA_OFFSET_TIME, userInfo.otp_offset);
        editor.commit();
        SPSecIDTianjiSDK.loadData(null);
    }

    private static void clearData(Context context) {
        SharedPreferences.Editor editor = null;
        if (sp == null) {
            sharedperferences_name = context.getPackageName() + ".secid_sdk_db";
            Log.i((String)TAG, (String)("clearData => init sharedperferences_name is " + sharedperferences_name));
            sp = context.getApplicationContext().getSharedPreferences(sharedperferences_name, 0);
        }
        Log.i((String)TAG, (String)"clear userdata.");
        editor = sp.edit();
        editor.putString(DATA_SVR_HOST, "");
        editor.putInt(DATA_SVR_PORT, 0);
        editor.putString("username", "");
        editor.commit();
        mUID = null;
    }

    private static String searchAppid(String package_name) {
        SPSecIDExtAppInfo appInfo = null;
        if (package_name == null || TextUtils.isEmpty((CharSequence)package_name)) {
            Log.e((String)TAG, (String)"authCode package_name is null");
            return "";
        }
        Log.d((String)TAG, (String)("searchAppid by pacage name => " + package_name));
        if (app_portal_list == null) {
            Log.e((String)TAG, (String)"app_portal_list is null");
            return "";
        }
        if (app_portal_list.size() <= 0) {
            Log.e((String)TAG, (String)"app_portal_list size is 0");
            return "";
        }
        for (int i = 0; i < app_portal_list.size(); ++i) {
            appInfo = app_portal_list.get(i);
            if (!appInfo.pkgname.equals(package_name)) continue;
            Log.d((String)TAG, (String)("find appid is " + appInfo.appid));
            return appInfo.appid;
        }
        return "";
    }

    private static void getDeviceID(String str) {
        Log.e((String)TAG, (String)("bind_dev_list is " + str));
        if (!TextUtils.isEmpty((CharSequence)str)) {
            JSONArray data = null;
            try {
                data = new JSONArray(str);
                for (int i = 0; i < data.length(); ++i) {
                    try {
                        JSONObject jsonObject = data.getJSONObject(i);
                        devid = jsonObject.optString("dev_id");
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static synchronized String getError(int msgid) {
        String msg;
        if (ErrCode.size() < 1) {
            SPSecIDTianjiSDK.init();
        }
        msg = null != (msg = (String)ErrCode.get(msgid &= 0xFFFFFFF)) ? msg : Integer.toHexString(msgid);
        return msg;
    }

    private static JSONObject setResult(int errorCode, String errorMessage) {
        try {
            result.put("errcode", errorCode);
            result.put("errmsg", (Object)errorMessage);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void init() {
        ErrCode.put(0x2000402, (Object)"\u8ba4\u8bc1\u670d\u52a1\u5668\u4e0d\u53ef\u8fbe");
        ErrCode.put(0x2000404, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000401, (Object)"\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778242, (Object)"\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778243, (Object)"\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000404, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778245, (Object)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        ErrCode.put(16778246, (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        ErrCode.put(16778247, (Object)"Root\u8bbe\u5907\u7981\u6b62\u8bbf\u95ee");
        ErrCode.put(16778248, (Object)"\u767b\u5f55\u6d41\u7a0b\u9519\u8bef");
        ErrCode.put(16778249, (Object)"\u53d1\u73b0\u75c5\u6bd2\uff0c\u8bf7\u6740\u6bd2\u540e\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778250, (Object)"\u7f51\u5173\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778251, (Object)"\u7f51\u5173\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778252, (Object)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5931\u6548");
        ErrCode.put(16778253, (Object)"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5931\u6548");
        ErrCode.put(16778254, (Object)"\u8bbe\u5907\u7ed1\u5b9a\u5931\u8d25");
        ErrCode.put(16778255, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000410, (Object)"\u8ba4\u8bc1\u670d\u52a1\u5668\u4e0d\u53ef\u8fbe");
        ErrCode.put(0x1000411, (Object)"\u8bbe\u5907\u7ed1\u5b9a\u5931\u8d25");
        ErrCode.put(16778258, (Object)"\u5f53\u524d\u7ec8\u7aef\u88ab\u7ba1\u7406\u5458\u6ce8\u9500\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778259, (Object)"\u5f53\u524d\u7ec8\u7aef\u88ab\u7ba1\u7406\u5458\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000414, (Object)"\u5907\u4efd\u670d\u52a1\u5173\u95ed");
        ErrCode.put(16778262, (Object)"\u65e0\u6548\u5e94\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778264, (Object)"\u65e0\u6548\u4e8c\u7ef4\u7801");
        ErrCode.put(16778265, (Object)"\u4e8c\u7ef4\u7801\u8d85\u65f6");
        ErrCode.put(16778266, (Object)"\u65e0\u6548\u9a8c\u8bc1\u7801");
        ErrCode.put(16778267, (Object)"\u65e0\u6548\u9a8c\u8bc1\u7801");
        ErrCode.put(16778268, (Object)"\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e");
        ErrCode.put(16778269, (Object)"\u5bc6\u7801\u9519\u8bef");
        ErrCode.put(16778270, (Object)"\u65b0\u65e7\u5bc6\u7801\u76f8\u540c");
        ErrCode.put(16778271, (Object)"\u7981\u6b62\u4fee\u6539\u5bc6\u7801");
        ErrCode.put(16778272, (Object)"\u7528\u6237\u8bbe\u5907\u7ed1\u5b9a\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778273, (Object)"\u8bb8\u53ef\u4f7f\u7528\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778274, (Object)"\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778275, (Object)"\u8d26\u53f7\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778276, (Object)"\u4e0d\u5141\u8bb8\u4ece\u5f53\u524d\u7f51\u7edc\u767b\u5f55\uff0c\u8bf7\u5207\u6362\u63a5\u5165\u7f51\u7edc\u518d\u5c1d\u8bd5");
        ErrCode.put(16778277, (Object)"\u9a8c\u8bc1\u65e7\u5bc6\u7801\u5931\u8d25");
        ErrCode.put(16778278, (Object)"\u672a\u914d\u7f6e\u6709\u6548\u624b\u673a\u53f7\u7801\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778279, (Object)"\u672a\u914d\u7f6e\u6709\u6548\u90ae\u7bb1\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778285, (Object)"\u9519\u8bef\u7684\u52a8\u6001\u53e3\u4ee4");
        ErrCode.put(16778289, (Object)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        ErrCode.put(16778292, (Object)"\u52a8\u6001\u53e3\u4ee4\u683c\u5f0f\u9519\u8bef");
        ErrCode.put(16778295, (Object)"\u7528\u6237\u8bb8\u53ef\u4f7f\u7528\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778296, (Object)"\u5e94\u7528\u7684\u52a8\u6001\u53e3\u4ee4\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778297, (Object)"\u5e94\u7528\u7684\u4e8c\u7ef4\u7801\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778298, (Object)"\u5e94\u7528\u7684\u5b89\u5168\u4ee4\u724c\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778299, (Object)"\u672a\u6388\u6743\u8bbf\u95ee\u8be5\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000441, (Object)"\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000444, (Object)"\u975e\u5e38\u7528\u8bbe\u5907");
        ErrCode.put(16778309, (Object)"\u4ee4\u724c\u5df2\u8fc7\u671f");
        ErrCode.put(16778310, (Object)"\u975e\u5e38\u7528\u8bbe\u5907\uff0c\u8bf7\u53bb\u67dc\u53f0\u529e\u7406");
        ErrCode.put(16778311, (Object)"\u65e0\u6548\u7684\u63a8\u9001\u8bf7\u6c42");
        ErrCode.put(16778312, (Object)"\u63a8\u9001\u8bf7\u6c42\u5df2\u8d85\u65f6");
        ErrCode.put(16778320, (Object)"\u63a8\u9001\u8bf7\u6c42\u5df2\u88ab\u5904\u7406");
        ErrCode.put(16778322, (Object)"\u89e3\u7ed1\u8bbe\u5907\u5931\u8d25");
        ErrCode.put(0xFFFFFFF, (Object)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25");
    }

    public static class Result {
        public int errorCode = -1;
        public String errorMessage = "";
        public Properties data = new Properties();
    }
}

