/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.secid.SPSecID;
import com.secure.sportal.secid.SPSecIDUID;
import com.secure.sportal.secid.SPSecIDUserInfo;
import com.secure.sportal.secid.SPTOtpTokenInfo;
import java.util.Properties;

public class SPSecIDClientSDK {
    private static final String TAG = "SPSecIDClientSDK";
    private static SparseArray<String> ErrCode = new SparseArray();
    private static final String DATA_SVR_HOST = "svr_host";
    private static final String DATA_SVR_PORT = "svr_port";
    private static final String DATA_USERNAME = "username";
    private static final String DATA_OTP_OFFLINE = "otp_offline";
    private static final String DATA_OFFSET_TIME = "offset_time";
    public static final String PROPERTIES_USERNAME = "username";
    public static final String PROPERTIES_USERPASS = "password";
    public static final String PROPERTIES_SMS_CODE = "checkcode_sms";
    public static final String PROPERTIES_EMAIL_CODE = "checkcode_mail";
    public static final String RESPONSE_OTP = "totp";
    public static final String RESPONSE_OTP_TIME_LEFT = "left_seconds";
    public static final int RESULT_ERROR = -1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_NEED_LOGIN = 1;
    public static final int RESULT_NEED_SMS = 2;
    public static final int RESULT_NEED_EMAIL = 3;
    private static String sharedperferences_name = "";
    private static SharedPreferences sp = null;
    private static SharedPreferences.Editor edit = null;
    private static String access_token = "";
    private static int req_code = 0;
    private static Context mContext = null;
    private static SPSecIDUID mUID = null;

    public static Result initialize(Context context) {
        SPMsgRsp<SPSecIDUserInfo> rsp = null;
        int errcode = 0;
        mContext = context;
        req_code = 0;
        Result ret = new Result();
        if (context == null) {
            Log.e((String)TAG, (String)"initialize error: context is null");
            ret.errorMessage = "context is null";
            return ret;
        }
        sharedperferences_name = context.getPackageName() + ".secid_sdk_db";
        Log.i((String)TAG, (String)("initialize: sharedperferences_name is " + sharedperferences_name));
        sp = context.getApplicationContext().getSharedPreferences(sharedperferences_name, 0);
        mUID = SPSecIDClientSDK.loadData();
        if (TextUtils.isEmpty((CharSequence)SPSecIDClientSDK.mUID.svr_host) || TextUtils.isEmpty((CharSequence)SPSecIDClientSDK.mUID.username)) {
            Log.d((String)TAG, (String)"userdata is not init, do login first");
            ret.errorCode = 1;
            ret.errorMessage = "\u7528\u6237\u672a\u767b\u5f55";
            return ret;
        }
        rsp = SPSecID.refreshToken(context.getApplicationContext(), mUID);
        errcode = rsp.errcode;
        Log.d((String)TAG, (String)("refreshToken errcode is " + errcode + ", errmsg is " + SPSecIDClientSDK.getError(errcode)));
        if (rsp.data() == null) {
            Log.e((String)TAG, (String)"refreshToken userinfo is null");
        }
        if (SPSecIDClientSDK.mUID.otp_offline && (errcode & 0xFFFFFF) == 0xFFFFFF) {
            ret.errorCode = 0;
            ret.errorMessage = "\u79bb\u7ebf\u529f\u80fd\u5df2\u5f00\u542f";
        } else if ((errcode & 0xFFFFFF) == 0xFFFFFF) {
            ret.errorCode = 1;
            ret.errorMessage = "\u7f51\u7edc\u8fde\u63a5\u5931\u8d25";
        } else if ((errcode & 0xFFFFFF) == 1028) {
            ret.errorCode = 1;
            ret.errorMessage = SPSecIDClientSDK.getError(errcode);
        } else if ((errcode & 0xFFFFFF) == 1027) {
            ret.errorCode = 1;
            ret.errorMessage = SPSecIDClientSDK.getError(errcode);
        } else {
            ret.errorCode = rsp.errcode;
            ret.errorMessage = SPSecIDClientSDK.getError(errcode);
        }
        return ret;
    }

    public static Result login(String host, int port, Properties authdata) {
        SPMsgRsp<SPSecIDUserInfo> login_rsp = null;
        SPSecIDUserInfo userInfo = null;
        String sms_code = "";
        String mail_code = "";
        int errcode = 0;
        if (null == mContext) {
            Log.e((String)TAG, (String)"login:context is null");
            return SPSecIDClientSDK.errorNotInitialized();
        }
        Result result = new Result();
        if (TextUtils.isEmpty((CharSequence)host) || port == 0) {
            result.errorCode = -1;
            result.errorMessage = "\u4f20\u5165\u5730\u5740\u6216\u7aef\u53e3\u9519\u8bef";
            return result;
        }
        Log.d((String)TAG, (String)("login " + host + ":" + port + ", request code is " + req_code));
        if (req_code > 0) {
            authdata.setProperty("req_code", String.valueOf(req_code));
            if (req_code == 3 || req_code == 4) {
                sms_code = authdata.getProperty("check_code_sms", "");
                mail_code = authdata.getProperty("check_code_mail", "");
                Log.d((String)TAG, (String)("check_code_sms is " + sms_code + ", check_code_mail is " + mail_code));
                if (TextUtils.isEmpty((CharSequence)sms_code) || TextUtils.isEmpty((CharSequence)mail_code)) {
                    result.errorCode = -1;
                    result.errorMessage = "\u9a8c\u8bc1\u7801\u672a\u4f20\u5165";
                    return result;
                }
            }
        }
        authdata.setProperty("virus", "1");
        authdata.setProperty("access_token", access_token);
        login_rsp = SPSecID.loginServer(mContext.getApplicationContext(), host, port, authdata);
        errcode = login_rsp.errcode;
        userInfo = login_rsp.data();
        if (userInfo == null) {
            result.errorCode = errcode;
            result.errorMessage = SPSecIDClientSDK.getError(errcode);
            Log.e((String)TAG, (String)("loginServer return null, msg is " + result.errorMessage));
            return result;
        }
        req_code = userInfo.req_code;
        Log.i((String)TAG, (String)("loginServer response errcode is " + errcode + ", req_code is " + req_code));
        result.errorCode = errcode;
        if (errcode == 0) {
            if (userInfo.access_token != null && !userInfo.access_token.isEmpty()) {
                access_token = userInfo.access_token;
            }
            SPSecIDClientSDK.mUID.svr_host = userInfo.host;
            SPSecIDClientSDK.mUID.svr_port = userInfo.port;
            SPSecIDClientSDK.mUID.username = userInfo.username;
            if (req_code == 0) {
                access_token = "";
                SPSecIDClientSDK.saveData(userInfo);
            } else if (req_code == 2) {
                result.errorMessage = "\u9700\u8981\u6740\u6bd2";
            } else if (userInfo.req_code == 3) {
                result.errorCode = 2;
                result.errorMessage = "\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55";
            } else if (userInfo.req_code == 4) {
                result.errorCode = 3;
                result.errorMessage = "\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55";
            } else if (userInfo.req_code == 5) {
                result.errorMessage = "\u9700\u8981\u4fee\u6539\u5bc6\u7801";
            }
        } else {
            result.errorMessage = SPSecIDClientSDK.getError(errcode);
        }
        return result;
    }

    public static void logout() {
        if (null == mContext) {
            Log.e((String)TAG, (String)"logout context is null");
            return;
        }
        Log.i((String)TAG, (String)("logout " + SPSecIDClientSDK.mUID.username + "@" + SPSecIDClientSDK.mUID.svr_host + ":" + SPSecIDClientSDK.mUID.svr_port));
        new Thread(new Runnable(){

            @Override
            public void run() {
                SPSecID.logout(mContext, mUID);
            }
        }).start();
    }

    public static Result generateToken() {
        SPTOtpTokenInfo token_info = null;
        if (null == mContext) {
            Log.e((String)TAG, (String)"generateToken: context is null");
            return SPSecIDClientSDK.errorNotInitialized();
        }
        Log.i((String)TAG, (String)("generateToken " + SPSecIDClientSDK.mUID.username + "@" + SPSecIDClientSDK.mUID.svr_host + ":" + SPSecIDClientSDK.mUID.svr_port));
        token_info = SPSecID.totpGenerateToken(mUID);
        Result result = new Result();
        result.errorCode = token_info.errcode;
        result.errorMessage = SPSecIDClientSDK.getError(token_info.errcode);
        result.data.put(RESPONSE_OTP, token_info.token);
        result.data.put(RESPONSE_OTP_TIME_LEFT, (Object)token_info.left);
        Log.i((String)TAG, (String)("totpGenerateToken errcode is " + SPSecIDClientSDK.getError(token_info.errcode) + ", totp is " + token_info.token + ", left is " + token_info.left));
        return result;
    }

    private static Result errorNotInitialized() {
        Result r = new Result();
        r.errorCode = -1;
        r.errorMessage = "\u672a\u521d\u59cb\u5316";
        return r;
    }

    private static SPSecIDUID loadData() {
        SPSecIDUID secIDUID = new SPSecIDUID();
        if (sp == null) {
            Log.e((String)TAG, (String)"loadData: sp is null");
            return null;
        }
        secIDUID.svr_host = sp.getString(DATA_SVR_HOST, "");
        secIDUID.svr_port = sp.getInt(DATA_SVR_PORT, 443);
        secIDUID.username = sp.getString("username", "");
        secIDUID.otp_offline = sp.getBoolean(DATA_OTP_OFFLINE, false);
        secIDUID.offset_time = sp.getLong(DATA_OFFSET_TIME, 0L);
        Log.i((String)TAG, (String)("loadData: svr_host[" + secIDUID.svr_host + "], svr_port[" + secIDUID.svr_port + "], username[" + secIDUID.username + "], otp_offline[" + secIDUID.otp_offline + "], offset_time[" + secIDUID.offset_time + "]"));
        return secIDUID;
    }

    private static void saveData(SPSecIDUserInfo userInfo) {
        SharedPreferences.Editor editor = null;
        if (sp == null) {
            Log.e((String)TAG, (String)"saveData sp is null");
            return;
        }
        editor = sp.edit();
        editor.putString(DATA_SVR_HOST, userInfo.host);
        editor.putInt(DATA_SVR_PORT, userInfo.port);
        editor.putString("username", userInfo.username);
        editor.putBoolean(DATA_OTP_OFFLINE, userInfo.otp_offline);
        editor.putLong(DATA_OFFSET_TIME, userInfo.otp_offset);
        editor.apply();
    }

    public static synchronized String getError(int msgid) {
        String msg;
        if (ErrCode.size() < 1) {
            SPSecIDClientSDK.init();
        }
        msg = null != (msg = (String)ErrCode.get(msgid &= 0xFFFFFFF)) ? msg : Integer.toHexString(msgid);
        return msg;
    }

    private static void init() {
        ErrCode.put(0x2000402, (Object)"\u8ba4\u8bc1\u670d\u52a1\u5668\u4e0d\u53ef\u8fbe");
        ErrCode.put(0x2000404, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000401, (Object)"\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778242, (Object)"\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778243, (Object)"\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000404, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778245, (Object)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        ErrCode.put(16778246, (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        ErrCode.put(16778247, (Object)"Root\u8bbe\u5907\u7981\u6b62\u8bbf\u95ee");
        ErrCode.put(16778248, (Object)"\u767b\u5f55\u6d41\u7a0b\u9519\u8bef");
        ErrCode.put(16778249, (Object)"\u53d1\u73b0\u75c5\u6bd2\uff0c\u8bf7\u6740\u6bd2\u540e\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778250, (Object)"\u7f51\u5173\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778251, (Object)"\u7f51\u5173\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778252, (Object)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5931\u6548");
        ErrCode.put(16778253, (Object)"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5931\u6548");
        ErrCode.put(16778254, (Object)"\u8bbe\u5907\u7ed1\u5b9a\u5931\u8d25");
        ErrCode.put(16778255, (Object)"\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(0x1000410, (Object)"\u8ba4\u8bc1\u670d\u52a1\u5668\u4e0d\u53ef\u8fbe");
        ErrCode.put(0x1000411, (Object)"\u8bbe\u5907\u7ed1\u5b9a\u5931\u8d25");
        ErrCode.put(16778258, (Object)"\u5f53\u524d\u7ec8\u7aef\u88ab\u7ba1\u7406\u5458\u6ce8\u9500\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ErrCode.put(16778259, (Object)"\u5f53\u524d\u7ec8\u7aef\u88ab\u7ba1\u7406\u5458\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000414, (Object)"\u5907\u4efd\u670d\u52a1\u5173\u95ed");
        ErrCode.put(16778262, (Object)"\u65e0\u6548\u4e8c\u7ef4\u7801");
        ErrCode.put(16778264, (Object)"\u65e0\u6548\u4e8c\u7ef4\u7801");
        ErrCode.put(16778265, (Object)"\u4e8c\u7ef4\u7801\u8d85\u65f6");
        ErrCode.put(16778266, (Object)"\u65e0\u6548\u9a8c\u8bc1\u7801");
        ErrCode.put(16778267, (Object)"\u65e0\u6548\u9a8c\u8bc1\u7801");
        ErrCode.put(16778268, (Object)"\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e");
        ErrCode.put(16778269, (Object)"\u5bc6\u7801\u9519\u8bef");
        ErrCode.put(16778270, (Object)"\u65b0\u65e7\u5bc6\u7801\u76f8\u540c");
        ErrCode.put(16778271, (Object)"\u7981\u6b62\u4fee\u6539\u5bc6\u7801");
        ErrCode.put(16778272, (Object)"\u7528\u6237\u8bbe\u5907\u7ed1\u5b9a\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778273, (Object)"\u8bb8\u53ef\u4f7f\u7528\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778274, (Object)"\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778275, (Object)"\u8d26\u53f7\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778276, (Object)"\u4e0d\u5141\u8bb8\u4ece\u5f53\u524d\u7f51\u7edc\u767b\u5f55\uff0c\u8bf7\u5207\u6362\u63a5\u5165\u7f51\u7edc\u518d\u5c1d\u8bd5");
        ErrCode.put(16778277, (Object)"\u9a8c\u8bc1\u65e7\u5bc6\u7801\u5931\u8d25");
        ErrCode.put(16778278, (Object)"\u672a\u914d\u7f6e\u6709\u6548\u624b\u673a\u53f7\u7801\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778279, (Object)"\u672a\u914d\u7f6e\u6709\u6548\u90ae\u7bb1\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778289, (Object)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        ErrCode.put(16778295, (Object)"\u7528\u6237\u8bb8\u53ef\u4f7f\u7528\u6570\u5df2\u8fbe\u4e0a\u9650");
        ErrCode.put(16778296, (Object)"\u5e94\u7528\u7684\u52a8\u6001\u53e3\u4ee4\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778297, (Object)"\u5e94\u7528\u7684\u4e8c\u7ef4\u7801\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778298, (Object)"\u5e94\u7528\u7684\u5b89\u5168\u4ee4\u724c\u670d\u52a1\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(16778299, (Object)"\u672a\u6388\u6743\u8bbf\u95ee\u8be5\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000441, (Object)"\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ErrCode.put(0x1000444, (Object)"\u975e\u5e38\u7528\u8bbe\u5907");
        ErrCode.put(16778309, (Object)"\u4ee4\u724c\u5df2\u8fc7\u671f");
        ErrCode.put(16778310, (Object)"\u975e\u5e38\u7528\u8bbe\u5907\uff0c\u8bf7\u53bb\u67dc\u53f0\u529e\u7406");
        ErrCode.put(16778311, (Object)"\u65e0\u6548\u7684\u63a8\u9001\u8bf7\u6c42");
        ErrCode.put(16778312, (Object)"\u63a8\u9001\u8bf7\u6c42\u5df2\u8d85\u65f6");
        ErrCode.put(16778320, (Object)"\u63a8\u9001\u8bf7\u6c42\u5df2\u88ab\u5904\u7406");
        ErrCode.put(16778322, (Object)"\u89e3\u7ed1\u8bbe\u5907\u5931\u8d25");
        ErrCode.put(0xFFFFFFF, (Object)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25");
    }

    public static class Result {
        public int errorCode = -1;
        public String errorMessage = "";
        public Properties data = new Properties();
    }
}

