/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.sdk;

import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.secid.SPSecIDClient;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;

public class LibSecIDSDKLite {
    public static final String SECID_PACKAGE_NAME_NEW = "com.esg360.id";
    public static final String SECID_PACKAGE_NAME_OLD = "com.secure.secid";
    private static final String SECID_MAIN_ACTIVITY = "com.secure.secid.activity.HomeActivity";
    public static final int REQUEST_CODE_LOGIN = 36021;
    public static final int REQUEST_CODE_LOGOUT = 36022;
    public static final int REQUEST_CODE_AUTH_APP = 36023;
    public static final int REQUEST_CODE_GEN_TOKEN = 36024;
    public static final int REQUEST_CODE_GET_AUTHCODE = 36025;
    private static final String REQUEST_CMD_LOGIN = "login";
    private static final String REQUEST_CMD_LOGOUT = "logout";
    public static final String REQUEST_CMD_AUTH_APP = "authorize_app";
    public static final String REQUEST_CMD_GEN_TOKEN = "generate_token";
    public static final String REQUEST_CMD_GET_AUTHCODE = "get_authcode";
    public static final String KEY_SECID_ERRCODE = "secid_errcode";
    public static final String KEY_SECID_ERRMSG = "secid_errmsg";
    public static final String KEY_TOTP_TOKEN = "totp_token";
    public static final String KEY_TOTP_EXPIRES = "totp_expires";
    public static final String KEY_REQUEST_CMD = "secid_requset_cmd";
    public static final String KEY_REQUEST_TIME = "secid_request_time";
    public static final String KEY_REQUEST_PKGNAME = "secid_requset_pkgname";
    public static final String KEY_SECID_APP_PKGNAME = "secid_app_pkgname";
    public static final String KEY_SECID_APP_SIGHASH = "secid_app_sighash";
    public static final String KEY_SECID_POPUP = "secid_popup";
    public static final String KEY_SECID_HOST = "secid_svr_host";
    public static final String KEY_SECID_PORT = "secid_svr_port";
    public static final String KEY_SECID_USERNAME = "secid_username";
    public static final String KEY_SECID_PASSWORD = "secid_password";
    public static final String KEY_SECID_TOTP_TOKEN = "totp_token";
    public static final String KEY_SECID_TOTP_EXPIRES = "totp_expires";
    public static final String KEY_SECID_VERIFY_CODE = "secid_verify_code";
    public static final String KEY_SECID_APP_QRCODE = "secid_app_qrcode";
    public static final String KEY_SECID_APP_UNAME = "secid_app_uname";
    public static final String KEY_SECID_APP_PASSW = "secid_app_passw";
    public static final String KEY_SECID_AUTHCODE = "secid_authcode";
    public static final String KEY_SECID_AUTHCODE_TTL = "secid_authcode_ttl";
    public static final String KEY_SECID_AUTHCODE_JSONARRAY = "secid_authcode_jsonarray";
    public static final int ERR_SECID_LAUNCH_FAILED = 251658753;
    public static final int ERR_SECID_NOT_INSTALLED = 0xF000202;
    public static final int ERR_SECID_UNKOWN = 251658755;
    public static String secid_oem_package_name = "";
    private static Context mContext = null;

    private static boolean secIDInstalled(Context context) {
        if (TextUtils.isEmpty((CharSequence)secid_oem_package_name)) {
            return LibSecIDSDKLite.secIDInstalled(context, SECID_PACKAGE_NAME_NEW) || LibSecIDSDKLite.secIDInstalled(context, SECID_PACKAGE_NAME_OLD);
        }
        return LibSecIDSDKLite.secIDInstalled(context, secid_oem_package_name);
    }

    private static boolean secIDInstalled(Context context, String pkg_name) {
        try {
            context.getPackageManager().getPackageInfo(pkg_name, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static boolean secIDRunning(Context context) {
        block2: {
            Uri uri = Uri.parse((String)("content://" + LibSecIDSDKLite.getSecidProviderName(context)));
            try {
                context.getContentResolver().call(uri, "probe", null, null);
            }
            catch (IllegalArgumentException ex) {
                if (!ex.getMessage().startsWith("Unknown URI content://")) break block2;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int launchSecID(Object reqObj, String cmd, Bundle data, int reuestCode) {
        boolean hasv4 = true;
        String secid_pkg_name = "";
        try {
            if (!(reqObj instanceof android.support.v4.app.Fragment)) {
                // empty if block
            }
        }
        catch (Exception ex) {
            hasv4 = false;
        }
        Activity activity = null;
        if (reqObj instanceof Activity) {
            activity = (Activity)reqObj;
        } else if (reqObj instanceof Fragment) {
            activity = ((Fragment)reqObj).getActivity();
        } else {
            if (!hasv4) return 251658753;
            if (!(reqObj instanceof android.support.v4.app.Fragment)) return 251658753;
            activity = ((android.support.v4.app.Fragment)reqObj).getActivity();
        }
        try {
            secid_pkg_name = LibSecIDSDKLite.SecidPkgName((Context)activity);
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setComponent(new ComponentName(secid_pkg_name, SECID_MAIN_ACTIVITY));
            if (activity.getPackageManager().resolveActivity(intent, 0) == null) {
                return 251658753;
            }
            if (null != data) {
                intent.putExtras(data);
            }
            intent.putExtra(KEY_REQUEST_CMD, cmd);
            intent.putExtra(KEY_REQUEST_TIME, System.currentTimeMillis());
            intent.putExtra("package_name", activity.getPackageName());
            intent.putExtra(KEY_REQUEST_PKGNAME, activity.getPackageName());
            if (reqObj instanceof Fragment) {
                ((Fragment)reqObj).startActivityForResult(intent, reuestCode);
                return 0;
            }
            if (hasv4 && reqObj instanceof android.support.v4.app.Fragment) {
                ((android.support.v4.app.Fragment)reqObj).startActivityForResult(intent, reuestCode);
                return 0;
            }
            activity.startActivityForResult(intent, reuestCode);
            return 0;
        }
        catch (Exception exception) {
            if (!LibSecIDSDKLite.secIDInstalled((Context)activity)) return 0xF000202;
            return 251658753;
        }
    }

    private static void putBundleStr(Bundle bundle, String name, String value) {
        bundle.putString(name, null != value ? value : "");
    }

    private static void putBundleInt(Bundle bundle, String name, int value, String defv) {
        bundle.putString(name, value > 0 ? String.valueOf(value) : defv);
    }

    private static String formatUserID(String svr_host, int svr_port, String username) {
        return String.format(Locale.ENGLISH, "%s@%s:%d", null != username ? username : "", null != svr_host ? svr_host : "", svr_port > 0 ? svr_port : 443);
    }

    private static int generateTokenImpl(Object reqObj, String svr_host, int svr_port, String username, boolean popup) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_HOST, svr_host);
        LibSecIDSDKLite.putBundleInt(data, KEY_SECID_PORT, svr_port, "");
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_USERNAME, username);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_POPUP, popup ? "1" : "0");
        return LibSecIDSDKLite.launchSecID(reqObj, REQUEST_CMD_GEN_TOKEN, data, 36024);
    }

    private static int authorizeAppImpl(Object reqObj, String svr_host, int svr_port, String username, String qrcode, String app_uname, String app_passw) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_HOST, svr_host);
        LibSecIDSDKLite.putBundleInt(data, KEY_SECID_PORT, svr_port, "");
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_USERNAME, username);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_QRCODE, qrcode);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_UNAME, app_uname);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_PASSW, app_passw);
        return LibSecIDSDKLite.launchSecID(reqObj, REQUEST_CMD_AUTH_APP, data, 36023);
    }

    private static int getLaunchAuthCodeImpl(Object reqObj, String svr_host, int svr_port, String username, String pkgname, boolean popup) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_HOST, svr_host);
        LibSecIDSDKLite.putBundleInt(data, KEY_SECID_PORT, svr_port, "");
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_USERNAME, username);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_PKGNAME, pkgname);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_SIGHASH, SPStringUtil.md5(SPSystemUtil.getSignature(mContext, pkgname)));
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_POPUP, popup ? "1" : "0");
        return LibSecIDSDKLite.launchSecID(reqObj, REQUEST_CMD_GET_AUTHCODE, data, 36025);
    }

    public static void setOemPackageName(String pkgname) {
        secid_oem_package_name = SPStringUtil.opt(pkgname);
    }

    public static int login(Activity activity, String svr_host, int svr_port, String username, String password) {
        mContext = activity.getApplicationContext();
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_HOST, svr_host);
        LibSecIDSDKLite.putBundleInt(data, KEY_SECID_PORT, svr_port, "");
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_USERNAME, username);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_PASSWORD, password);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_VERIFY_CODE, "");
        return LibSecIDSDKLite.launchSecID(activity, REQUEST_CMD_LOGIN, data, 36021);
    }

    public static int logout(Activity activity, String svr_host, int svr_port, String username) {
        mContext = activity.getApplicationContext();
        return LibSecIDSDKLite.launchSecID(activity, REQUEST_CMD_LOGOUT, null, 36022);
    }

    public static int generateToken(Activity activity, String svr_host, int svr_port, String username, boolean popup) {
        mContext = activity.getApplicationContext();
        return LibSecIDSDKLite.generateTokenImpl(activity, svr_host, svr_port, username, popup);
    }

    public static int generateToken(Fragment fragment, String svr_host, int svr_port, String username, boolean popup) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.generateTokenImpl(fragment, svr_host, svr_port, username, popup);
    }

    public static int generateToken(android.support.v4.app.Fragment fragment, String svr_host, int svr_port, String username, boolean popup) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.generateTokenImpl(fragment, svr_host, svr_port, username, popup);
    }

    public static int authorizeApp(Fragment fragment, String svr_host, int svr_port, String username, String qrcode, String app_uname, String app_passw) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.authorizeAppImpl(fragment, svr_host, svr_port, username, qrcode, app_uname, app_passw);
    }

    public static int authorizeApp(android.support.v4.app.Fragment fragment, String svr_host, int svr_port, String username, String qrcode, String app_uname, String app_passw) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.authorizeAppImpl(fragment, svr_host, svr_port, username, qrcode, app_uname, app_passw);
    }

    public static int authorizeApp(Activity activity, String svr_host, int svr_port, String username, String qrcode, String app_uname, String app_passw) {
        mContext = activity.getApplicationContext();
        return LibSecIDSDKLite.authorizeAppImpl(activity, svr_host, svr_port, username, qrcode, app_uname, app_passw);
    }

    public static int getLaunchAuthCode(Fragment fragment, String svr_host, int svr_port, String username, String pkgname, boolean popup) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.getLaunchAuthCodeImpl(fragment, svr_host, svr_port, username, pkgname, popup);
    }

    public static int getLaunchAuthCode(android.support.v4.app.Fragment fragment, String svr_host, int svr_port, String username, String pkgname, boolean popup) {
        mContext = fragment.getActivity().getApplicationContext();
        return LibSecIDSDKLite.getLaunchAuthCodeImpl(fragment, svr_host, svr_port, username, pkgname, popup);
    }

    public static int getLaunchAuthCode(Activity activity, String svr_host, int svr_port, String username, String pkgname, boolean popup) {
        mContext = activity.getApplicationContext();
        return LibSecIDSDKLite.getLaunchAuthCodeImpl(activity, svr_host, svr_port, username, pkgname, popup);
    }

    public static int getAuthCode(Context context, String svr_host, int svr_port, String username, ArrayList<String> pkg_names, boolean popup) {
        String packageNames = "";
        mContext = context.getApplicationContext();
        if (pkg_names != null && pkg_names.size() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (String pName : pkg_names) {
                jsonArray.put((Object)pName);
            }
            packageNames = jsonArray.toString();
        }
        return LibSecIDSDKLite.getLaunchAuthCodeImpl(context, svr_host, svr_port, username, packageNames, popup);
    }

    private static void silentInvokeMsg(final Context context, String cmd, String svr_host, int svr_port, String username, Bundle data, final OnLibSecIDSDKCallback callback) {
        String secid_pkg_name = "";
        if (!LibSecIDSDKLite.secIDInstalled(context)) {
            if (null != callback) {
                callback.onLibSecIDSDKResponse(0xF000202, "\u8bf7\u5b89\u88c5\u5e76\u8fd0\u884cID", null);
            }
            return;
        }
        secid_pkg_name = LibSecIDSDKLite.SecidPkgName(context);
        if (!LibSecIDSDKLite.secIDRunning(context)) {
            SPIntentUtil.loadApp(context, secid_pkg_name, SECID_MAIN_ACTIVITY, null);
            SPSystemUtil.sleepEx(2000L);
        }
        final Bundle reqdata = new Bundle();
        reqdata.putString(KEY_SECID_HOST, SPStringUtil.opt(svr_host));
        reqdata.putString(KEY_SECID_PORT, svr_port < 0 ? "" : String.valueOf(svr_port));
        reqdata.putString(KEY_SECID_USERNAME, SPStringUtil.opt(username));
        reqdata.putString(KEY_REQUEST_CMD, SPStringUtil.opt(cmd));
        reqdata.putString(KEY_REQUEST_TIME, "" + System.currentTimeMillis());
        reqdata.putString(KEY_REQUEST_PKGNAME, context.getPackageName());
        if (null != data) {
            reqdata.putAll(data);
        }
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPSecIDClient.request(context, reqdata.getString(LibSecIDSDKLite.KEY_REQUEST_CMD), reqdata, callback);
                }
            }.start();
        } else {
            SPSecIDClient.request(context, reqdata.getString(KEY_REQUEST_CMD), reqdata, callback);
        }
    }

    private static void silentInvoke(final Context context, final String cmd, final String svr_host, final int svr_port, final String username, final Bundle data, final OnLibSecIDSDKCallback callback) {
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    LibSecIDSDKLite.silentInvoke(context, cmd, svr_host, svr_port, username, data, callback);
                }
            }.start();
        } else {
            SilentResult result;
            block12: {
                result = new SilentResult();
                if (LibSecIDSDKLite.secIDInstalled(context)) {
                    if (!LibSecIDSDKLite.secIDRunning(context)) {
                        result.errcode = 251658753;
                        result.errmsg = "\u8bf7\u5148\u624b\u52a8\u8fd0\u884cID";
                    } else {
                        try {
                            Bundle reqdata = new Bundle();
                            if (null != data) {
                                reqdata.putAll(data);
                            }
                            reqdata.putString(KEY_SECID_HOST, SPStringUtil.opt(svr_host));
                            reqdata.putString(KEY_SECID_PORT, svr_port < 0 ? "" : String.valueOf(svr_port));
                            reqdata.putString(KEY_SECID_USERNAME, username);
                            reqdata.putString(KEY_REQUEST_CMD, cmd);
                            reqdata.putString(KEY_REQUEST_TIME, "" + System.currentTimeMillis());
                            reqdata.putString(KEY_REQUEST_PKGNAME, context.getPackageName());
                            ContentResolver resolver = context.getContentResolver();
                            Uri uri = Uri.parse((String)("content://" + LibSecIDSDKLite.getSecidProviderName(context)));
                            result.rspdata = resolver.call(uri, cmd, null, reqdata);
                            if (null == result.rspdata) {
                                throw new Exception("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42");
                            }
                            result.errcode = result.rspdata.getInt(KEY_SECID_ERRCODE, 0);
                            result.errmsg = result.rspdata.getString(KEY_SECID_ERRMSG, "");
                        }
                        catch (Exception ex) {
                            PLog.v(ex);
                            if (ex instanceof IllegalArgumentException && ex.getMessage().startsWith("Unknown URI content://")) {
                                result.errcode = 251658753;
                                result.errmsg = "\u8bf7\u5148\u8fd0\u884cID";
                                break block12;
                            }
                            result.errcode = 251658755;
                            result.errmsg = "\u672a\u77e5\u9519\u8bef[" + ex.getLocalizedMessage() + "]";
                        }
                    }
                } else {
                    result.errcode = 0xF000202;
                    result.errmsg = "\u8bf7\u5b89\u88c5\u5e76\u8fd0\u884cID";
                }
            }
            if (null != callback) {
                SPIntentUtil.runOnMainThread(new SPRunnable<SilentResult>(result){

                    @Override
                    public void run() {
                        callback.onLibSecIDSDKResponse(((SilentResult)this.mUserObject).errcode, ((SilentResult)this.mUserObject).errmsg, ((SilentResult)this.mUserObject).rspdata);
                    }
                }, 10L);
            }
        }
    }

    public static void silentGetLaunchAuthCode(Context context, String svr_host, int svr_port, String username, String pkgname, OnLibSecIDSDKCallback callback) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_PKGNAME, pkgname);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_SIGHASH, SPStringUtil.md5(SPSystemUtil.getSignature(mContext, pkgname)));
        LibSecIDSDKLite.silentInvoke(context, REQUEST_CMD_GET_AUTHCODE, svr_host, svr_port, username, data, callback);
    }

    public static void silentGetAuthCode(Context context, String pkgname, OnLibSecIDSDKCallback callback) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_PKGNAME, pkgname);
        LibSecIDSDKLite.putBundleStr(data, KEY_SECID_APP_SIGHASH, SPStringUtil.md5(SPSystemUtil.getSignature(mContext, pkgname)));
        LibSecIDSDKLite.silentInvoke(context, REQUEST_CMD_GET_AUTHCODE, "", 0, "", data, callback);
    }

    public static void silentGetOtp(Context context, OnLibSecIDSDKCallback callback) {
        Bundle data = new Bundle();
        LibSecIDSDKLite.silentInvoke(context, REQUEST_CMD_GEN_TOKEN, "", 0, "", data, callback);
    }

    private static String SecidPkgName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)secid_oem_package_name) && LibSecIDSDKLite.secIDInstalled(context, secid_oem_package_name)) {
            return secid_oem_package_name;
        }
        if (LibSecIDSDKLite.secIDInstalled(context, SECID_PACKAGE_NAME_NEW)) {
            return SECID_PACKAGE_NAME_NEW;
        }
        if (LibSecIDSDKLite.secIDInstalled(context, SECID_PACKAGE_NAME_OLD)) {
            return SECID_PACKAGE_NAME_OLD;
        }
        return SECID_PACKAGE_NAME_NEW;
    }

    public static String getSecidProviderName(Context context) {
        return LibSecIDSDKLite.SecidPkgName(context) + ".provider";
    }

    private static class SilentResult {
        int errcode = 0;
        String errmsg = "";
        Bundle rspdata = null;

        private SilentResult() {
        }
    }

    public static interface OnLibSecIDSDKCallback {
        public void onLibSecIDSDKResponse(int var1, String var2, Bundle var3);
    }
}

