/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.jni;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.PLog;
import com.secure.comm.SPLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.net.SPIPRange;
import com.secure.comm.net.SPInetAddress;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPRunnable;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.IPHost;
import com.secure.sportal.entry.SPLoadItem;
import com.secure.sportal.entry.SPMsgRspEmpty;
import com.secure.sportal.entry.SPProxyServerOption;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPUserPolicy;
import com.secure.sportal.gateway.GatewayLink;
import com.secure.sportal.jni.LibSecurePortal;
import com.secure.sportal.sdk.vpn.SPNCService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPLibBridge {
    public static final int MODE_RELAY = 0;
    public static final int MODE_PROXY_PROXY = 16;
    public static final int MODE_PROXY_MAPPING = 17;
    public static final int SSL_FLAG_TWOWAY = 16;
    public static final int SSL_FLAG_SMX_SM1 = 1;
    public static final int SSL_FLAG_SMX_SM2 = 2;
    public static final int SSL_FLAG_SMX_SM3 = 3;
    public static final int SSL_FLAG_SMX_SM4 = 4;
    private static AtomicBoolean _initialized = new AtomicBoolean(false);
    private static AtomicInteger _jsonrpc_id = new AtomicInteger(1);
    private static List<JRPCTask> _jsonrpc_tasks = Collections.synchronizedList(new ArrayList());

    public static boolean initLibrary(Context context) {
        if (!_initialized.get()) {
            _initialized.set(true);
            new Thread(new SPRunnable<Context>(context.getApplicationContext()){

                @Override
                public void run() {
                    LibSecurePortal.systemLoadLibrary("xwalkcore");
                    LibSecurePortal.systemLoadLibrary("xwalkdummy");
                    SPLibBridge.exeCmdEx("", new JSONObject());
                    try {
                        SPFileUtil.probeStorage((Context)this.mUserObject);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Map<String, String> devinfo = SPDeviceUtil.getDeviceInfo((Context)this.mUserObject);
                    JSONObject json = new JSONObject();
                    SPJSONUtil.put(json, "os", "Android");
                    SPJSONUtil.put(json, "os_version", Build.VERSION.RELEASE);
                    SPJSONUtil.put(json, "dev_model", Build.MODEL);
                    SPJSONUtil.put(json, "dev_id", devinfo.get("devid"));
                    SPJSONUtil.put(json, "dev_imei", devinfo.get("imei"));
                    SPJSONUtil.put(json, "pkgname", LibSecurePortal.jniGetValue((Context)this.mUserObject, "packagename"));
                    SPJSONUtil.put(json, "wifi_mac", LibSecurePortal.jniGetValue((Context)this.mUserObject, "wifi_mac"));
                    SPJSONUtil.put(json, "os_version_code", Build.VERSION.SDK_INT);
                    SPJSONUtil.put(json, "android_id", LibSecurePortal.jniGetValue((Context)this.mUserObject, "android_id"));
                    SPJSONUtil.put(json, "app_priv_path", LibSecurePortal.jniGetValue((Context)this.mUserObject, "private_dir"));
                    String logfilepath = SPFileUtil.getSdCardPath() + "/Android/data/" + ((Context)this.mUserObject).getPackageName() + "/logs/";
                    File pathfile = new File(logfilepath);
                    pathfile.mkdirs();
                    SPJSONUtil.put(json, "log_dir", pathfile.getAbsolutePath());
                    SPJSONUtil.put(json, "droid_sdcard", SPFileUtil.getSdCardPath());
                    SPJSONUtil.put(json, "droid_extsdcard", SPFileUtil.getExtSdCardPath((Context)this.mUserObject));
                    SPJSONUtil.put(json, "droid_native_dir", SPSystemUtil.getNativeLibraryDir((Context)this.mUserObject));
                    SPLibBridge.exeCmd("sys_set_info", json.toString());
                    SPMsgRspEmpty rsp = SPLibBridge.exeCmdEx("get_debug", new JSONObject());
                    boolean isDebug = rsp.json.optInt("debug") == 1;
                    SPLog.setLevelByName(rsp.json.optString("log_level_name"));
                    SPSystemUtil.sleepEx(200L);
                    String sslconf = SPFileUtil.readAssetsText((Context)this.mUserObject, "sportal_ssl.conf");
                    if (!TextUtils.isEmpty((CharSequence)sslconf)) {
                        json = SPJSONUtil.parseObject(sslconf);
                        JSONArray jfps = (JSONArray)json.opt("fingerprints");
                        for (int i = 0; null != jfps && i < jfps.length(); ++i) {
                            try {
                                JSONObject jfp = (JSONObject)jfps.get(i);
                                String host = jfp.optString("host");
                                if (null == host) {
                                    jfp.optString("hostname");
                                }
                                SPLibBridge.putSSLFingerprint(host, jfp.optInt("port", 443), jfp.optString("fingerprint"));
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    SPLibBridge.performPendingTasks();
                }
            }).start();
            SPSystemUtil.sleepEx(50L);
            SPLibBridge.getProxyPort();
            return false;
        }
        return true;
    }

    public static int exeCmd(String cmd, String param, byte[] rspbytes) {
        int len = null != rspbytes ? rspbytes.length : 0;
        return LibSecurePortal.nativeExeCmd(cmd, TextUtils.isEmpty((CharSequence)param) ? "{}" : param, rspbytes, len);
    }

    public static SPMsgRspEmpty exeCmdEx(String cmd, JSONObject json) {
        PLog.v("SPLibBridge.exeCmdEx cmd=%s, json=%s", cmd, null != json ? json.toString() : "");
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        byte[] rspbytes = new byte[10240];
        rsp.errcode = SPLibBridge.exeCmd(cmd, null != json ? json.toString() : "{}", rspbytes);
        rsp.json = SPJSONUtil.parseObject(new String(rspbytes));
        rsp.errcode = rsp.json.optInt("_errcode", 0);
        rsp.errmsg = rsp.json.optString("_errmsg");
        return rsp;
    }

    private static int exeCmd(String cmd, String param) {
        return SPLibBridge.exeCmd(cmd, TextUtils.isEmpty((CharSequence)param) ? "{}" : param, null);
    }

    private static int exeCmd(String cmd) {
        return SPLibBridge.exeCmd(cmd, "{}", null);
    }

    public static int getProxyPort() {
        int port = LibSecurePortal.nativeGetPort(16, "", 0);
        for (int i = 0; i < 20 && port == 0; ++i) {
            SPSystemUtil.sleepEx(50L);
            port = LibSecurePortal.nativeGetPort(16, "", 0);
        }
        return port;
    }

    public static int openProxyMapping(int svcid, String dst_ip, int dst_port) {
        return LibSecurePortal.nativeGetPort(17, dst_ip, dst_port);
    }

    public static void setVpnAddress(String hostname, int port, String sni, boolean fixed) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "vpn_host", hostname);
        SPJSONUtil.put(json, "vpn_port", port);
        SPJSONUtil.put(json, "vpn_sni", sni);
        SPJSONUtil.put(json, "vpn_ip_fixed", fixed || SPOEM.isHostResolveOnce() ? "1" : "0");
        SPRunnable<String> r = new SPRunnable<String>(json.toString()){

            @Override
            public void run() {
                SPLibBridge.exeCmd("session_set_vpn", (String)this.mUserObject);
            }
        };
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(r).start();
        } else {
            r.run();
        }
    }

    public static void setBypass(final List<SPInetAddress> addresses, final List<String> pkgnames) {
        Thread executor = new Thread(){

            @Override
            public void run() {
                JSONObject json_req = new JSONObject();
                JSONArray addrList = new JSONArray();
                if (null != addresses && addresses.size() > 0) {
                    for (SPInetAddress addr : addresses) {
                        JSONObject obj = new JSONObject();
                        SPJSONUtil.put(obj, "ip", addr.ip);
                        SPJSONUtil.put(obj, "port", "tcp:" + addr.port1 + "-" + addr.port2);
                        addrList.put((Object)obj);
                    }
                }
                SPJSONUtil.put(json_req, "address", addrList);
                JSONArray pkgList = new JSONArray();
                if (null != pkgnames && pkgnames.size() > 0) {
                    for (String pkg : pkgnames) {
                        pkgList.put((Object)pkg);
                    }
                }
                SPJSONUtil.put(json_req, "pkgname", pkgList);
                SPLibBridge.exeCmd("session_set_bypass", json_req.toString());
            }
        };
        if (SPSystemUtil.isRunInMainThread()) {
            executor.start();
        } else {
            executor.run();
        }
    }

    public static void setUserData(final int uid, final Properties usrinfo, final List<SPServiceInfo> svcList, final List<IPHost> iphosts, final SPUserPolicy policy, final List<SPLoadItem> loads, final SPProxyServerOption _proxyOption) {
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPLibBridge.setUserData(uid, usrinfo, svcList, iphosts, policy, loads, _proxyOption);
                }
            }.start();
            return;
        }
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "uid", Integer.toString(uid));
        if (uid > 0) {
            SPJSONUtil.put(json_req, "oem_name", SPApplication.oemName());
            SPJSONUtil.put(json_req, "dns_gateway", SPNCService.DNS_GATEWAY ? "1" : "0");
            SPJSONUtil.put(json_req, "eid", usrinfo.getProperty("eid", ""));
            SPJSONUtil.put(json_req, "auth_type", usrinfo.getProperty("auth_type", ""));
            SPJSONUtil.put(json_req, "username", usrinfo.getProperty("username", ""));
            SPJSONUtil.put(json_req, "ticket", usrinfo.getProperty("ticket", ""));
            SPJSONUtil.put(json_req, "proto_version", usrinfo.getProperty("proto_version", ""));
            String login_json = usrinfo.getProperty("login_json", "");
            if (!TextUtils.isEmpty((CharSequence)login_json)) {
                if (login_json.charAt(0) == '{') {
                    login_json = Base64.encodeToString((byte[])login_json.getBytes(), (int)2);
                }
                SPJSONUtil.put(json_req, "login_json", login_json);
            }
            SPJSONUtil.put(json_req, "tunnel_block_tlv", usrinfo.getProperty("tunnel_block_tlv", "0"));
            String cipher = usrinfo.getProperty("sslsmx_cipher", "");
            int ssl_smx = GatewayLink.getSSLSMXVersion(cipher);
            SPJSONUtil.put(json_req, "sslsmx_enable", String.valueOf(ssl_smx));
            SPJSONUtil.put(json_req, "sslsmx_version", String.valueOf(ssl_smx));
            SPJSONUtil.put(json_req, "sslsmx_alg_cipher", cipher);
            SPJSONUtil.put(json_req, "vspace_enable", policy.vspaceEnable ? "1" : "0");
            SPJSONUtil.put(json_req, "vspace_algo", policy.vspaceAlgo);
            SPJSONUtil.put(json_req, "net_hook_enable", usrinfo.getProperty("net_hook_enable", "1"));
            JSONArray json_services = new JSONArray();
            for (SPServiceInfo sPServiceInfo : svcList) {
                json_services.put((Object)sPServiceInfo.toJSON());
            }
            SPJSONUtil.put(json_req, "service", json_services);
            JSONArray json_iphosts = new JSONArray();
            for (IPHost iPHost : iphosts) {
                json_iphosts.put((Object)(iPHost.ip + " " + iPHost.host));
            }
            SPJSONUtil.put(json_req, "hosts", json_iphosts);
            SPJSONUtil.put(json_req, "inet_blocking_enable", policy.inetBlockingEnable ? "1" : "0");
            JSONArray jSONArray = new JSONArray();
            for (SPIPRange sPIPRange : policy.inetBlockingBlackList) {
                jSONArray.put((Object)(SPIPUtil.longToIP(sPIPRange.start) + "-" + SPIPUtil.longToIP(sPIPRange.end)));
            }
            SPJSONUtil.put(json_req, "inet_blocking_blacks", jSONArray);
            JSONArray jSONArray2 = new JSONArray();
            if (null != loads) {
                for (SPLoadItem item : loads) {
                    JSONObject load = new JSONObject();
                    SPJSONUtil.put(load, "host", item.host);
                    SPJSONUtil.put(load, "port", String.valueOf(item.port));
                    SPJSONUtil.put(load, "load", String.valueOf(item.load));
                }
            }
            SPJSONUtil.put(json_req, "loads", jSONArray2);
            SPProxyServerOption sPProxyServerOption = null == _proxyOption ? new SPProxyServerOption().initialize() : _proxyOption;
            SPJSONUtil.put(json_req, "proxy_option", sPProxyServerOption.toJSON());
            JSONArray json_vpwhites = new JSONArray();
            JSONArray json_vpblacks = new JSONArray();
            if (policy.vspaceEnable) {
                if (null != policy.vspaceWhiteList) {
                    for (String item : policy.vspaceWhiteList.split(";")) {
                        if ((item = item.trim()).length() <= 0) continue;
                        json_vpwhites.put((Object)item);
                    }
                }
                if (null != policy.vspaceBlackList) {
                    for (String item : policy.vspaceBlackList.split(";")) {
                        if ((item = item.trim()).length() <= 0) continue;
                        json_vpblacks.put((Object)item);
                    }
                }
            }
            SPJSONUtil.put(json_req, "vspace_whites", json_vpwhites);
            SPJSONUtil.put(json_req, "vspace_blacks", json_vpblacks);
        }
        SPLibBridge.loopbackExeCmdEx("session_set_userdata", json_req);
        if (uid > 0 && null != policy && policy.vspaceEraseOnRooted && SPDeviceUtil.isRooted()) {
            SPLibBridge.eraseVSpace();
        }
    }

    public static void setNCConfig(String vpn_host, int vpn_port, String ipv4, String ipv6, boolean dns_gateway, List<SPServiceInfo> svclist, List<String> dnsList, List<String> routeTable) {
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "vpn_host", vpn_host);
        SPJSONUtil.putStr(json_req, "vpn_port", vpn_port);
        SPJSONUtil.put(json_req, "utun_ipv4", ipv4);
        SPJSONUtil.put(json_req, "utun_ipv6", ipv6);
        SPJSONUtil.put(json_req, "oem_name", SPApplication.oemName());
        SPJSONUtil.put(json_req, "dns_gateway", dns_gateway ? "1" : "0");
        if (dns_gateway) {
            JSONArray array = new JSONArray();
            SPJSONUtil.put(json_req, "match_domains", array);
        }
        SPJSONUtil.put(json_req, "filter_enable", "1");
        JSONArray json_svclist = new JSONArray();
        JSONArray json_dns = new JSONArray();
        if (null != svclist) {
            for (SPServiceInfo svc : svclist) {
                json_svclist.put((Object)svc.toJSON());
            }
        }
        if (null != dnsList) {
            for (String dns : dnsList) {
                json_dns.put((Object)dns);
            }
        }
        SPJSONUtil.put(json_req, "service", json_svclist);
        SPJSONUtil.put(json_req, "dns", json_dns);
        SPLibBridge.exeCmd("session_set_ncdata", json_req.toString());
    }

    public static int setSSLCertificate(String cert_base64, String password, int ssl_smx) {
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "pfx_base64", cert_base64);
        SPJSONUtil.put(json_req, "password", password);
        SPJSONUtil.put(json_req, "sslsmx_version", String.valueOf(ssl_smx));
        return SPLibBridge.exeCmd("ssl_certificate_set", json_req.toString());
    }

    public static int putSSLFingerprint(String host, int port, String fingerprint) {
        final JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "host", host);
        SPJSONUtil.putStr(json, "port", port);
        SPJSONUtil.put(json, "fingerprint", fingerprint);
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPLibBridge.loopbackExeCmdEx("ssl_fingerprint_put", json);
                }
            }.start();
            return 0;
        }
        return SPLibBridge.loopbackExeCmdEx((String)"ssl_fingerprint_put", (JSONObject)json).errcode;
    }

    public static boolean checkSSLFingerprint(String host, int port, String servername, String fingerprint) {
        SPNetUtil.networkOnMainThreadException();
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "host", host);
        SPJSONUtil.put(json, "servername", servername);
        SPJSONUtil.putStr(json, "port", port);
        SPJSONUtil.put(json, "fingerprint", fingerprint);
        SPJSONUtil.put(json, "msgid", "ssl_fingerprint_check");
        return 0 == SPLibBridge.exeCmd("message", json.toString());
    }

    public static SPMsgRspEmpty setSSLSMX(String cipher, String container, String app, String pin) {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "cipher", SPStringUtil.opt(cipher));
        SPJSONUtil.put(json, "container", SPStringUtil.opt(container));
        SPJSONUtil.put(json, "app", SPStringUtil.opt(app));
        SPJSONUtil.put(json, "pin", SPStringUtil.opt(pin));
        return SPLibBridge.loopbackExeCmdEx("sys_set_ssl_smx", json);
    }

    public static int setTunnelOptions(int mode, int app_port, int flags, byte[] authdata) {
        JSONObject json = new JSONObject();
        SPJSONUtil.putStr(json, "mode", mode);
        SPJSONUtil.putStr(json, "app_port", app_port);
        SPJSONUtil.putStr(json, "two_way", (flags & 0x10) > 0 ? 1 : 0);
        SPJSONUtil.putStr(json, "ssl_smx", flags & 0xF);
        SPJSONUtil.putStr(json, "svcid", 0);
        SPJSONUtil.put(json, "auth", null != authdata ? Base64.encodeToString((byte[])authdata, (int)2) : "");
        return SPLibBridge.exeCmd("tunnel_set_option", json.toString());
    }

    public static int getWhoami() {
        return SPLibBridge.exeCmd("session_get_whoami");
    }

    public static void eraseVSpace() {
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPLibBridge.exeCmd("vspace_erase");
                }
            }.start();
        } else {
            SPLibBridge.exeCmd("vspace_erase");
        }
    }

    public static boolean isNetHooking() {
        byte[] rsp = new byte[128];
        SPLibBridge.exeCmd("sys_get_hook", "{}", rsp);
        JSONObject json = SPJSONUtil.parseObject(new String(rsp));
        return json.optInt("net") > 0;
    }

    public static boolean isTunnelEnabled() {
        byte[] rsp = new byte[128];
        SPLibBridge.exeCmd("session_set_tunnel", "{\"set_tunnel_state\":\"0\"}", rsp);
        JSONObject json = SPJSONUtil.parseObject(new String(rsp));
        return json.optInt("tunnel_enable") > 0;
    }

    public static boolean setTunnelEnabled(boolean b) {
        byte[] rsp = new byte[128];
        String param = String.format(Locale.ENGLISH, "{\"state\":\"%d\"}", b ? 1 : 2);
        SPLibBridge.exeCmd("session_set_tunnel", param, rsp);
        JSONObject json = SPJSONUtil.parseObject(new String(rsp));
        return json.optInt("tunnel_enable") > 0;
    }

    public static boolean isDebug() {
        return 0 != SPLibBridge.exeCmd("get_debug");
    }

    public static boolean encryptFile(boolean enc, String srcfile, String dstfile, String passw) {
        boolean ret = false;
        byte[] rsp = new byte[128];
        String dir = SPFileUtil.getSdCardPath() + "/Android/data/.secureportal/encrypt";
        new File(dir).mkdirs();
        File backup = new File(srcfile + "." + System.currentTimeMillis());
        SPFileUtil.copyFile(new File(srcfile), backup);
        srcfile = SPFileUtil.realpath(srcfile);
        dstfile = SPFileUtil.realpath(dstfile);
        if (TextUtils.isEmpty((CharSequence)dstfile) || dstfile.equalsIgnoreCase(srcfile)) {
            dstfile = srcfile;
        }
        String cipher_file = "";
        String cipher = "";
        if (enc) {
            cipher_file = dir + "/" + SPStringUtil.md5(dstfile);
        } else {
            cipher_file = dir + "/" + SPStringUtil.md5(srcfile);
            cipher = new String(SPFileUtil.readFile(cipher_file));
        }
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "encrypt", enc ? "1" : "0");
        SPJSONUtil.put(json_req, "src_file", srcfile);
        SPJSONUtil.put(json_req, "dst_file", dstfile);
        SPJSONUtil.put(json_req, "password", Base64.encodeToString((byte[])passw.getBytes(), (int)2));
        SPJSONUtil.put(json_req, "cipher_tail", cipher);
        if (0 == SPLibBridge.exeCmd("vspace_crypt_file", json_req.toString(), rsp)) {
            if (enc) {
                JSONObject json = SPJSONUtil.parseObject(new String(rsp));
                cipher = json.optString("cipher_tail");
                SPFileUtil.writeFile(cipher_file, cipher.getBytes());
            } else {
                new File(cipher_file).delete();
            }
            ret = true;
        }
        if (ret) {
            backup.delete();
        } else {
            new File(srcfile).delete();
            SPFileUtil.copyFile(backup, new File(srcfile));
        }
        return ret;
    }

    public static String encryptString(boolean enc, String data, String password, String algo) {
        JSONObject json_req = new JSONObject();
        SPJSONUtil.put(json_req, "encrypt", enc ? "1" : "0");
        SPJSONUtil.put(json_req, "password", password);
        if (!TextUtils.isEmpty((CharSequence)algo)) {
            SPJSONUtil.put(json_req, "algorithm", algo);
        }
        if (enc) {
            SPJSONUtil.put(json_req, "base64", Base64.encodeToString((byte[])data.getBytes(), (int)2));
        } else {
            SPJSONUtil.put(json_req, "base64", data);
        }
        byte[] rsp = new byte[65536];
        if (0 == SPLibBridge.exeCmd("vspace_crypt_buffer", json_req.toString(), rsp)) {
            JSONObject json = SPJSONUtil.parseObject(new String(rsp));
            String ret = json.optString("base64");
            return enc ? ret : new String(Base64.decode((String)ret, (int)2));
        }
        return data;
    }

    public static SPMsgRspEmpty loopbackExeCmdEx(String cmd, JSONObject json) {
        SPMsgRspEmpty rsp = new SPMsgRspEmpty();
        SPNetUtil.networkOnMainThreadException();
        rsp.json = SPLibBridge.loopbackJsonRpc(cmd, null != json ? json : new JSONObject());
        rsp.errcode = rsp.json.optInt("_errcode", 0);
        rsp.errmsg = rsp.json.optString("_errmsg");
        return rsp;
    }

    private static synchronized void performPendingTasks() {
        ArrayList<JRPCTask> tasks = new ArrayList<JRPCTask>(_jsonrpc_tasks);
        _jsonrpc_tasks.clear();
        for (JRPCTask task : tasks) {
            PLog.v("performPendingTasks cmd=" + task.cmd, new Object[0]);
            SPLibBridge.loopbackExeCmdEx(task.cmd, task.req_json);
        }
    }

    private static JSONObject loopbackJsonRpc(String cmd, JSONObject param) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int proxy_port = SPLibBridge.getProxyPort();
            if (proxy_port < 1) {
                _jsonrpc_tasks.add(new JRPCTask(cmd, param));
                return new JSONObject();
            }
            SPLibBridge.performPendingTasks();
            Socket conn = new Socket();
            conn.connect(new InetSocketAddress("127.0.0.1", proxy_port), 1000);
            conn.setSoTimeout(30000);
            byte[] bytes = new byte[256];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            JSONObject reqjson = new JSONObject();
            SPJSONUtil.put(reqjson, "jsonrpc", "2.0");
            SPJSONUtil.putStr(reqjson, "id", _jsonrpc_id.incrementAndGet());
            SPJSONUtil.put(reqjson, "method", cmd);
            SPJSONUtil.put(reqjson, "params", param);
            byte[] reqdat = reqjson.toString().getBytes();
            buf.order(ByteOrder.BIG_ENDIAN);
            buf.put("JRPC".getBytes(), 0, 4);
            buf.putInt(reqdat.length);
            conn.getOutputStream().write(bytes, 0, 8);
            conn.getOutputStream().write(reqdat);
            conn.getOutputStream().flush();
            buf.clear();
            if (4 == conn.getInputStream().read(bytes, 0, 4)) {
                int len;
                for (int remains = buf.getInt(); remains > 0 && (len = conn.getInputStream().read(bytes, 0, Math.min(remains, 256))) > 0; remains -= len) {
                    baos.write(bytes, 0, len);
                }
            }
            conn.close();
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        JSONObject rspjson = SPJSONUtil.parseObject(baos.toString());
        JSONObject result = rspjson.optJSONObject("result");
        if (null != result) {
            return result;
        }
        PLog.v("loopbackJsonRpc parse response JSON failed: ", baos.toString());
        return new JSONObject();
    }

    private static String loopbackHttpExeCmd(String cmd, String param) {
        try {
            int count;
            byte[] updata = param.getBytes();
            URL url = new URL("http://127.0.0.1:" + SPLibBridge.getProxyPort() + "/_inner/control/" + cmd);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(2000);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(updata.length));
            conn.connect();
            conn.getOutputStream().write(updata);
            conn.getOutputStream().flush();
            try {
                conn.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] bytes = new byte[conn.getContentLength()];
            int left = bytes.length;
            int offset = 0;
            while (left > 0 && (count = conn.getInputStream().read(bytes, offset, left)) >= 1) {
                left -= count;
                offset += count;
            }
            try {
                conn.getInputStream().close();
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String(bytes);
        }
        catch (Exception ex) {
            PLog.v(ex);
            return "{}";
        }
    }

    private static class JRPCTask {
        String cmd;
        JSONObject req_json;

        public JRPCTask(String cmd, JSONObject json) {
            this.cmd = cmd;
            this.req_json = json;
        }
    }
}

