/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.jni;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.provider.Settings;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;

public class LibSecurePortal {
    public static final String ACTION_SESSION_NOTIFY = "com.secure.sdk.session.notification";
    protected static boolean tunnelHooked = false;
    protected static boolean vspaceHooked = false;

    public static native int nativeExeCmd(String var0, String var1, byte[] var2, int var3);

    public static native int nativeGetPort(int var0, String var1, int var2);

    public static native int nativeLogWrite(byte[] var0, int var1);

    public static String jniGetValue(Context context, String name) {
        String value = "";
        try {
            if (name.equals("packagename")) {
                value = SPApplication.getPkgName(context);
            } else if (name.equals("android_id")) {
                value = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            } else if (name.equals("wifi_mac")) {
                value = SPNetUtil.getWifiMac(context);
            } else if (name.equals("private_dir")) {
                value = context.getFilesDir().getAbsolutePath();
            } else if (name.equals("sdcard")) {
                String state = Environment.getExternalStorageState();
                if ("mounted".equals(state) || "mounted_ro".equals(state)) {
                    value = Environment.getExternalStorageDirectory().getAbsolutePath();
                }
            } else if (name.equals("extsdcard")) {
                value = SPStringUtil.opt(SPFileUtil.getExtSdCardPath(context));
            }
        }
        catch (Exception ex) {
            value = "";
        }
        return value;
    }

    public static void jniNotifyCallback(String topic, String content) {
        PLog.v("LibSecurePortal.jniNotifyCallback topic=%s, content=%s", topic, content);
        if (null != SPApplication.appContext()) {
            Bundle extras = new Bundle();
            extras.putString("topic", topic);
            extras.putString("content", content);
            SPIntentUtil.sendLocalBroadcast(SPApplication.appContext(), ACTION_SESSION_NOTIFY, extras);
        }
    }

    public static void systemLoadLibrary(String name) {
        try {
            System.loadLibrary(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static synchronized void loadLib() {
        try {
            System.loadLibrary("secure_portal");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static {
        LibSecurePortal.loadLib();
    }
}

