/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway.msg;

import java.nio.ByteBuffer;

public class SacMsg {
    private static final byte[] ALIGN_BYTES = new byte[]{0, 0, 0, 0};
    private int _tag;
    private ByteBuffer _buf;

    public static SacMsg wrap(ByteBuffer buffer) {
        return new SacMsg(buffer);
    }

    public static SacMsg wrap(byte[] data) {
        return new SacMsg(ByteBuffer.wrap(data));
    }

    public SacMsg() {
        this(null);
    }

    private SacMsg(ByteBuffer buffer) {
        this._buf = null == buffer ? ByteBuffer.allocate(16384) : buffer;
    }

    public ByteBuffer buffer() {
        return this._buf;
    }

    public SacMsg beginBuild() {
        this._buf.clear().position(8);
        return this;
    }

    public ByteBuffer finishBuild() {
        int len = this._buf.position() - 8;
        this._buf.flip();
        this._buf.putInt(this._tag).putInt(len).position(0);
        return this._buf;
    }

    public SacMsg setTag(int tag) {
        this._tag = tag;
        return this;
    }

    public SacMsg putStr(String str) {
        byte[] bytes = null;
        if (null != str) {
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (Exception ex) {
                bytes = str.getBytes();
            }
        } else {
            bytes = new byte[]{};
        }
        this._buf.putInt(bytes.length);
        this._buf.put(bytes);
        int align = bytes.length % 4;
        if (align != 0) {
            this._buf.put(ALIGN_BYTES, 0, 4 - align);
        }
        return this;
    }

    public SacMsg putInt(int i) {
        this._buf.putInt(i);
        return this;
    }

    public SacMsg putTicket(byte[] ticket) {
        this._buf.put(null != ticket ? ticket : new byte[32]);
        return this;
    }

    public String getStr() {
        int len = this.getInt();
        byte[] bytes = new byte[len];
        this._buf.get(bytes);
        int align = len % 4;
        if (align != 0) {
            this._buf.position(this._buf.position() + 4 - align);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            return new String(bytes);
        }
    }

    public int getInt() {
        return this._buf.position() <= this._buf.limit() - 4 ? this._buf.getInt() : 0;
    }

    public byte[] getTicket() {
        byte[] ticket = new byte[32];
        this._buf.get(ticket);
        return ticket;
    }
}

