/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway.msg;

import android.content.Context;
import android.text.TextUtils;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.gateway.msg.GatewayReq;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginReq
extends GatewayReq {
    public static final String BYOD_DEVICE_KEY = "extra_byod_devicekey";
    public static final String BYOD_VERIFY_URL = "extra_byod_complianceurl";
    public static final String CLIENT_VERSION = "sky.20170501";
    public SPAuthServerInfo authsvr = null;
    public String emark = "";
    public String username = "";
    public String password = "";
    public String cert = "";
    public String vpn_host;
    public int qrcode = 0;
    public int renew = 0;

    public LoginReq() {
        super(0x2000203);
        this.msgid = "sac_auth";
    }

    @Override
    protected void buildJSON(JSONObject json) {
        SPJSONUtil.put(json, "client_version", CLIENT_VERSION);
        if (null != this.authsvr) {
            SPJSONUtil.put(json, "AuthID", this.authsvr.id);
            SPJSONUtil.put(json, "SubAuthID", this.authsvr.sub_id);
            SPJSONUtil.put(json, "SubAuthType", this.authsvr.sub_type);
        } else {
            SPJSONUtil.put(json, "AuthID", 1);
            SPJSONUtil.put(json, "SubAuthID", 1);
            SPJSONUtil.put(json, "SubAuthType", 0);
        }
        SPJSONUtil.put(json, "emark", this.emark);
        SPJSONUtil.put(json, "UserType", 2);
        SPJSONUtil.put(json, "UserName", this.username);
        SPJSONUtil.put(json, "Password", this.password);
        SPJSONUtil.put(json, "CertPath", this.cert);
        SPJSONUtil.put(json, "ClientIP", "");
        SPJSONUtil.put(json, "ClientInf", "");
        SPJSONUtil.put(json, "NeedQr", this.qrcode);
        SPJSONUtil.put(json, "AccessMethod", 20);
        SPJSONUtil.put(json, "AccessType", 2);
        SPJSONUtil.put(json, "ClientDesc", "Android");
        SPJSONUtil.put(json, "HostName", this.vpn_host);
        SPJSONUtil.put(json, "Renew", this.renew);
        SPJSONUtil.put(json, "DeviceInfo", LoginReq.devInfo(null, this.data));
    }

    public static JSONObject devInfo(Context context, SPLiteBundle data) {
        Map<String, String> devinfo = SPDeviceUtil.getDeviceInfo(context);
        if (null != data) {
            if (!TextUtils.isEmpty((CharSequence)data.getStr(BYOD_DEVICE_KEY)) && !data.getStr(BYOD_DEVICE_KEY).equals(devinfo.get("devid"))) {
                devinfo.put("sslvpn_devid", devinfo.get("devid"));
                devinfo.put("devid", data.getStr(BYOD_DEVICE_KEY));
            }
            if (!TextUtils.isEmpty((CharSequence)data.getStr(BYOD_VERIFY_URL))) {
                devinfo.put("compliance_url", data.getStr(BYOD_VERIFY_URL));
            }
        }
        JSONObject json = SPJSONUtil.mapToObject(devinfo);
        if (SPOEM.isOEM_MPolicyZJ()) {
            JSONArray admins = SPSystemUtil.getActiveAdmins(null != context ? context : SPApplication.appContext());
            SPJSONUtil.put(json, "admins", admins);
        } else {
            SPJSONUtil.put(json, "admins", new JSONArray());
        }
        return json;
    }

    public static String makeLoginJSon(int as_id, int as_subid, int as_subtype, String username, String password, String vpn_host, boolean renew, String ticket, SPLiteBundle extras) {
        LoginReq req = new LoginReq();
        req.putExtra(extras);
        req.authsvr = new SPAuthServerInfo();
        req.authsvr.id = as_id;
        req.authsvr.sub_id = as_subid;
        req.authsvr.sub_type = as_subtype;
        if (as_subtype == 5) {
            req.username = "";
            req.password = "";
        } else {
            req.username = username;
            req.password = password;
        }
        req.vpn_host = vpn_host;
        req.renew = renew ? 1 : 0;
        JSONObject json = new JSONObject();
        req.data.toJSON(json);
        req.buildJSON(json);
        ticket = SPStringUtil.opt(ticket);
        if (ticket.length() > 0) {
            SPJSONUtil.put(json, "ticket", ticket);
            SPJSONUtil.put(json, "Ticket", ticket);
        }
        return json.toString();
    }
}

