/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway.msg;

import android.text.TextUtils;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.gateway.msg.SacMsg;
import com.secure.sportal.service.PortalSession;
import java.nio.ByteBuffer;
import org.json.JSONObject;

public class GatewayReq {
    private static int mTimeoutConn = 60;
    private static int mTimeoutData = 30;
    public long reqid;
    public String vpn_host;
    public int vpn_port;
    public String vpn_sni;
    public int ssl_smx = 0;
    public boolean ssl_twoway = false;
    public int tag;
    public String msgid;
    public byte[] ticket_bin = null;
    public String ticket_str = "";
    public SPLiteBundle data = new SPLiteBundle();
    public SPLiteBundle callbackData = new SPLiteBundle();
    public Object callbackObj = null;
    protected boolean _isJSON = true;

    public static void setTimeout(int connection, int readWrite) {
        mTimeoutConn = connection;
        mTimeoutData = readWrite;
    }

    public GatewayReq(int tag) {
        this(tag, true);
    }

    public GatewayReq(int tag, boolean isJSON) {
        this.tag = tag;
        this._isJSON = isJSON;
    }

    public GatewayReq(String msgid) {
        this.tag = 0;
        this._isJSON = true;
        this.msgid = msgid;
    }

    public void setVPN(String host, int port, String sni) {
        this.vpn_host = host;
        this.vpn_port = port;
        this.vpn_sni = sni;
    }

    public boolean isJSON() {
        return this._isJSON;
    }

    public void putExtra(SPLiteBundle extras) {
        if (null != extras) {
            this.data.put(extras);
        }
    }

    public ByteBuffer build(ByteBuffer buffer) {
        byte[] t;
        SacMsg tlv = SacMsg.wrap(buffer);
        tlv.setTag(this.tag).beginBuild();
        PortalSession session = PortalSession.instance(null);
        byte[] byArray = t = null == this.ticket_bin ? session.me().ticket : this.ticket_bin;
        if (this._isJSON) {
            tlv.putStr(this.makeJSONString());
        } else {
            tlv.putTicket(t);
            this.buildTLV(tlv);
        }
        tlv.finishBuild();
        return tlv.buffer();
    }

    public String toString() {
        return "SPortalReq[tag=" + this.tag + "]";
    }

    public String makeJSONString(String vpn_host, int vpn_port, String vpn_sni, boolean broker) {
        JSONObject json = new JSONObject();
        this.data.toJSON(json);
        this.buildJSON(json);
        String ticket = SPStringUtil.opt(TextUtils.isEmpty((CharSequence)this.ticket_str) ? PortalSession.instance(null).me().ticketstr : this.ticket_str);
        if (ticket.length() > 0) {
            SPJSONUtil.put(json, "ticket", ticket);
        }
        if (!TextUtils.isEmpty((CharSequence)vpn_host) && vpn_port > 0) {
            SPJSONUtil.put(json, "vpn_host", vpn_host.trim());
            SPJSONUtil.putStr(json, "vpn_port", vpn_port);
            SPJSONUtil.put(json, "vpn_sni", vpn_sni);
            SPJSONUtil.putStr(json, "vpn_timeout_conn", mTimeoutConn);
            SPJSONUtil.putStr(json, "vpn_timeout_data", mTimeoutData);
        }
        if (broker) {
            SPJSONUtil.put(json, "sp_ssl_twoway", this.ssl_twoway ? "1" : "0");
            SPJSONUtil.putStr(json, "sp_ssl_smx", this.ssl_smx);
        }
        return json.toString();
    }

    public String makeJSONString(String vpn_host, int vpn_port, String vpn_sni) {
        return this.makeJSONString(vpn_host, vpn_port, vpn_sni, false);
    }

    public String makeJSONString(String vpn_host, int vpn_port) {
        return this.makeJSONString(vpn_host, vpn_port, vpn_host);
    }

    public String makeJSONString() {
        return this.makeJSONString(null, 0, null, false);
    }

    protected void buildJSON(JSONObject json) {
    }

    protected void buildTLV(SacMsg tlv) {
    }
}

