/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.text.TextUtils;
import com.secure.comm.net.SPPortRange;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPServiceHostInfo;
import com.secure.sportal.entry.SPServiceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class GatewayMsgParser {
    public static SPServiceInfo parseService(JSONObject json, boolean rdpOptimize) {
        SPServiceInfo svc = new SPServiceInfo();
        svc.id = json.optInt("id");
        svc.name = json.optString("name");
        svc.access = json.optInt("accesstype");
        svc.access_agent = json.optInt("agent_type");
        svc.flag = rdpOptimize && 4 == svc.access ? 2 : 0;
        svc.type = json.optInt("servicetype");
        svc.orig_servername = json.optString("servername");
        svc.orig_serverip = json.optString("serverip");
        svc.orig_typeport = json.optString("typeport");
        svc.path = json.optString("path");
        SPServiceHostInfo host = GatewayMsgParser.parseServiceIP(svc.access, svc.orig_servername, svc.orig_serverip);
        svc.hostname = host.hostname;
        List<SPPortRange> ports = GatewayMsgParser.parseServicePort(json.optString("port"));
        svc.port = ports.size() > 0 ? ports.get((int)0).from : 0;
        return svc;
    }

    public static SPServiceHostInfo parseServiceIP(int accessType, String servername, String serverip) {
        SPServiceHostInfo hostInfo = new SPServiceHostInfo();
        hostInfo.hostname = servername;
        if ("any".equals(servername)) {
            hostInfo.ipv4_start = "0.0.0.0";
            hostInfo.ipv4_end = "255.255.255";
            hostInfo.ipv6_start = "::";
            hostInfo.ipv6_end = "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff";
        } else {
            int pos = servername.indexOf(47);
            if (pos > 0 && 1 == accessType) {
                GatewayMsgParser.parseSubnet(hostInfo, servername.substring(0, pos), servername.substring(pos + 1));
            } else {
                pos = servername.indexOf(64);
                if (pos > 0) {
                    hostInfo.hostname = servername.substring(0, pos);
                }
                String[] tmp = serverip.split("[;,|]");
                for (int i = 0; null != tmp && i < tmp.length && (serverip = SPStringUtil.opt(tmp[i])).length() <= 0; ++i) {
                }
                pos = serverip.indexOf(45);
                if (pos > 0) {
                    if (serverip.indexOf(58) > 0) {
                        hostInfo.ipv6_start = serverip.substring(0, pos);
                        hostInfo.ipv6_end = serverip.substring(pos + 1);
                    } else {
                        hostInfo.ipv4_start = serverip.substring(0, pos);
                        hostInfo.ipv4_end = serverip.substring(pos + 1);
                    }
                } else {
                    pos = serverip.indexOf(47);
                    if (pos > 0) {
                        GatewayMsgParser.parseSubnet(hostInfo, serverip.substring(0, pos), serverip.substring(pos + 1));
                    } else if (serverip.indexOf(58) > 0) {
                        hostInfo.ipv4_start = serverip;
                        hostInfo.ipv4_end = serverip;
                    } else {
                        hostInfo.ipv6_start = serverip;
                        hostInfo.ipv6_end = serverip;
                    }
                }
            }
        }
        return hostInfo;
    }

    private static void parseSubnet(SPServiceHostInfo hostInfo, String subnet, String mask) {
        if (subnet.indexOf(58) < 0) {
            hostInfo.ipv4_start = subnet;
            if (TextUtils.isDigitsOnly((CharSequence)mask)) {
                mask = SPIPUtil.lenToMask(SPStringUtil.parseInt(mask));
            }
            long network = SPIPUtil.ipToLong(subnet);
            long maskIP = SPIPUtil.ipToLong(mask);
            hostInfo.ipv4_start = SPIPUtil.longToIP(SPIPUtil.getStartAddress(network, maskIP));
            hostInfo.ipv4_end = SPIPUtil.longToIP(SPIPUtil.getEndAddress(network, maskIP));
        }
    }

    public static List<SPPortRange> parseServicePort(String str) {
        ArrayList<SPPortRange> portList = new ArrayList<SPPortRange>();
        String tmp = str.toUpperCase(Locale.ENGLISH);
        if (tmp.indexOf("ANY") >= 0 || tmp.indexOf("ICMP") >= 0) {
            portList.add(new SPPortRange(1, 65535, 0));
        } else {
            int i;
            String[] ports = tmp.split(Pattern.quote("|"));
            for (i = 0; i < ports.length; ++i) {
                int xpos = ports[i].indexOf(58);
                if (xpos > 0) {
                    String proto = ports[i].substring(0, xpos);
                    String range = ports[i].substring(xpos + 1);
                    if (proto.equalsIgnoreCase("I")) {
                        portList.add(new SPPortRange(1, 65535, 3));
                        continue;
                    }
                    int from = 0;
                    int to = 0;
                    if (range.equalsIgnoreCase("NA")) {
                        from = 1;
                        to = 65535;
                    } else {
                        int pos = range.indexOf(45);
                        if (pos > 0) {
                            from = SPStringUtil.parseInt(range.substring(0, pos));
                            to = SPStringUtil.parseInt(range.substring(pos + 1));
                        } else {
                            to = from = SPStringUtil.parseInt(range);
                        }
                    }
                    if (from <= 0 || to < from) continue;
                    int protocol = proto.equalsIgnoreCase("T") ? 1 : (proto.equalsIgnoreCase("U") ? 2 : 0);
                    portList.add(new SPPortRange(from, to, protocol));
                    continue;
                }
                int port = SPStringUtil.parseInt(ports[i]);
                if (port <= 0) continue;
                portList.add(new SPPortRange(port, port, 1));
            }
            Collections.sort(portList);
            for (i = 0; i < portList.size(); ++i) {
                SPPortRange port = (SPPortRange)portList.get(i);
                if (port.to <= 0) continue;
                for (int j = i + 1; j < portList.size(); ++j) {
                    SPPortRange portx = (SPPortRange)portList.get(j);
                    if (portx.proto != port.proto || portx.to <= 0 || port.to < portx.from - 1) continue;
                    port.to = Math.max(port.to, portx.to);
                    portx.from = 0;
                    portx.to = 0;
                }
            }
            Iterator it = portList.iterator();
            while (it.hasNext()) {
                SPPortRange port = (SPPortRange)it.next();
                if (port.to != 0) continue;
                it.remove();
            }
        }
        return portList;
    }

    public static String portListToString(List<SPPortRange> ports) {
        StringBuilder sb = new StringBuilder();
        for (SPPortRange p : ports) {
            sb.append(p.proto == 1 ? "tcp" : (p.proto == 2 ? "udp" : (p.proto == 3 ? "icmp" : "any")));
            sb.append(":").append(p.from).append("-").append(p.to).append(";");
        }
        return sb.toString();
    }
}

