/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.annotation.SuppressLint;
import android.net.VpnService;
import com.secure.PLog;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.service.PortalSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class GatewayLink {
    public static final int TIMEOUT = 90000;
    public static final String SSL_ALG_RSA_SM1_SHA1 = "RSA-SM1-SHA1";
    public static final String SSL_ALG_RSA_SM4_SHA1 = "RSA-SM4-SHA1";
    public static final String SSL_ALG_ECC_SM1_SM3 = "ECC-SM1-SM3";
    public static final String SSL_ALG_ECC_SM4_SM3 = "ECC-SM4-SM3";
    private Socket socket;
    private OutputStream output;
    private InputStream input;

    public static int getSSLSMXVersion(String smxAlgCipher) {
        if (SSL_ALG_RSA_SM4_SHA1.equalsIgnoreCase(smxAlgCipher)) {
            return 4;
        }
        if (SSL_ALG_ECC_SM1_SM3.equalsIgnoreCase(smxAlgCipher) || SSL_ALG_ECC_SM4_SM3.equalsIgnoreCase(smxAlgCipher)) {
            return 2;
        }
        return 0;
    }

    @SuppressLint(value={"TrulyRandom"})
    public static SSLSocket createSSLSocket(String host, int port) {
        Socket sslSocket;
        block4: {
            sslSocket = null;
            try {
                Security.setProperty("networkaddress.cache.ttl", "5");
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, new SecureRandom());
                SSLSocketFactory factory = context.getSocketFactory();
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), 90000);
                sslSocket = (SSLSocket)factory.createSocket(socket, host, port, true);
                ((SSLSocket)sslSocket).startHandshake();
            }
            catch (Exception ex) {
                PLog.i(ex.getLocalizedMessage(), new Object[0]);
                PLog.v(ex);
                if (null == sslSocket) break block4;
                try {
                    sslSocket.close();
                }
                catch (Exception exx) {
                    PLog.v(exx);
                }
                sslSocket = null;
            }
        }
        return sslSocket;
    }

    public static Socket createSocket(String host, int port) {
        return GatewayLink.createSocket(host, port, null, false, 0, null);
    }

    public static Socket createSocket(String host, int port, String sni) {
        return GatewayLink.createSocket(host, port, sni, false, 0, null);
    }

    public static Socket createSocket(String host, int port, String sni, boolean twoWay) {
        return GatewayLink.createSocket(host, port, sni, twoWay, 0, null);
    }

    public static Socket createSocket(String host, int port, String sni, boolean twoWay, int smx, VpnService vpnservice) {
        Socket socket;
        block6: {
            socket = null;
            try {
                int flags;
                PortalSession.setVpnAddress(host, port, sni);
                socket = new Socket();
                socket.bind(new InetSocketAddress(0));
                int n = flags = twoWay ? 0x10 | smx : smx;
                if (0 != flags) {
                    SPLibBridge.setTunnelOptions(0, socket.getLocalPort(), flags, null);
                }
                if (null != vpnservice) {
                    vpnservice.protect(socket);
                }
                InetSocketAddress addr = new InetSocketAddress("127.0.0.1", SPLibBridge.getProxyPort());
                socket.connect(addr, 90000);
            }
            catch (Exception ex) {
                PLog.i(ex.getLocalizedMessage(), new Object[0]);
                PLog.v(ex);
                if (null == socket) break block6;
                try {
                    socket.close();
                }
                catch (Exception exx) {
                    PLog.v(exx);
                }
                socket = null;
            }
        }
        return socket;
    }

    public GatewayLink() {
        this.socket = null;
        this.output = null;
        this.input = null;
    }

    public GatewayLink(Socket sock) {
        this.socket = sock;
        try {
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
    }

    public Socket socket() {
        return this.socket;
    }

    public boolean isClosed() {
        return null != this.socket && this.socket.isClosed();
    }

    public boolean open(String host, int port, String sni) {
        return this.open(host, port, sni, false, 0, null);
    }

    public boolean open(String host, int port, String sni, boolean twoWay) {
        return this.open(host, port, sni, twoWay, 0, null);
    }

    public boolean open(String host, int port, String sni, boolean twoWay, int smx, VpnService vpnservice) {
        this.close();
        this.socket = GatewayLink.createSocket(host, port, sni, twoWay, smx, vpnservice);
        if (null != this.socket) {
            try {
                this.input = this.socket.getInputStream();
                this.output = this.socket.getOutputStream();
                return true;
            }
            catch (Exception ex) {
                PLog.v(ex);
                this.close();
            }
        }
        return false;
    }

    public void close() {
        if (null != this.input) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
        if (null != this.output) {
            try {
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.output = null;
        }
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.output.write(buffer, offset, count);
        this.output.flush();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.input.read(buffer, byteOffset, byteCount);
    }
}

