/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import com.secure.PLog;
import com.secure.comm.entry.SPMessageCallback;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPAuthQRCodeInfo;
import com.secure.sportal.entry.SPMsgRsp;
import com.secure.sportal.entry.SPNCIFConfigInfo;
import com.secure.sportal.gateway.GatewayBroker;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import org.json.JSONArray;
import org.json.JSONObject;

public class GatewayBrokerSAC {
    public static SPMsgRsp<SPAuthQRCodeInfo> qrcodeGet(String host, int port, int authSubID, String username) {
        SPMsgRsp<SPAuthQRCodeInfo> rsp = new SPMsgRsp<SPAuthQRCodeInfo>();
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "sac_qrcode_get";
        msgreq.data.put("auth_sub_id", String.valueOf(authSubID));
        msgreq.data.put("username", SPStringUtil.opt(username));
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, host, port);
        rsp.errcode = msgrsp.errcode;
        if (msgrsp.errcode == 0 && null != msgrsp.json) {
            SPAuthQRCodeInfo qrcode = new SPAuthQRCodeInfo();
            qrcode.parse(msgrsp.json);
            rsp.setData(qrcode);
        }
        return rsp;
    }

    public static SPMsgRsp<SPAuthQRCodeInfo> qrcodeCheck(String host, int port, int authSubID, SPAuthQRCodeInfo qrcode) {
        SPMsgRsp<SPAuthQRCodeInfo> rsp = new SPMsgRsp<SPAuthQRCodeInfo>();
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "sac_qrcode_check";
        msgreq.data.put("auth_sub_id", String.valueOf(authSubID));
        msgreq.data.put("token", qrcode.token);
        GatewayRsp msgrsp = GatewayBroker.request(msgreq, host, port);
        rsp.errcode = msgrsp.errcode;
        if (msgrsp.errcode == 0 && null != msgrsp.json) {
            SPAuthQRCodeInfo data = new SPAuthQRCodeInfo();
            data.parse(msgrsp.json);
            data.sid = qrcode.sid;
            data.qrcode_data = qrcode.qrcode_data;
            data.qrcode_url = qrcode.qrcode_url;
            data.token = qrcode.token;
            rsp.setData(data);
        }
        return rsp;
    }

    public static void getWebSSOURL(String vpn_host, int vpn_port, String ticket, String username, String password, int svcid, final SPMessageCallback callback) {
        GatewayReq msgreq = new GatewayReq(0);
        msgreq.msgid = "sac_websso_url";
        msgreq.ticket_str = ticket;
        msgreq.data.put("service_id", svcid);
        msgreq.data.put("username", username);
        msgreq.data.put("password", password);
        GatewayBroker.request(msgreq, vpn_host, vpn_port, vpn_host, new GatewayBroker.BrokerCallback(){

            @Override
            public void onGatewayBrokerRsp(GatewayRsp msgrsp) {
                if (0 == msgrsp.errcode) {
                    String url = msgrsp.json.optString("web_sso_url");
                    callback.onMessageCallback(0, url);
                } else {
                    callback.onMessageCallback(msgrsp.errcode, msgrsp.errmsg);
                }
            }
        });
    }

    public static GatewayRsp parseNCBrokerRsp(byte[] bytes, int offset, int length) {
        GatewayRsp rsp = new GatewayRsp("prd_auth_nc", 0L);
        PLog.v(new String(bytes, offset, length), new Object[0]);
        JSONObject json = SPJSONUtil.parseObject(new String(bytes, offset, length));
        rsp.errcode = json.optInt("errcode", Integer.MAX_VALUE);
        rsp.errmsg = json.optString("errmsg");
        if (0 == rsp.errcode) {
            rsp.json = json.optJSONObject("data");
            SPNCIFConfigInfo ifconfig = new SPNCIFConfigInfo();
            ifconfig.vpnHost = rsp.json.optString("vpn_host");
            ifconfig.vpnPort = rsp.json.optInt("vpn_port", 443);
            ifconfig.inetBlocking = 1 == rsp.json.optInt("inet_blocking", 0);
            JSONArray wins = rsp.json.optJSONArray("wins");
            ifconfig.wins = new String[wins.length()];
            for (int i = 0; i < wins.length(); ++i) {
                ifconfig.wins[i] = wins.optString(i);
            }
            JSONArray dns = rsp.json.optJSONArray("dns");
            for (int i = 0; i < dns.length(); ++i) {
                String item = dns.optString(i);
                if (item.indexOf(58) >= 0) {
                    ifconfig.dns6.add(item);
                    continue;
                }
                ifconfig.dns4.add(item);
            }
            ifconfig.dnsSuffix = rsp.json.optString("dns_suffix");
            ifconfig.routeOpt = rsp.json.optInt("route_opt");
            boolean bl = ifconfig.routeAuto = 0 != rsp.json.optInt("route_auto", 1);
            if (!ifconfig.routeAuto) {
                ifconfig.routeAssign4 = SPNCIFConfigInfo.routesForJSONArray(rsp.json.optJSONArray("route_assign4"));
                ifconfig.routeAssign6 = SPNCIFConfigInfo.routesForJSONArray(rsp.json.optJSONArray("route_assign6"));
            }
            ifconfig.ipv4 = rsp.json.optString("ipv4", "").trim();
            if (4 == SPIPUtil.validateIP(ifconfig.ipv4)) {
                ifconfig.routeInclude4 = SPNCIFConfigInfo.routesForJSONArray(rsp.json.optJSONArray("route_includes4"));
            } else {
                ifconfig.ipv4 = "";
                ifconfig.dns4.clear();
            }
            ifconfig.ipv6 = rsp.json.optString("ipv6", "").trim();
            if (6 == SPIPUtil.validateIP(ifconfig.ipv6)) {
                ifconfig.routeInclude6 = SPNCIFConfigInfo.routesForJSONArray(rsp.json.optJSONArray("route_includes6"));
            } else {
                ifconfig.ipv6 = "";
                ifconfig.dns6.clear();
            }
            rsp.setData(ifconfig);
        }
        return rsp;
    }

    public static void changePasword(String ticket, String username, String passOld, String passNew, int authID, String ecode, SPMessageCallback callback) {
    }
}

