/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import com.secure.PLog;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.sportal.jni.SPLibBridge;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.json.JSONObject;

public class GatewayBrokerConn {
    public static final int TIMEOUT = 60000;
    private Socket socket = new Socket();
    private int app_port = 0;
    private OutputStream output;
    private InputStream input;

    public static String pingPongMsg(String msgid, String data) {
        try {
            GatewayBrokerConn conn = new GatewayBrokerConn();
            String rsp = conn.sendAndRecv(msgid, data);
            conn.close(false);
            return rsp;
        }
        catch (Exception ex) {
            PLog.v(ex);
            return "{\"errcode\":\"268435455\",\"errmsg\":\"\u672a\u77e5\u9519\u8bef\",\"data\":{}}";
        }
    }

    private GatewayBrokerConn() throws IOException {
        this.socket.connect(new InetSocketAddress("127.0.0.1", SPLibBridge.getProxyPort()), 60000);
        this.app_port = this.socket.getLocalPort();
        this.input = this.socket.getInputStream();
        this.output = this.socket.getOutputStream();
    }

    public String sendAndRecv(String msgid, String data) {
        byte[] bytes = data.getBytes();
        try {
            int count;
            int left;
            StringBuilder sb = new StringBuilder();
            sb.append(msgid).append(",").append(data);
            bytes = sb.toString().getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 8).order(ByteOrder.BIG_ENDIAN);
            buffer.put("PMSG".getBytes()).putInt(bytes.length).put(bytes);
            this.write(buffer.array(), 0, buffer.array().length);
            bytes = new byte[2048];
            this.read(bytes, 0, 4);
            buffer.clear();
            buffer.put(bytes, 0, 4).rewind();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(left);
            for (left = buffer.getInt(); left > 0 && (count = this.read(bytes, 0, Math.min(left, bytes.length))) > 0; left -= count) {
                baos.write(bytes, 0, count);
            }
            if (left > 0) {
                throw new Exception("\u7f51\u7edc\u6545\u969c\uff0c\u8bf7\u91cd\u65b0\u8fde\u63a5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            return new String(baos.toString());
        }
        catch (Exception ex) {
            PLog.d(ex);
            return "{\"errcode\":\"-1\",\"errmsg\":\"" + ex.getMessage() + "\",\"data\":{}}";
        }
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.output.write(buffer, offset, count);
        this.output.flush();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.input.read(buffer, byteOffset, byteCount);
    }

    public void close(boolean abort) {
        if (null != this.input) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
        if (null != this.output) {
            try {
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.output = null;
        }
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        if (abort && this.app_port > 0) {
            final JSONObject json = new JSONObject();
            SPJSONUtil.put(json, "app_port", this.app_port);
            new Thread(){

                @Override
                public void run() {
                    SPLibBridge.loopbackExeCmdEx("sys_drop_tunnel", json);
                }
            }.start();
        }
        this.app_port = 0;
    }
}

