/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.sportal.gateway.GatewayBrokerConn;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.sdk.SPVPNTool;
import com.secure.sportal.service.PortalSession;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

public final class GatewayBroker
implements Runnable {
    public static final String SP_MSGID_SAC_GET_PORTAL = "sac_get_portal";
    public static final String SP_MSGID_SAC_AUTH = "sac_auth";
    public static final String SP_MSGID_SAC_AUTH_SUB = "sac_auth_sub";
    public static final String SP_MSGID_SAC_GET_USERDATA = "sac_get_userdata";
    public static final String SP_MSGID_SAC_BIND_HOST = "sac_bind_host";
    public static final String SP_MSGID_SAC_LOGOUT = "sac_logout";
    public static final String SP_MSGID_SAC_HEARTBEAT = "sac_heartbeat";
    public static final String SP_MSGID_SAC_PASSWORD_SET = "sac_password_set";
    public static final String SP_MSGID_SAC_CODE_SEND = "sac_code_send";
    public static final String SP_MSGID_SAC_CODE_VERIFY = "sac_code_verify";
    public static final String SP_MSGID_SAC_CERT_APPLY = "sac_cert_apply";
    public static final String SP_MSGID_SAC_CERT_DOWNLOAD = "sac_cert_download";
    public static final String SP_MSGID_SAC_CERT_STATE = "sac_cert_state";
    public static final String SP_MSGID_SAC_QRCODE_GET = "sac_qrcode_get";
    public static final String SP_MSGID_SAC_QRCODE_CHECK = "sac_qrcode_check";
    public static final String SP_MSGID_SAC_APP_LIST = "sac_app_list";
    public static final String SP_MSGID_SAC_APP_COMMENT = "sac_app_comment";
    public static final String SP_MSGID_SAC_WEBSSO_URL = "sac_websso_url";
    public static final String SP_MSGID_TOKEN_LOGIN = "sectoken_login";
    public static final String SP_MSGID_SECID_LOGIN = "secid_login";
    public static final String SP_MSGID_SECID_LOGOUT = "secid_logout";
    public static final String SP_MSGID_SECID_REFRESH_TOKEN = "secid_refresh_token";
    public static final String SP_MSGID_SECID_GET_UDATA = "secid_get_userdata";
    public static final String SP_MSGID_SECID_GET_APPINFO = "secid_get_appinfo";
    public static final String SP_MSGID_SECID_AUTH_APP = "secid_auth_app";
    public static final String SP_MSGID_SECID_REQ_AUTH_CODE = "secid_request_auth_code";
    public static final String SP_MSGID_SECID_BAK_UPLOAD = "secid_backup_upload";
    public static final String SP_MSGID_SECID_BAK_DOWNLOAD = "secid_backup_download";
    public static final String SP_MSGID_SECID_RESET_PASSW = "secid_reset_password";
    public static final String SP_MSGID_SECID_UNIQ_REGIST = "secid_uniq_regist";
    public static final String SP_MSGID_SECID_PUSH_RESPOND = "secid_push_respond";
    public static final String SP_MSGID_SECID_UNBIND_DEVICE = "secid_unbind_device";
    public static final String SP_MSGID_PRD_PROXY_AUTH = "prd_auth_proxy";
    public static final String SP_MSGID_PRD_NC_AUTH = "prd_auth_nc";
    public static final String SP_MSGID_PRD_DATA = "prd_tunnel_data";
    public static final int SP_ERR_MASK = Integer.MAX_VALUE;
    public static final int SP_ERR_VPN_INTERNAL = Integer.MAX_VALUE;
    public static final int SP_ERR_NETWORK = 0xFFFFFFF;
    public static final int SP_ERR_GATEWWAY = 0xF000010;
    public static final int SP_ERR_CARRIER = 0xF000011;
    private static final AtomicLong REQ_SEED = new AtomicLong(1L);
    private GatewayReq req;
    private GatewayRsp rsp;
    private String vpn_host;
    private int vpn_port;
    private String vpn_sni;
    private BrokerCallback mCallback;
    private GatewayBrokerConn mConnection;
    private boolean mAborted;

    public static GatewayRsp request(GatewayReq req, String vpn_host, int vpn_port) {
        return GatewayBroker.request(req, vpn_host, vpn_port, vpn_host);
    }

    public static GatewayRsp request(GatewayReq req, String vpn_host, int vpn_port, String vpn_sni) {
        GatewayBroker broker = new GatewayBroker(req, vpn_host, vpn_port, vpn_sni, null);
        return broker.execute();
    }

    public static GatewayBroker request(GatewayReq req, String vpn_host, int vpn_port, String vpn_sni, BrokerCallback callback) {
        GatewayBroker broker = new GatewayBroker(req, vpn_host, vpn_port, vpn_sni, callback);
        broker.schedule();
        return broker;
    }

    private GatewayBroker(GatewayReq req, String vpn_host, int vpn_port, String vpn_sni, BrokerCallback callback) {
        this.req = req;
        this.vpn_host = vpn_host;
        this.vpn_port = vpn_port;
        this.vpn_sni = vpn_sni;
        this.mCallback = callback;
        this.mConnection = null;
        this.mAborted = false;
        this.rsp = null;
    }

    public void abort() {
        this.mAborted = true;
        if (null != this.mConnection) {
            this.mConnection.close(true);
        }
    }

    @Override
    public void run() {
        if (null != this.mCallback && !this.mAborted) {
            this.mCallback.onGatewayBrokerRsp(this.rsp);
        }
    }

    private void schedule() {
        new Thread(){

            @Override
            public void run() {
                GatewayBroker.this.rsp = GatewayBroker.this.execute();
                if (null != GatewayBroker.this.mCallback && !GatewayBroker.this.mAborted) {
                    SPIntentUtil.runOnMainThread(GatewayBroker.this, 10L);
                }
            }
        }.start();
    }

    private GatewayRsp execute() {
        SPNetUtil.networkOnMainThreadException();
        if (0L == this.req.reqid) {
            this.req.reqid = REQ_SEED.incrementAndGet();
        }
        if (TextUtils.isEmpty((CharSequence)this.vpn_host) || this.vpn_port < 1) {
            this.vpn_host = PortalSession.vpnHost();
            this.vpn_port = PortalSession.vpnPort();
        }
        if (TextUtils.isEmpty((CharSequence)this.vpn_sni)) {
            this.vpn_sni = this.vpn_host;
        }
        PLog.v(String.format(Locale.ENGLISH, "GatewayBroker.request, dst=%s:%d, msgid=%s", this.vpn_host, this.vpn_port, this.req.msgid), new Object[0]);
        GatewayRsp rsp = null;
        String reqjson = this.req.makeJSONString(this.vpn_host, this.vpn_port, this.vpn_sni, true);
        for (int i = 0; i < 1; ++i) {
            String rspjson = GatewayBrokerConn.pingPongMsg(this.req.msgid, reqjson);
            JSONObject json = SPJSONUtil.parseObject(rspjson);
            int errcode = json.optInt("errcode", -1);
            if (-1 == errcode) continue;
            rsp = new GatewayRsp(this.req.msgid, this.req.reqid);
            rsp.reqid = this.req.reqid;
            rsp.errcode = errcode;
            rsp.errmsg = json.optString("errmsg", "");
            if (TextUtils.isEmpty((CharSequence)rsp.errmsg)) {
                rsp.errmsg = GatewayErrorText.getErrMsg(rsp.errcode);
            }
            rsp.json = json.optJSONObject("data");
            if (null != rsp.json) break;
            rsp.json = new JSONObject();
            break;
        }
        if (null == rsp) {
            rsp = new GatewayRsp(this.req.msgid, this.req.reqid);
            rsp.errcode = 0xFFFFFFF;
            rsp.errmsg = "\u7f51\u7edc\u6545\u969c\uff0c\u8bf7\u91cd\u65b0\u8fde\u63a5\u6216\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        rsp.callbackData.put(this.req.callbackData);
        rsp.callbackObj = this.req.callbackObj;
        SPVPNTool.setLogFlush();
        return rsp;
    }

    public static interface BrokerCallback {
        public void onGatewayBrokerRsp(GatewayRsp var1);
    }
}

