/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPLiteBundle;
import com.secure.sportal.entry.SPLoadItem;
import com.secure.sportal.entry.SPNCIFConfigInfo;
import com.secure.sportal.entry.SPPortalInfo;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPUserDataInfo;
import com.secure.sportal.entry.SPUserInfo;
import com.secure.sportal.gateway.GatewayAgent;
import com.secure.sportal.gateway.GatewayLink;
import com.secure.sportal.gateway.GatewayMsgParser;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.gateway.msg.GetUserDataReq;
import com.secure.sportal.gateway.msg.LoginRenewReq;
import com.secure.sportal.gateway.msg.LoginReq;
import com.secure.sportal.gateway.msg.NCConnReq;
import com.secure.sportal.gateway.msg.PutHostBind;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.service.PortalSession;
import java.net.InetAddress;
import org.json.JSONArray;
import org.json.JSONObject;

public class GatewayAgentAuth {
    public static GatewayRsp getPortal(String vpn_host, int vpn_port, String vpn_sni) {
        GatewayReq req = new GatewayReq(0x2000202);
        req.data.put("hostname", PortalSession.vpnHost());
        req.data.put("port", PortalSession.vpnPort());
        req.data.put("AccessMethod", 20);
        GatewayRsp rsp = GatewayAgent.request(req, vpn_host, vpn_port, vpn_sni);
        if (rsp.errcode == 0 && null != rsp.json) {
            SPPortalInfo portal = new SPPortalInfo();
            try {
                portal.carrierTypes = rsp.json.optInt("terminal_line_type");
                portal.showAuthen = rsp.json.optInt("show_authen");
                portal.certPolicy = rsp.json.optInt("cert_flag");
                portal.antivirus = rsp.json.optInt("antivirus", 0) > 0;
                portal.smxAlgID = rsp.json.optInt("sm_enc_algo_id", 0);
                if (portal.smxAlgID > 0) {
                    portal.smxAlgCipher = rsp.json.optString("sm_enc_algo", "");
                    portal.smxContainer = rsp.json.optString("sm2_container", "");
                    portal.smxApp = rsp.json.optString("sm2_application", "");
                    portal.smxCertEnable = rsp.json.optInt("sm_cert", 0) > 0;
                    SPLibBridge.setSSLSMX(portal.smxAlgCipher, "", "", "");
                } else {
                    portal.smxAlgCipher = "";
                    portal.smxContainer = "";
                    portal.smxApp = "";
                    portal.smxCertEnable = false;
                }
                PLog.v("portal-sslsmx alg_id=%d, alg_cipher=%s, container=%s, app=%s, cert=%s", portal.smxAlgID, portal.smxAlgCipher, portal.smxContainer, portal.smxApp, portal.smxCertEnable ? "yes" : "no");
                JSONArray items = rsp.json.getJSONArray("AuthList");
                int count = items.length();
                for (int i = 0; i < count; ++i) {
                    JSONObject item = items.getJSONObject(i);
                    SPAuthServerInfo auth = new SPAuthServerInfo();
                    auth.id = item.optInt("AuthID");
                    auth.name = item.optString("AuthName");
                    auth.sub_id = item.optInt("SubAuthID", 0);
                    auth.sub_name = item.optString("SubAuthName");
                    auth.sub_type = item.optInt("SubAuthType");
                    auth.sub_qrcode = item.optInt("QrFlag");
                    auth.sub_token = item.optInt("IamFlag");
                    auth.sub_key_container = item.optString("auth_key_container");
                    auth.sub_key_app = item.optString("auth_key_app");
                    auth.sub_cert_type = item.optString("auth_cert_type");
                    portal.authList.add(auth);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            rsp.setData(portal);
        }
        return rsp;
    }

    public static GatewayRsp login(String vpn_host, int vpn_port, String vpn_sni, String emark, SPPortalInfo portal, SPAuthServerInfo authsvr, String username, String passw, int renew, SPLiteBundle extras) {
        LoginReq req = new LoginReq();
        String certbase64 = null;
        String certpassw = null;
        req.putExtra(extras);
        req.emark = emark;
        req.authsvr = authsvr;
        req.renew = renew;
        req.ssl_twoway = false;
        if (authsvr.sub_type == 5) {
            certbase64 = username;
            certpassw = passw;
            req.ssl_twoway = true;
            if (null != portal && portal.smxCertEnable) {
                req.ssl_smx = 2;
            }
        } else if (authsvr.sub_type == 19) {
            req.data.put("auth_cert_base64", username);
            req.data.put("auth_cert_sign", passw);
            req.username = "";
            req.password = "";
        } else if (authsvr.sub_type == 12 || authsvr.sub_type == 20) {
            req.password = passw;
        } else {
            req.username = username;
            req.password = passw;
        }
        req.vpn_host = PortalSession.vpnHost();
        GatewayRsp rsp = GatewayAgent.request(req, vpn_host, vpn_port, vpn_sni, certbase64, certpassw);
        if (renew == 0 && rsp.errcode == 0 && null != rsp.json) {
            SPUserInfo lr = new SPUserInfo();
            lr.ticketstr = rsp.json.optString("Ticket");
            lr.ticket = SPStringUtil.ticketToBytes(lr.ticketstr);
            lr.username = rsp.json.optString("ThisUserName");
            lr.uid = rsp.json.optInt("ThisUserID", 0);
            lr.eid = rsp.json.optInt("eid", 0);
            lr.authsvr = req.authsvr;
            lr.extra = rsp.json.optJSONObject("extra");
            rsp.setData(lr);
        }
        return rsp;
    }

    public static boolean loginRenew(String vpn_host, int vpn_port, String vpn_sni, String jsonstr) {
        LoginRenewReq req = new LoginRenewReq(jsonstr);
        PortalSession session = PortalSession.instance(null);
        if (session.authsvr.sub_type == 5) {
            return 0 == GatewayAgent.request((GatewayReq)req, (String)vpn_host, (int)vpn_port, (String)vpn_sni, (String)session.username, (String)session.password).errcode;
        }
        return 0 == GatewayAgent.request((GatewayReq)req, (String)vpn_host, (int)vpn_port, (String)vpn_sni).errcode;
    }

    public static GatewayRsp getUserdata(String vpn_host, int vpn_port, String vpn_sni, SPLiteBundle extras) {
        GetUserDataReq req = new GetUserDataReq();
        req.putExtra(extras);
        GatewayRsp rsp = GatewayAgent.request(req, vpn_host, vpn_port, vpn_sni);
        if (rsp.errcode == 0 && null != rsp.json) {
            SPUserDataInfo userdata = new SPUserDataInfo();
            try {
                userdata.vpn_ip = InetAddress.getByName(vpn_host).getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
            userdata.userpass = rsp.json.optString("userpass", "");
            userdata.needsBind = rsp.json.optInt("need_bind", 0);
            if (userdata.needsBind == 0) {
                JSONArray svclist;
                userdata.machineid = rsp.json.optString("machineid");
                userdata.gateway_version = rsp.json.optString("gateway_version");
                userdata.compress = rsp.json.optInt("compress", 0);
                userdata.deviceTime = rsp.json.optLong("devtime", System.currentTimeMillis() / 1000L);
                userdata.userDomain = rsp.json.optString("domain");
                userdata.username = rsp.json.optString("username");
                userdata.userExpires = rsp.json.optInt("expires");
                userdata.rdpOptimize = rsp.json.optInt("rdp_optimize");
                userdata.noBlockHeaderEnabled = 0 != rsp.json.optInt("no_block_header_enabled");
                userdata.smxAlgCipher = rsp.json.optString("sm_enc_algo");
                JSONArray iphosts = rsp.json.optJSONArray("iphost_list");
                if (null != iphosts) {
                    for (int i = 0; i < iphosts.length(); ++i) {
                        JSONObject iphost = iphosts.optJSONObject(i);
                        if (null == iphost) continue;
                        userdata.addIPHost(iphost.optString("hostname"), iphost.optString("realip"));
                    }
                }
                if (null != (svclist = rsp.json.optJSONArray("servicelist"))) {
                    for (int i = 0; i < svclist.length(); ++i) {
                        JSONObject svc = svclist.optJSONObject(i);
                        if (null == svc) continue;
                        SPServiceInfo s = GatewayMsgParser.parseService(svc, userdata.rdpOptimize != 0);
                        if (s.access == 1) {
                            userdata.ncSvcList.add(s);
                        } else if (s.access == 0 || s.access == 4) {
                            userdata.proxySvcList.add(s);
                        }
                        if (TextUtils.isEmpty((CharSequence)s.hostname) || -1 != s.hostname.indexOf(47) || 0 != SPIPUtil.validateIP(s.hostname) || TextUtils.isEmpty((CharSequence)s.ipaddr)) continue;
                        userdata.addIPHost(s.hostname, s.ipaddr);
                    }
                }
                PLog.v("GetUserData iphosts " + userdata.iphosts.toString(), new Object[0]);
                JSONArray ha_line = rsp.json.optJSONArray("ha_line");
                if (null != ha_line) {
                    for (int i = 0; i < ha_line.length(); ++i) {
                        JSONObject item = ha_line.optJSONObject(i);
                        if (null == item) continue;
                        SPLoadItem load = new SPLoadItem();
                        load.host = item.optString("ip", "");
                        load.port = item.optInt("port", 0);
                        load.load = item.optInt("load", 0);
                        userdata.loads.add(load);
                    }
                }
                userdata.policy.parseFromJSON(rsp.json);
            }
            rsp.setData(userdata);
        }
        return rsp;
    }

    public static GatewayRsp ncAuthorize(GatewayLink link, byte[] ticket, String username, String password, String utun_ip) {
        NCConnReq req = new NCConnReq(ticket, username);
        req.password = password;
        req.utun_ip = utun_ip;
        GatewayRsp rsp = GatewayAgent.request(link, req);
        if (0 == rsp.errcode) {
            int i;
            SPNCIFConfigInfo ifconfig = new SPNCIFConfigInfo();
            ifconfig.ipv4 = rsp.tlv.getStr();
            int count = rsp.tlv.getInt();
            for (i = 0; i < count; ++i) {
                ifconfig.dns4.add(rsp.tlv.getStr());
            }
            ifconfig.wins = new String[rsp.tlv.getInt()];
            for (i = 0; i < ifconfig.wins.length; ++i) {
                ifconfig.wins[i] = rsp.tlv.getStr();
            }
            count = rsp.tlv.getInt();
            for (i = 0; i < count; ++i) {
                rsp.tlv.getStr();
                rsp.tlv.getStr();
            }
            ifconfig.routeOpt = rsp.tlv.getInt();
            ifconfig.routeAuto = 0 != rsp.tlv.getInt();
            ifconfig.dnsSuffix = rsp.tlv.getStr();
            rsp.setData(ifconfig);
        }
        return rsp;
    }

    public static void logout(String vpn_host, int vpn_port, String vpn_sni, byte[] ticket, String ticketstr) {
        GatewayReq req = new GatewayReq(0x2000207);
        req.ticket_bin = ticket;
        req.ticket_str = ticketstr;
        req.data.put("hostcheck_result", 0);
        GatewayAgent.request(req, vpn_host, vpn_port, vpn_sni);
    }

    public static boolean heartbeat(String vpn_host, int vpn_port, String vpn_sni) {
        GatewayReq req = new GatewayReq(0x200020A);
        return 0 == GatewayAgent.request((GatewayReq)req, (String)vpn_host, (int)vpn_port, (String)vpn_sni).errcode;
    }

    public static boolean putHostbind(String vpn_host, int vpn_port, String vpn_sni) {
        PutHostBind req = new PutHostBind();
        return 0 == GatewayAgent.request((GatewayReq)req, (String)vpn_host, (int)vpn_port, (String)vpn_sni).errcode;
    }
}

