/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.text.TextUtils;
import android.util.Base64;
import com.secure.comm.utils.SPDeviceUtil;
import com.secure.sportal.entry.SPAppCommentInfo;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.gateway.GatewayAgent;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class GatewayAgentAppstore {
    public static GatewayRsp queryAppList(String host, int port, String sni, String ticket, String pkgname) {
        return GatewayAgentAppstore.queryAppList(host, port, sni, ticket, pkgname, "");
    }

    public static GatewayRsp queryAppList(String host, int port, String sni, String ticket, String pkgname, String app_identify) {
        GatewayReq req = new GatewayReq(0x200020F);
        req.ticket_str = ticket;
        req.data.put("package_name", TextUtils.isEmpty((CharSequence)pkgname) ? "" : pkgname);
        req.data.put("app_identify", TextUtils.isEmpty((CharSequence)app_identify) ? "" : app_identify);
        req.data.put("os", "Android");
        GatewayRsp rsp = GatewayAgent.request(req, host, port, sni);
        ArrayList<SPAppInfo> appList = new ArrayList<SPAppInfo>();
        if (rsp.errcode == 0 && null != rsp.json) {
            JSONArray jsonApps = rsp.json.optJSONArray("applist");
            for (int i = 0; null != jsonApps && i < jsonApps.length(); ++i) {
                String launchers;
                SPAppInfo app = new SPAppInfo();
                JSONObject jsonApp = jsonApps.optJSONObject(i);
                app.appid = jsonApp.optInt("id", 0);
                app.pkgname = jsonApp.optString("package_name", "");
                app.title = jsonApp.optString("name", "");
                app.version = jsonApp.optString("version", "");
                app.mtime = jsonApp.optInt("mtime", 0);
                app.filesize = jsonApp.optLong("app_size", 0L);
                app.comment = jsonApp.optString("remark", "");
                app.iconfile = jsonApp.optString("icon_path", "");
                app.downloads = jsonApp.optInt("download_count", 0);
                app.pubtime = jsonApp.optString("time", "");
                app.app_identify = jsonApp.optString("app_identify", "");
                if (!TextUtils.isEmpty((CharSequence)app.iconfile)) {
                    app.iconfile = String.format(Locale.ENGLISH, "https://%s:%d%s", host, port, app.iconfile);
                }
                app.appfile = jsonApp.optString("app_name", "");
                if (!TextUtils.isEmpty((CharSequence)app.appfile)) {
                    app.appfile = String.format(Locale.ENGLISH, "https://%s:%d/fw/down.php?id=%d", host, port, app.appid);
                }
                if (!TextUtils.isEmpty((CharSequence)(launchers = jsonApp.optString("launchers")))) {
                    launchers = new String(Base64.decode((String)launchers, (int)2));
                    try {
                        JSONArray classes = new JSONArray(launchers);
                        for (int j = 0; j < classes.length(); ++j) {
                            JSONObject cls = classes.optJSONObject(j);
                            app.addLauncher(cls.optString("label"), cls.optString("class"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                appList.add(app);
            }
        }
        rsp.setData(appList);
        return rsp;
    }

    public static GatewayRsp comment(String host, int port, String sni, String ticket, int appid, int uid, String appname, String username, String msg, int stars) {
        GatewayReq req = new GatewayReq(0x2000210);
        req.ticket_str = ticket;
        req.data.put("sid", appid);
        req.data.put("userid", uid);
        req.data.put("username", username);
        req.data.put("server", host);
        req.data.put("devid", SPDeviceUtil.getDeviceInfo(null).get("devid"));
        req.data.put("product", SPDeviceUtil.getDeviceInfo(null).get("product"));
        req.data.put("os", "Android");
        req.data.put("sname", appname);
        req.data.put("type", 1);
        if (TextUtils.isEmpty((CharSequence)msg)) {
            req.data.put("time", 0);
            req.data.put("content", "");
            req.data.put("star", 0);
        } else {
            req.data.put("time", (int)(System.currentTimeMillis() / 1000L));
            req.data.put("content", msg);
            req.data.put("star", stars);
        }
        GatewayRsp rsp = GatewayAgent.request(req, host, port, sni);
        if (rsp.errcode == 0 && null != rsp.json && !TextUtils.isEmpty((CharSequence)(msg = rsp.json.optString("content")))) {
            SPAppCommentInfo c = new SPAppCommentInfo();
            c.msg = msg;
            c.appid = rsp.json.optInt("sid", 0);
            c.username = rsp.json.optString("username", "");
            c.time = 1000L * (long)rsp.json.optInt("time", 0);
            c.stars = rsp.json.optInt("star", 0);
            c.msg = rsp.json.optString("content", "");
            rsp.setData(c);
        }
        return rsp;
    }
}

