/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.gateway;

import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.utils.SPNetUtil;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.gateway.GatewayLink;
import com.secure.sportal.gateway.msg.GatewayReq;
import com.secure.sportal.gateway.msg.GatewayRsp;
import com.secure.sportal.gateway.msg.SacMsg;
import com.secure.sportal.jni.SPLibBridge;
import com.secure.sportal.service.PortalSession;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class GatewayAgent {
    public static final int VPN_GET_PORTAL = 0x2000202;
    public static final int VPN_LOGIN = 0x2000203;
    public static final int VPN_LOGIN_CHOICE = 0x2000204;
    public static final int VPN_GET_USERDATA = 0x2000205;
    public static final int VPN_PUT_HOSTBIND = 0x2000206;
    public static final int VPN_LOGOUT = 0x2000207;
    public static final int VPN_APPLY_SERVICE = 0x2000208;
    public static final int VPN_DELETE_SERVICE = 0x2000209;
    public static final int VPN_HEARTBEAT = 0x200020A;
    public static final int VPN_UPDATE_PASSWD_JSON = 0x200020B;
    public static final int VPN_SMS_SEND = 0x200020C;
    public static final int VPN_SMS_VALIDATION = 0x200020D;
    public static final int VPN_SUB_AUTH = 0x200020E;
    public static final int VPN_QUERY_APP_LIST = 0x200020F;
    public static final int VPN_QUERY_APP_COMMENT = 0x2000210;
    public static final int VPN_WOL = 33554459;
    public static final int VPN_PROXY_ACCESS = 0x1000001;
    public static final int VPN_NC_ACCESS = 0x1000002;
    public static final int VPN_PRD_DATA = 0x100000A;
    public static final int VPN_PASSWORD_UPDATE = 33555486;
    public static final int VPN_PASSWORD_INIT = 33555482;
    public static final int VPN_PASSWORD_WILL_OVERDUE = 33555497;
    public static final int VPN_APPLY_USER_CERT = 1245199;
    public static final int VPN_DOWNLOAD_USER_CERT = 0x130011;
    public static final int VPN_DOWNLOAD_USER_CERT_STATUS = 1245216;
    private static final AtomicLong REQ_SEED = new AtomicLong(1L);

    public static GatewayRsp request(GatewayReq req, String vpn_host, int vpn_port, String vpn_sni) {
        return GatewayAgent.request(req, vpn_host, vpn_port, vpn_sni, null, null);
    }

    public static GatewayRsp request(GatewayReq req, String vpn_host, int vpn_port, String vpn_sni, String certbase64, String certpassw) {
        if (0L == req.reqid) {
            req.reqid = REQ_SEED.incrementAndGet();
        }
        if (TextUtils.isEmpty((CharSequence)vpn_host)) {
            vpn_host = PortalSession.vpnHost();
        }
        if (vpn_port < 1) {
            vpn_port = PortalSession.vpnPort();
        }
        if (TextUtils.isEmpty((CharSequence)vpn_sni)) {
            vpn_sni = PortalSession.vpnSNI();
        }
        PLog.v(String.format(Locale.ENGLISH, "VPNAgent.request(), dst=%s:%d, tag=0x%08X", vpn_host, vpn_port, req.tag), new Object[0]);
        GatewayRsp rsp = null;
        GatewayLink link = new GatewayLink();
        for (int i = 0; i < 1; ++i) {
            if (!TextUtils.isEmpty((CharSequence)certbase64) && 0 != SPLibBridge.setSSLCertificate(certbase64, certpassw, req.ssl_smx)) {
                rsp = new GatewayRsp(req.msgid, req.reqid);
                rsp.errcode = 0x2000424;
                rsp.errmsg = GatewayErrorText.getErrMsg(0x2000424);
                break;
            }
            if (!link.open(vpn_host, vpn_port, vpn_sni, req.ssl_twoway, req.ssl_smx, null)) continue;
            rsp = GatewayAgent.request(link, req);
            link.close();
            if (rsp.errcode != 0xFFFFFFF) break;
        }
        if (null == rsp) {
            rsp = new GatewayRsp(req.msgid, req.reqid);
            rsp.errcode = 0xFFFFFFF;
            rsp.errmsg = GatewayErrorText.getErrMsg(0xFFFFFFF);
        }
        PLog.v(String.format(Locale.ENGLISH, "VPNAgent.request() error=0x%08X, errmsg=%s", rsp.errcode, rsp.errmsg), new Object[0]);
        return rsp;
    }

    public static long request(GatewayReq req, OnResponser responser) {
        req.reqid = REQ_SEED.incrementAndGet();
        new Thread(new VPNRequestTask(req, responser)).start();
        return req.reqid;
    }

    public static GatewayRsp request(GatewayLink link, GatewayReq req) {
        SPNetUtil.networkOnMainThreadException();
        GatewayRsp rsp = new GatewayRsp(req.msgid, req.reqid);
        rsp.reqid = req.reqid;
        rsp.errcode = 0xFFFFFFF;
        try {
            ByteBuffer buffer = req.build(null);
            link.write(buffer.array(), 0, buffer.limit());
            buffer.clear();
            int len = link.read(buffer.array(), 0, 12);
            if (len == 12) {
                SacMsg tlv = SacMsg.wrap(buffer);
                rsp.tag = tlv.getInt();
                rsp.len = tlv.getInt();
                rsp.errcode = tlv.getInt();
                if ((rsp.tag & Integer.MAX_VALUE) != req.tag) {
                    rsp.errcode = 0xFFFFFF1;
                    rsp.errmsg = GatewayErrorText.getErrMsg(0xFFFFFF1);
                } else if (rsp.errcode == 0) {
                    if (buffer.capacity() < rsp.len + 8) {
                        buffer = ByteBuffer.allocate(rsp.len + 16);
                        buffer.clear();
                        buffer.putInt(rsp.tag).putInt(rsp.len).putInt(rsp.errcode);
                        tlv = SacMsg.wrap(buffer);
                    }
                    int left = rsp.len - 4;
                    int pos = 12;
                    while (left > 0 && len != -1) {
                        len = link.read(buffer.array(), pos, left);
                        if (len == -1) continue;
                        left -= len;
                        pos += len;
                    }
                    buffer.limit(rsp.len + 8);
                    rsp.parse(tlv, req.isJSON());
                } else {
                    rsp.errmsg = GatewayErrorText.getErrMsg(rsp.errcode);
                }
            } else {
                rsp.errcode = 0xFFFFFFF;
                rsp.errmsg = GatewayErrorText.getErrMsg(0xFFFFFFF);
            }
        }
        catch (Exception ex) {
            PLog.i(ex.getLocalizedMessage(), new Object[0]);
            PLog.v(ex);
            if (rsp.tag == 0) {
                rsp.tag = req.tag;
            }
            rsp.errmsg = ex.getMessage();
        }
        return rsp;
    }

    private static class VPNRequestTask
    implements Runnable {
        GatewayReq req;
        OnResponser responser;

        public VPNRequestTask(GatewayReq req, OnResponser listener) {
            this.req = req;
            this.responser = listener;
        }

        @Override
        public void run() {
            GatewayRsp rsp = GatewayAgent.request(this.req, null, 0, null);
            if (null != this.responser) {
                this.responser.onAgentResponse(rsp);
            }
        }
    }

    public static interface OnResponser {
        public void onAgentResponse(GatewayRsp var1);
    }
}

