/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.PLog;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPTripleDes;
import com.secure.sportal.entry.SPLiteBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Properties;

public class SPortalConf
implements Serializable {
    private static final long serialVersionUID = -613667851121344149L;
    public static final String KEY_APP_IDENTIFY = "app_identify";
    public static final String KEY_VPN_HOST = "vpn_host";
    public static final String KEY_VPN_PORT = "vpn_port";
    public static final String KEY_VPN_SNI = "vpn_sni";
    public static final String KEY_VPN_IP_FIXED = "vpn_ip_fixed";
    public static final String KEY_AUTH_EMARK = "auth_emark";
    public static final String KEY_AUTH_NAME = "auth_name";
    public static final String KEY_AUTH_SERVER = "auth_server";
    public static final String KEY_AUTH_MODE = "auth_mode";
    public static final String KEY_AUTH_AUTOLOGIN = "auth_autologin";
    public static final String KEY_AUTH_USERNAME = "auth_username";
    public static final String KEY_AUTH_PASSWORD = "auth_password";
    public static final String KEY_AUTH_SIGN_METHOD = "auth_sign_method";
    public static final String KEY_SDCARD_PIN = "sdcard_pin";
    public static final String KEY_AUTH_CERT = "auth_cert";
    public static final String KEY_AUTH_CERT_PASS = "auth_cert_pass";
    public static final String KEY_APP_POLICY = "app_policy";
    public static final String KEY_SKY_MOBILE = "sky_mobile";
    public static final String KEY_SNI_POLICY = "sni_policy";
    public static final String KEY_OEM_NAME = "oem_name";
    public String app_identify = "";
    public String vpn_host = "";
    public int vpn_port = 443;
    public String vpn_sni = "";
    public boolean vpn_ip_fixed = false;
    public String auth_server = "";
    public String auth_emark = "";
    public int auth_mode = 0;
    public boolean auth_autologin = false;
    public String auth_username = "";
    public String auth_password = "";
    public String sdcard_pin = "";
    public String auth_sign_method = "";
    public String app_policy = "{}";
    public boolean sky_mobile = false;
    public String oem_name = "";
    public SPLiteBundle extras = new SPLiteBundle();
    private static SPortalConf _instance = null;

    public static synchronized SPortalConf load(Context context) {
        if (null == _instance) {
            try {
                Properties conf = new Properties();
                String text = SPFileUtil.readAssetsText(context, "sportal.conf");
                if (text.indexOf("vpn_host=") == -1) {
                    text = SPTripleDes.decrypt(text);
                }
                byte[] data = text.getBytes();
                conf.load(new InputStreamReader((InputStream)new ByteArrayInputStream(data), "UTF-8"));
                _instance = SPortalConf.parse(conf);
            }
            catch (Exception ex) {
                _instance = new SPortalConf();
            }
        }
        return _instance;
    }

    public static SPortalConf parse(Properties props) {
        if (null != props) {
            SPortalConf conf = new SPortalConf();
            conf.app_identify = props.getProperty(KEY_APP_IDENTIFY, "").trim();
            conf.vpn_host = props.getProperty(KEY_VPN_HOST, "").trim();
            conf.vpn_port = SPStringUtil.propOptInt(props, KEY_VPN_PORT, 443);
            conf.vpn_sni = props.getProperty(KEY_VPN_SNI, "").trim();
            conf.auth_emark = props.getProperty(KEY_AUTH_EMARK, "").trim();
            conf.vpn_ip_fixed = props.getProperty(KEY_VPN_IP_FIXED, "").trim().equals("1");
            if (TextUtils.isEmpty((CharSequence)conf.vpn_sni)) {
                conf.vpn_sni = conf.auth_emark;
            }
            conf.auth_server = props.getProperty(KEY_AUTH_NAME, "").trim();
            if (conf.auth_server.length() < 1) {
                conf.auth_server = props.getProperty(KEY_AUTH_SERVER, "").trim();
            }
            conf.auth_mode = SPStringUtil.propOptInt(props, KEY_AUTH_MODE, 0);
            conf.auth_autologin = 0 != SPStringUtil.propOptInt(props, KEY_AUTH_AUTOLOGIN, 0);
            conf.auth_username = props.getProperty(KEY_AUTH_USERNAME, "").trim();
            boolean bl = conf.sky_mobile = 0 != SPStringUtil.propOptInt(props, KEY_SKY_MOBILE, 0);
            if (TextUtils.isEmpty((CharSequence)conf.auth_username)) {
                conf.auth_username = props.getProperty(KEY_AUTH_CERT, "").trim();
                conf.auth_password = props.getProperty(KEY_AUTH_CERT_PASS, "");
            } else {
                conf.auth_password = props.getProperty(KEY_AUTH_PASSWORD, "");
            }
            conf.sdcard_pin = props.getProperty(KEY_SDCARD_PIN, "").trim();
            conf.auth_sign_method = props.getProperty(KEY_AUTH_SIGN_METHOD, "").trim();
            conf.app_policy = props.getProperty(KEY_APP_POLICY, "").trim();
            if (!(TextUtils.isEmpty((CharSequence)conf.app_policy) || conf.app_policy.startsWith("{") && conf.app_policy.endsWith("}"))) {
                try {
                    conf.app_policy = new String(Base64.decode((String)conf.app_policy, (int)2));
                    PLog.i("sportal.conf policy: %s", conf.app_policy);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            conf.oem_name = props.getProperty(KEY_OEM_NAME);
            for (Object key : props.keySet()) {
                String name = key.toString();
                if (!name.startsWith("extra_")) continue;
                conf.extras.put(name, props.getProperty(name, "").trim());
            }
            return conf;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SPortalConf[");
        sb.append("app_idname=").append(this.app_identify);
        sb.append(", vpn_host=").append(this.vpn_host);
        sb.append(", vpn_port=").append(this.vpn_port);
        sb.append(", auth_emark=").append(this.auth_emark);
        sb.append(", auth_server=").append(this.auth_server);
        sb.append(", auth_mode=").append(this.auth_mode);
        sb.append(", auth_autologin=").append(this.auth_autologin);
        sb.append(", auth_username=").append(this.vpn_host);
        sb.append(", auth_password=").append(this.vpn_host);
        sb.append(", sdcard_pin=").append(this.sdcard_pin);
        sb.append(", auth_sign_method=").append(this.auth_sign_method);
        sb.append(", app_policy=").append(this.app_policy);
        sb.append(", oem_name=").append(this.oem_name);
        sb.append("]");
        return sb.toString();
    }
}

