/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.net.SPIPRange;
import com.secure.comm.utils.SPIPUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.sportal.gateway.GatewayLink;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class SPUserPolicy
implements Serializable {
    private static final long serialVersionUID = 5470728710999922280L;
    public boolean inetBlockingEnable = false;
    public List<SPIPRange> inetBlockingBlackList = new ArrayList<SPIPRange>();
    public boolean vspaceEnable = false;
    public boolean vspaceEraseOnUninstall = false;
    public boolean vspaceEraseOnRooted = false;
    public String vspaceAlgo = "aes";
    public int vspaceEraseOnTimeout = 0;
    public String vspaceWhiteList = "";
    public String vspaceBlackList = "";
    public int gestureExpires = 0;
    public boolean gestureLogin = false;
    public boolean dmEnable = false;
    public boolean dmCameraEnable = true;
    public int dmPasswordType = 0;
    public int dmPasswordLen = 0;
    public int dmLockScreen = 0;
    public boolean pkgappNotifyEnable = false;
    public boolean pkgappNCEnable = false;
    public int pkgappUpgrade = 0;
    public String pkgappSSOTemplate = "";

    public static SPUserPolicy fromBrokerJSON(JSONObject json) {
        JSONObject mpolicy;
        SPUserPolicy policy = new SPUserPolicy();
        policy.initialize();
        policy.inetBlockingEnable = json.optInt("inet_blocking") > 0;
        String blacks = json.optString("inet_blocking_exceptions");
        if (policy.inetBlockingEnable && !TextUtils.isEmpty((CharSequence)blacks)) {
            policy.inetBlockingBlackList = SPIPUtil.ipRulesToPool(blacks.trim(), "|").combine().getIPRanges();
        }
        if (null != (mpolicy = json.optJSONObject("policy"))) {
            policy.gestureLogin = mpolicy.optInt("gesture_login") > 0;
            policy.gestureExpires = mpolicy.optInt("gesture_expires");
            boolean bl = policy.vspaceEnable = mpolicy.optInt("vspace_enable") > 0;
            if (policy.vspaceEnable) {
                policy.vspaceAlgo = mpolicy.optString("vspace_algo");
                policy.vspaceAlgo = policy.vspaceAlgo.equalsIgnoreCase("RSA-SM4-SHA1") ? "sm4" : "aes";
                policy.vspaceEraseOnUninstall = mpolicy.optInt("vspace_erase_uninstall") > 0;
                policy.vspaceEraseOnRooted = mpolicy.optInt("vspace_erase_rooted") > 0;
                policy.vspaceEraseOnTimeout = mpolicy.optInt("vspace_erase_timeout");
            }
            boolean bl2 = policy.dmEnable = mpolicy.optInt("mdm_enable") > 0;
            if (policy.dmEnable) {
                policy.dmCameraEnable = mpolicy.optInt("mdm_camera") > 0;
                policy.dmPasswordType = mpolicy.optInt("mdm_pass_type");
                policy.dmPasswordLen = mpolicy.optInt("mdm_pass_len");
                policy.dmLockScreen = mpolicy.optInt("mdm_lock_seconds");
            }
        }
        return policy;
    }

    public void parseFromJSON(JSONObject userdata) {
        this.initialize();
        JSONObject mpolicy = userdata.optJSONObject("mpolicy");
        if (null != mpolicy) {
            JSONObject vspace;
            PLog.v("mpolicy=%s", SPJSONUtil.toString(mpolicy));
            if (mpolicy.optInt("gesture_enable") > 0) {
                this.gestureExpires = Math.max(1, mpolicy.optInt("gesture_expires"));
                boolean bl = this.gestureLogin = this.gestureExpires > 0 && 0 != mpolicy.optInt("gesture_login", 0);
            }
            if (null != (vspace = SPJSONUtil.parseObject(mpolicy.optString("vspace")))) {
                boolean bl = this.vspaceEnable = 0 != vspace.optInt("enable_encrypt");
                if (this.vspaceEnable) {
                    this.vspaceEraseOnUninstall = 0 != vspace.optInt("remove_type1");
                    this.vspaceEraseOnRooted = 0 != vspace.optInt("remove_type2");
                    this.vspaceEraseOnTimeout = vspace.optInt("remove_type3") > 0 ? vspace.optInt("timeout") : 0;
                    this.vspaceWhiteList = vspace.optString("white_list", "");
                    this.vspaceBlackList = vspace.optString("blank_list", "");
                    int smx = GatewayLink.getSSLSMXVersion(vspace.optString("encrypt_algorithm", "aes"));
                    this.vspaceAlgo = smx == 4 ? "sm4" : "aes";
                }
            }
            boolean bl = this.dmEnable = 0 != mpolicy.optInt("app_device_mdm", 0);
            if (this.dmEnable) {
                JSONObject dm = SPJSONUtil.parseObject(mpolicy.optString("control"));
                if (null != dm) {
                    this.dmEnable = true;
                    boolean bl2 = this.dmCameraEnable = 0 == dm.optInt("disable_camera");
                    if (dm.optInt("enable_pass_policy") > 0) {
                        this.dmPasswordType = dm.optInt("pass_policy_type");
                        this.dmPasswordLen = dm.optInt("pass_length");
                        this.dmLockScreen = (dm.optInt("lock_screen") >= 1 ? dm.optInt("lock_time") : 0) * 60;
                    }
                } else {
                    this.dmEnable = false;
                }
            }
        }
        this.inetBlockingEnable = 0 != userdata.optInt("split_tunnel_open", 0);
        String blacks = userdata.optString("split_tunnel_list");
        if (this.inetBlockingEnable & !TextUtils.isEmpty((CharSequence)blacks)) {
            this.inetBlockingBlackList = SPIPUtil.ipRulesToPool(blacks.trim(), "|").combine().getIPRanges();
        }
        PLog.v(this.toString(), new Object[0]);
    }

    private void initialize() {
        this.vspaceEnable = false;
        this.vspaceEraseOnUninstall = false;
        this.vspaceEraseOnRooted = false;
        this.vspaceEraseOnTimeout = 0;
        this.gestureExpires = 0;
        this.gestureLogin = false;
        this.inetBlockingEnable = false;
        this.inetBlockingBlackList.clear();
        this.dmEnable = false;
        this.dmCameraEnable = true;
        this.dmPasswordType = 0;
        this.dmPasswordLen = 0;
        this.dmLockScreen = 0;
        this.pkgappNotifyEnable = false;
        this.pkgappUpgrade = 0;
        this.pkgappNCEnable = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserPolicy[");
        sb.append("vspaceEnable=").append(this.vspaceEnable);
        sb.append(", vspaceEraseOnUninstall=").append(this.vspaceEraseOnUninstall);
        sb.append(", vspaceEraseOnRooted=").append(this.vspaceEraseOnRooted);
        sb.append(", vspaceEraseOnTimeout=").append(this.vspaceEraseOnTimeout);
        sb.append(", gestureExpires=").append(this.gestureExpires);
        sb.append(", gestureLogin=").append(this.gestureLogin);
        sb.append(", inetBlocking=").append(this.inetBlockingEnable);
        sb.append(", inetBlockingBlackList=").append(this.inetBlockingBlackList.toString());
        sb.append(", dmEnable=").append(this.dmEnable);
        sb.append(", dmCameraEnable=").append(this.dmCameraEnable);
        sb.append(", dmPasswordType=").append(this.dmPasswordType);
        sb.append(", dmPasswordLen=").append(this.dmPasswordLen);
        sb.append(", dmLockScreen=").append(this.dmLockScreen);
        sb.append(", pkgappNotifyEnable=").append(this.pkgappNotifyEnable);
        sb.append(", pkgappNCEnable=").append(this.pkgappNCEnable);
        sb.append(", pkgappUpgrade=").append(this.pkgappUpgrade);
        sb.append("]");
        return sb.toString();
    }
}

