/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import java.io.Serializable;
import org.json.JSONObject;

public class SPUserInfo
implements Serializable {
    private static final long serialVersionUID = -7432749441911851916L;
    public static final int TICKET_LEN = 32;
    public SPAuthServerInfo authsvr = new SPAuthServerInfo();
    public byte[] ticket = new byte[32];
    public String ticketstr = "";
    public int uid = 0;
    public String username = "";
    public String password = "";
    public int eid = 0;
    public int authType = 0;
    public boolean passwResetable = true;
    public JSONObject extra = null;
    public String authJStr = "";
    public String access_token = null;

    public static SPUserInfo fromBrokerJSON(JSONObject json) {
        SPUserInfo user = new SPUserInfo();
        user.uid = json.optInt("uid");
        user.eid = json.optInt("eid");
        user.username = json.optString("username");
        user.ticketstr = json.optString("ticket");
        user.ticket = SPStringUtil.ticketToBytes(user.ticketstr);
        user.extra = json.optJSONObject("extra");
        user.authsvr = SPAuthServerInfo.fromBrokerJSON(json.optJSONObject("next_auth"));
        user.authType = user.authsvr.sub_type;
        user.authJStr = json.optString("login_json");
        user.passwResetable = json.optInt("pass_resetable") > 0;
        user.access_token = json.optString("access_token", "");
        return user;
    }

    public void copyFrom(SPUserInfo other) {
        this.uid = other.uid;
        this.eid = other.eid;
        this.username = other.username;
        this.authsvr = other.authsvr;
        System.arraycopy(other.ticket, 0, this.ticket, 0, this.ticket.length);
        this.ticketstr = other.ticketstr;
        this.extra = other.extra;
        this.authsvr = other.authsvr;
        this.authType = other.authType;
        this.passwResetable = other.passwResetable;
        this.authJStr = other.authJStr;
        this.access_token = other.access_token;
    }

    public String getExtra(String kname) {
        return null != this.extra ? this.extra.optString(kname, "") : "";
    }
}

