/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.text.TextUtils;
import com.secure.sportal.entry.IPHost;
import com.secure.sportal.entry.SPAppInfo;
import com.secure.sportal.entry.SPLoadItem;
import com.secure.sportal.entry.SPServiceInfo;
import com.secure.sportal.entry.SPUserPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPUserDataInfo
implements Serializable {
    private static final long serialVersionUID = 5947365848437806608L;
    public String vpn_ip = "";
    public String gateway_version = "";
    public String userpass = "";
    public int needsBind = 0;
    public String machineid = "";
    public int compress = 0;
    public long deviceTime = 0L;
    public int eid = 0;
    public int uid = 0;
    public String username = "";
    public String userDomain = "";
    public int userExpires = 0;
    public int rdpOptimize = 0;
    public boolean noBlockHeaderEnabled = true;
    public String smxAlgCipher = "";
    public SPUserPolicy policy = new SPUserPolicy();
    public SPAppInfo pkg_appinfo = null;
    public List<IPHost> iphosts = new ArrayList<IPHost>();
    public List<SPLoadItem> loads = new ArrayList<SPLoadItem>();
    public List<SPServiceInfo> proxySvcList = new ArrayList<SPServiceInfo>();
    public List<SPServiceInfo> ncSvcList = new ArrayList<SPServiceInfo>();
    public String proto_version = "";

    public void addIPHost(String hostname, String ip) {
        if (TextUtils.isEmpty((CharSequence)hostname) || TextUtils.isEmpty((CharSequence)ip) || ip.equals("0.0.0.0")) {
            return;
        }
        for (IPHost iphost : this.iphosts) {
            if (!iphost.host.equalsIgnoreCase(hostname)) continue;
            return;
        }
        this.iphosts.add(new IPHost(ip, hostname));
    }

    public static SPUserDataInfo fromBrokerJSON(JSONObject json) {
        SPUserDataInfo userdata = new SPUserDataInfo();
        userdata.needsBind = json.optInt("hostbind_needs");
        userdata.eid = json.optInt("eid");
        userdata.uid = json.optInt("uid");
        userdata.userDomain = json.optString("domain");
        userdata.username = json.optString("username");
        userdata.gateway_version = json.optString("gateway_version", "");
        userdata.proto_version = json.optString("proto_version", "");
        userdata.compress = json.optInt("compress");
        userdata.rdpOptimize = json.optInt("rdp_optimize");
        userdata.noBlockHeaderEnabled = 1 != json.optInt("tunnel_block_tlv");
        userdata.smxAlgCipher = json.optString("sslsmx_alg_cipher");
        userdata.policy = SPUserPolicy.fromBrokerJSON(json);
        JSONArray iphosts = json.optJSONArray("iphosts");
        for (int i = 0; null != iphosts && i < iphosts.length(); ++i) {
            try {
                String[] host = iphosts.optString(i).split(" ");
                userdata.addIPHost(host[1], host[0]);
                continue;
            }
            catch (Exception host) {
                // empty catch block
            }
        }
        JSONArray services = json.optJSONArray("services");
        for (int i = 0; null != services && i < services.length(); ++i) {
            SPServiceInfo svc = SPServiceInfo.fromBrokerJSON(services.optJSONObject(i));
            if (svc.access == 1) {
                userdata.ncSvcList.add(svc);
                continue;
            }
            userdata.proxySvcList.add(svc);
        }
        return userdata;
    }
}

