/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import com.secure.comm.utils.SPJSONUtil;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPTunStatus {
    public String vpn_host = "";
    public int vpn_port = 443;
    public String ipv4 = "";
    public String ipv6 = "";
    public int mtu = 1400;
    public int status = 0;
    public long ctime = 0L;
    public List<String> dns = new ArrayList<String>();
    public List<String> routes = new ArrayList<String>();
    public boolean routeAuto = true;
    public AtomicLong bytesUp = new AtomicLong(0L);
    public AtomicLong bytesDown = new AtomicLong(0L);

    public SPTunStatus clone() {
        SPTunStatus copy = new SPTunStatus();
        copy.vpn_host = this.vpn_host;
        copy.vpn_port = this.vpn_port;
        copy.ipv4 = this.ipv4;
        copy.ipv6 = this.ipv6;
        copy.status = this.status;
        copy.ctime = this.ctime;
        copy.dns.addAll(this.dns);
        copy.routes.addAll(this.routes);
        copy.routeAuto = this.routeAuto;
        copy.bytesUp.set(this.bytesUp.get());
        copy.bytesDown.set(this.bytesDown.get());
        return copy;
    }

    public void clear() {
        this.vpn_host = "";
        this.vpn_port = 443;
        this.ipv4 = "";
        this.ipv6 = "";
        this.mtu = 1400;
        this.status = 0;
        this.ctime = 0L;
        this.dns.clear();
        this.routes.clear();
        this.routeAuto = true;
        this.bytesUp.set(0L);
        this.bytesDown.set(0L);
    }

    public boolean isStoped() {
        return this.status != 1 && this.status != 2;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "vpn_host", this.vpn_host);
        SPJSONUtil.putStr(json, "vpn_port", this.vpn_port);
        SPJSONUtil.put(json, "utun_ipv4", this.ipv4);
        SPJSONUtil.put(json, "utun_ipv6", this.ipv6);
        SPJSONUtil.putStr(json, "mtu", this.mtu);
        switch (this.status) {
            case 0: {
                SPJSONUtil.put(json, "status", "disconnected");
                break;
            }
            case 1: {
                SPJSONUtil.put(json, "status", "connecting");
                break;
            }
            case 2: {
                SPJSONUtil.put(json, "status", "connected");
                break;
            }
            case 3: {
                SPJSONUtil.put(json, "status", "error");
                break;
            }
            default: {
                SPJSONUtil.put(json, "status", "disconnected");
            }
        }
        SPJSONUtil.putStr(json, "mtu", this.mtu);
        SPJSONUtil.put(json, "ctime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(this.ctime)));
        JSONArray jdns = new JSONArray();
        for (String item : this.dns) {
            jdns.put((Object)item);
        }
        SPJSONUtil.put(json, "dns", jdns);
        JSONArray jroutes = new JSONArray();
        for (String item : this.routes) {
            jroutes.put((Object)item);
        }
        SPJSONUtil.put(json, "routes", jroutes);
        SPJSONUtil.put(json, "route_auto", this.routeAuto ? "YES" : "NO");
        SPJSONUtil.putStr(json, "bytes_up", (int)this.bytesUp.get());
        SPJSONUtil.putStr(json, "bytes_down", (int)this.bytesDown.get());
        return json;
    }
}

