/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.text.TextUtils;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class SPServiceInfo
implements Serializable {
    private static final long serialVersionUID = 283393694616026951L;
    public static final int ACCESS_PROXY = 0;
    public static final int ACCESS_NC = 1;
    public static final int ACCESS_RDP = 4;
    public static final int TYPE_HTTP = 1;
    public static final int TYPE_HTTPS = 2;
    public static final int TYPE_FTP = 3;
    public int id = 0;
    public int groupid = 0;
    public List<Integer> groupids = new ArrayList<Integer>();
    public String name = "";
    public int type = 1;
    public int access = 0;
    public int access_agent = 0;
    public int flag = 0;
    public boolean hidden = false;
    public String hostname = "";
    public String ipaddr = "";
    public int port = 0;
    public String path = "";
    public String orig_servername = "";
    public String orig_serverip = "";
    public String orig_typeport = "";

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceInfo[id=").append(this.id);
        sb.append(",name=").append(this.name);
        sb.append(",type=").append(this.type);
        sb.append(",access=").append(this.access);
        sb.append(",access_agent=").append(this.access_agent);
        sb.append(",hostname='").append(this.hostname);
        sb.append(",ipaddr='").append(this.ipaddr);
        sb.append("',path='").append(this.path);
        sb.append(",port=").append(this.port).append("]");
        return sb.toString();
    }

    public JSONObject toJSON() {
        JSONObject json_svc = new JSONObject();
        SPJSONUtil.put(json_svc, "id", String.valueOf(this.id));
        SPJSONUtil.put(json_svc, "type", String.valueOf(this.type));
        SPJSONUtil.put(json_svc, "access", String.valueOf(this.access));
        SPJSONUtil.put(json_svc, "access_agent", String.valueOf(this.access_agent));
        SPJSONUtil.put(json_svc, "flag", "0");
        SPJSONUtil.put(json_svc, "hostname", this.hostname);
        SPJSONUtil.put(json_svc, "ipaddr", this.ipaddr);
        SPJSONUtil.put(json_svc, "port", this.port);
        SPJSONUtil.put(json_svc, "orig_servername", this.orig_servername);
        SPJSONUtil.put(json_svc, "orig_serverip", this.orig_serverip);
        SPJSONUtil.put(json_svc, "orig_typeport", this.orig_typeport);
        return json_svc;
    }

    public static SPServiceInfo fromBrokerJSON(JSONObject json) {
        SPServiceInfo svc = new SPServiceInfo();
        svc.id = json.optInt("id");
        svc.groupid = json.optInt("groupid");
        String groupids = json.optString("groupids");
        if (null != groupids && groupids.length() > 0) {
            String[] pieces;
            for (String piece : pieces = groupids.split(",")) {
                int gid = SPStringUtil.parseInt(piece);
                if (gid <= 0) continue;
                svc.groupids.add(gid);
            }
            if (svc.groupids.size() > 0) {
                svc.groupid = svc.groupids.get(0);
            }
        }
        svc.name = json.optString("name");
        svc.access = json.optInt("access");
        svc.type = json.optInt("type", 1);
        svc.flag = 0;
        svc.hostname = json.optString("hostname");
        svc.path = json.optString("path");
        svc.access_agent = json.optInt("access_agent");
        svc.hidden = json.optInt("hidden") > 0;
        svc.orig_servername = json.optString("orig_servername");
        svc.orig_serverip = json.optString("orig_serverip");
        svc.orig_typeport = json.optString("orig_typeport");
        svc.hostname = json.optString("hostname");
        svc.ipaddr = json.optString("ipv4_start");
        if (TextUtils.isEmpty((CharSequence)svc.ipaddr)) {
            svc.ipaddr = SPStringUtil.opt(json.optString("ipv6_start"));
        }
        svc.port = json.optInt("port_start");
        return svc;
    }
}

