/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.entry.SPAuthServerInfo;
import com.secure.sportal.entry.SPPasswordPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPPortalInfo
implements Serializable {
    private static final long serialVersionUID = 9063181632020214895L;
    public List<SPAuthServerInfo> authList = new ArrayList<SPAuthServerInfo>();
    public boolean canUserRegist = false;
    public boolean retrievePassw = false;
    public int showAuthen;
    public int carrierTypes = 0;
    public int certPolicy;
    public boolean antivirus = false;
    public int smxAlgID = 0;
    public String smxAlgCipher = "";
    public String smxContainer = "";
    public String smxApp = "";
    public boolean smxCertEnable = false;
    public boolean vpnIPFixed = false;
    public String vpnIPAddr = "";
    public int vpnPortEx = 0;
    public SPPasswordPolicy passwPolicy = new SPPasswordPolicy();

    public static int terminalMask(int terminalTypes) {
        if (terminalTypes == 0) {
            return 65535;
        }
        int mask = 0;
        if ((terminalTypes & 1) == 1) {
            mask |= 1;
        }
        if ((terminalTypes >> 1 & 1) == 1) {
            mask |= 8;
        }
        if ((terminalTypes >> 2 & 1) == 1) {
            mask |= 4;
        }
        if ((terminalTypes >> 3 & 1) == 1) {
            mask |= 2;
        }
        if ((terminalTypes & 0xF0) > 0) {
            mask |= 0x100;
        }
        return mask;
    }

    public static SPPortalInfo fromBrokerJSON(JSONObject json) {
        SPPortalInfo portal = new SPPortalInfo();
        portal.antivirus = json.optInt("antivirus") > 0;
        portal.showAuthen = json.optInt("show_authen");
        portal.certPolicy = json.optInt("cert_policy");
        portal.carrierTypes = json.optInt("carrier_option");
        portal.canUserRegist = json.optInt("registable") > 0;
        portal.retrievePassw = json.optInt("retrievable") > 0;
        portal.passwPolicy = SPPasswordPolicy.fromBrokerRsp(json.optJSONObject("password_policy"));
        portal.smxAlgID = json.optInt("sslsmx_alg_id");
        portal.smxAlgCipher = json.optString("sslsmx_alg_cipher");
        portal.smxContainer = json.optString("sslsmx_container");
        portal.smxApp = json.optString("sslsmx_app");
        portal.smxCertEnable = json.optInt("sslsmx_cert_enable") > 0;
        portal.vpnPortEx = json.optInt("vpn_port_ext", 0);
        portal.vpnIPFixed = json.optInt("vpn_ip_fixed", 0) == 1;
        portal.vpnIPAddr = json.optString("vpn_ipaddr", "");
        JSONArray authsvrs = json.optJSONArray("authsvrs");
        if (null != authsvrs) {
            for (int i = 0; i < authsvrs.length(); ++i) {
                portal.authList.add(SPAuthServerInfo.fromBrokerJSON(authsvrs.optJSONObject(i)));
            }
        }
        return portal;
    }

    public SPAuthServerInfo getAuthServerByID(int auth_id) {
        for (SPAuthServerInfo auth : this.authList) {
            if (auth.id != auth_id) continue;
            return auth;
        }
        return null;
    }

    public SPAuthServerInfo getAuthServerByName(String auth_name) {
        if ((auth_name = SPStringUtil.opt(auth_name)).length() > 0) {
            for (SPAuthServerInfo auth : this.authList) {
                if (!auth_name.equals(auth.name)) continue;
                return auth;
            }
        }
        return null;
    }
}

