/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import com.secure.comm.utils.SPJSONUtil;
import java.io.Serializable;
import org.json.JSONObject;

public class SPPasswordPolicy
implements Serializable {
    private static final long serialVersionUID = 5428926930065993788L;
    public int minLen = 6;
    public int maxLen = 32;
    public int digit = 0;
    public int lower = 0;
    public int upper = 0;
    public int special = 0;
    public int expireDays = 0;
    public int alertDays = 0;
    public boolean resetFirstLogon = false;
    public boolean sameToOld = false;

    public static SPPasswordPolicy fromBrokerRsp(JSONObject json) {
        SPPasswordPolicy policy = new SPPasswordPolicy();
        if (null != json) {
            policy.minLen = json.optInt("min_len");
            policy.maxLen = json.optInt("max_len");
            policy.digit = json.optInt("digit");
            policy.lower = json.optInt("lower");
            policy.upper = json.optInt("upper");
            policy.special = json.optInt("special");
            policy.expireDays = json.optInt("expire_days");
            policy.alertDays = json.optInt("alert_days");
            policy.resetFirstLogon = json.optInt("reset_1st_logon") != 0;
            policy.sameToOld = json.optInt("same_to_old") != 0;
        }
        return policy;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "min_len", String.valueOf(this.minLen));
        SPJSONUtil.put(json, "max_len", String.valueOf(this.maxLen));
        SPJSONUtil.put(json, "digit", String.valueOf(this.digit));
        SPJSONUtil.put(json, "lower", String.valueOf(this.lower));
        SPJSONUtil.put(json, "upper", String.valueOf(this.upper));
        SPJSONUtil.put(json, "special", String.valueOf(this.special));
        SPJSONUtil.put(json, "expire_days", String.valueOf(this.expireDays));
        SPJSONUtil.put(json, "alert_days", String.valueOf(this.alertDays));
        SPJSONUtil.put(json, "reset_1st_logon", this.resetFirstLogon ? "1" : "0");
        SPJSONUtil.put(json, "same_to_old", this.sameToOld ? "1" : "0");
        return json;
    }
}

