/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SPNetItemInfo
implements Comparable<SPNetItemInfo> {
    public static final String[] PROTOCOLS = new String[]{"tcp", "tcp6", "udp", "udp6", "raw", "raw6"};
    public static final String[] STATES = new String[]{"ERROR_STATUS", "TCP_ESTABLISHED", "TCP_SYN_SENT", "TCP_SYN_RECV", "TCP_FIN_WAIT1", "TCP_FIN_WAIT2", "TCP_TIME_WAIT", "TCP_CLOSE", "TCP_CLOSE_WAIT", "TCP_LAST_ACK", "TCP_LISTEN", "TCP_CLOSING"};
    public static int PROTOCOL_TCP = 0;
    public static int PROTOCOL_TCP6 = 1;
    public static int PROTOCOL_UDP = 2;
    public static int PROTOCOL_UDP6 = 3;
    public static int PROTOCOL_RAW = 4;
    public static int PROTOCOL_RAW6 = 5;
    public static final int STATE_ERROR_STATUS = 0;
    public static final int STATE_TCP_ESTABLISHED = 1;
    public static final int STATE_TCP_SYN_SENT = 2;
    public static final int STATE_TCP_SYN_RECV = 3;
    public static final int STATE_TCP_FIN_WAIT1 = 4;
    public static final int STATE_TCP_FIN_WAIT2 = 5;
    public static final int STATE_TCP_TIME_WAIT = 6;
    public static final int STATE_TCP_CLOSE = 7;
    public static final int STATE_TCP_CLOSE_WAIT = 8;
    public static final int STATE_TCP_LAST_ACK = 9;
    public static final int STATE_TCP_LISTEN = 10;
    public static final int STATE_TCP_CLOSING = 11;
    public int protocol = PROTOCOL_TCP;
    public String rem_ip = "";
    public int rem_port = 0;
    public int state = -1;
    public int uid = 0;
    public int pid = 0;
    public String pkgname = "";

    public static List<SPNetItemInfo> loadNetConnList(Context context, boolean total) {
        ArrayList<SPNetItemInfo> items = new ArrayList<SPNetItemInfo>();
        String[] files = null;
        files = total ? new String[]{"tcp", "tcp6", "udp", "udp6", "raw", "raw6"} : new String[]{"tcp", "tcp6"};
        for (String fn : files) {
            String content = new String(SPNetItemInfo.readFile("/proc/self/net/" + fn));
            String[] lines = content.split("\n");
            for (int i = 1; i < lines.length; ++i) {
                SPNetItemInfo info = SPNetItemInfo.parse(fn, lines[i]);
                if (info.state == 10 || info.rem_ip.equals("0.0.0.0")) continue;
                items.add(info);
            }
        }
        PackageManager pm = context.getPackageManager();
        ActivityManager am = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        ArrayList processes = new ArrayList();
        try {
            processes.addAll(am.getRunningAppProcesses());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        block6: for (SPNetItemInfo item : items) {
            try {
                item.pkgname = pm.getNameForUid(item.uid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (ActivityManager.RunningAppProcessInfo p : processes) {
                if (null == p.processName || !p.processName.equals(item.pkgname)) continue;
                item.pid = p.pid;
                continue block6;
            }
        }
        return items;
    }

    public static SPNetItemInfo parse(String protocol, String line) {
        SPNetItemInfo item = new SPNetItemInfo();
        if ("tcp".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_TCP;
        } else if ("tcp6".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_TCP6;
        } else if ("udp".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_UDP;
        } else if ("udp6".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_UDP6;
        } else if ("raw".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_RAW;
        } else if ("raw6".equalsIgnoreCase(protocol)) {
            item.protocol = PROTOCOL_RAW6;
        }
        String[] fields = line.trim().split("\\s+");
        String[] rem_addr = fields[2].split("\\:");
        item.rem_ip = SPNetItemInfo.parseIP(rem_addr[0]);
        item.rem_port = Integer.parseInt(rem_addr[1], 16) & 0xFFFF;
        item.state = Integer.parseInt(fields[3], 16);
        item.uid = Integer.parseInt(fields[7]);
        return item;
    }

    public static String parseIP(String str) {
        long ip = Long.parseLong(str.substring(str.length() - 8), 16);
        StringBuilder ipaddr = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            long b = ip & 0xFFL;
            if (i > 0) {
                ipaddr.append(".");
            }
            ipaddr.append(String.valueOf(b));
            ip >>= 8;
        }
        return ipaddr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String filename) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            int len = 0;
            while (-1 != (len = ((InputStream)ins).read(buffer))) {
                baos.write(buffer, 0, len);
            }
            ((InputStream)ins).close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (ins != null) {
                    ((InputStream)ins).close();
                }
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }

    @Override
    public int compareTo(SPNetItemInfo o) {
        return this.uid < o.uid ? -1 : (this.uid == o.uid ? 0 : 1);
    }
}

