/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.secure.comm.utils.SPJSONUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class SPLiteBundle
implements Serializable {
    private static final long serialVersionUID = -3626767150347754818L;
    protected Map<String, Object> mData = new HashMap<String, Object>();

    public SPLiteBundle() {
        this(null);
    }

    public SPLiteBundle(Bundle data) {
        if (null != data) {
            for (String key : data.keySet()) {
                this.mData.put(key, data.get(key));
            }
        }
    }

    public void clear() {
        this.mData.clear();
    }

    public Set<String> keySet() {
        return this.mData.keySet();
    }

    public JSONObject toJSON(JSONObject json) {
        if (null == json) {
            json = new JSONObject();
        }
        this.beforeOutput();
        for (String key : this.mData.keySet()) {
            SPJSONUtil.put(json, key, this.mData.get(key));
        }
        return json;
    }

    public void fromJSON(JSONObject json) {
        this.mData.clear();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key;
            Object value = json.opt(key = (String)keys.next());
            this.mData.put(key, null != value ? value.toString() : "");
        }
        this.afterInput();
    }

    public SPLiteBundle put(String name, int value) {
        this.mData.put(name, value);
        return this;
    }

    public SPLiteBundle put(String name, String value) {
        this.mData.put(name, null != value ? value : "");
        return this;
    }

    public SPLiteBundle put(String name, JSONObject value) {
        if (!TextUtils.isEmpty((CharSequence)name) && null != value) {
            this.mData.put(name, value);
        }
        return this;
    }

    public void put(SPLiteBundle other) {
        if (null != other && null != other.mData) {
            for (String key : other.mData.keySet()) {
                this.mData.put(key, other.mData.get(key));
            }
        }
    }

    public void putProperties(Properties properties) {
        if (null != properties) {
            for (Object key : properties.keySet()) {
                try {
                    this.put(key.toString(), properties.get(key).toString());
                }
                catch (Exception exception) {}
            }
        }
    }

    public void remove(String name) {
        this.mData.remove(name);
    }

    public String getStr(String name) {
        return this.getStr(name, "");
    }

    public String getStr(String name, String defv) {
        Object o = this.mData.get(name);
        return null == o ? defv : o.toString();
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defv) {
        Object o = this.mData.get(name);
        if (null == o) {
            return defv;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString().trim());
        }
        catch (Exception ex) {
            return defv;
        }
    }

    public String toString() {
        return this.mData.toString();
    }

    public String toBase64String() {
        return Base64.encodeToString((byte[])this.toJSON(null).toString().getBytes(), (int)2);
    }

    public void fromBase64String(String str) {
        this.clear();
        String jstr = new String(Base64.decode((String)str, (int)2));
        this.fromJSON(SPJSONUtil.parseObject(jstr));
    }

    protected void beforeOutput() {
    }

    protected void afterInput() {
    }
}

