/*
 * Decompiled with CFR 0.152.
 */
package com.secure.sportal.entry;

import android.text.TextUtils;
import android.util.Base64;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPAppInfo {
    public int appid;
    public String pkgname;
    public String app_identify;
    public String title;
    public String version;
    public long mtime;
    public String comment;
    public long filesize;
    public String iconfile;
    public String appfile;
    public int downloads;
    public String pubtime;
    public List<Launcher> launchers = new ArrayList<Launcher>();

    public boolean isHidden() {
        return null != this.launchers && this.launchers.size() > 0;
    }

    public void addLauncher(String label, String cls) {
        Launcher l = new Launcher();
        l.label = label;
        l.clsname = cls;
        this.launchers.add(l);
    }

    public static SPAppInfo fromBrokerJSON(JSONObject json) {
        SPAppInfo app = new SPAppInfo();
        app.appid = json.optInt("id");
        app.pkgname = json.optString("package_name");
        app.title = json.optString("title");
        app.version = json.optString("version");
        app.mtime = json.optInt("mtime");
        app.filesize = json.optLong("file_size");
        app.comment = json.optString("comment");
        app.downloads = json.optInt("downloads");
        app.pubtime = json.optString("pub_time");
        app.app_identify = json.optString("app_identify");
        app.appfile = json.optString("app_file");
        app.iconfile = json.optString("icon_path");
        String launchers = json.optString("launchers");
        if (!TextUtils.isEmpty((CharSequence)launchers)) {
            launchers = new String(Base64.decode((String)launchers, (int)2));
            try {
                JSONArray classes = new JSONArray(launchers);
                for (int j = 0; j < classes.length(); ++j) {
                    JSONObject cls = classes.optJSONObject(j);
                    app.addLauncher(cls.optString("label"), cls.optString("class"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return app;
    }

    public static class Launcher {
        public String label;
        public String clsname;
    }
}

