/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.view;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.secure.comm.app.SPResourseKit;
import com.secure.comm.utils.SPDrawableUtil;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopup;
import com.secure.comm.view.SPPopupClosedListener;

public class SPPopupWaiting
extends SPPopup
implements Handler.Callback {
    private static final int WHAT_UPDATE_IMGLEVEL = 1234;
    protected Handler mHandler = null;
    private TextView mMessageText = null;
    private ImageView[] mDotImages = null;
    private int mLevel = 0;

    public static SPPopupWaiting popup(Context context, CharSequence title, SPPopupClosedListener listener, CharSequence positive) {
        SPPopupWaiting popup = SPPopupWaiting.create(context, title, listener, positive, "", "");
        try {
            popup.dialog().show();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return popup;
    }

    public static SPPopupWaiting create(Context context, CharSequence title, SPPopupClosedListener listener, CharSequence positive, CharSequence negative, CharSequence neutral) {
        SPPopupWaiting popup = new SPPopupWaiting(listener);
        View view = null;
        try {
            view = SPResourseKit.inflateByName(context, "sportal_waiting_indicator");
            popup.mMessageText = (TextView)SPResourseKit.findViewByNameEx(view, "sportal_waiting_text_message");
            popup.mDotImages = new ImageView[]{(ImageView)SPResourseKit.findViewByNameEx(view, "sportal_waiting_image_icon0"), (ImageView)SPResourseKit.findViewByNameEx(view, "sportal_waiting_image_icon1"), (ImageView)SPResourseKit.findViewByNameEx(view, "sportal_waiting_image_icon2")};
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == view) {
            view = popup.createBaseView(context);
        }
        popup.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)popup);
        popup.build(context, title, null, view, positive, negative, neutral);
        return popup;
    }

    private SPPopupWaiting(SPPopupClosedListener l) {
        super(l);
    }

    private View createBaseView(Context context) {
        int dp16 = (int)SPViewUtil.dp2px(context, 16.0f);
        int dp24 = (int)SPViewUtil.dp2px(context, 24.0f);
        LinearLayout rootView = new LinearLayout(context);
        rootView.setLayoutParams(new ViewGroup.LayoutParams(-1, dp24 * 3));
        rootView.setGravity(17);
        rootView.setOrientation(0);
        rootView.setPadding(0, dp24, 0, dp24);
        this.mDotImages = new ImageView[3];
        Drawable[] drawables = new Drawable[]{SPDrawableUtil.ovalSolid(-3355444, dp16), SPDrawableUtil.ovalSolid(-2143895309, dp16), SPDrawableUtil.ovalSolid(-13188877, dp16)};
        for (int i = 0; i < this.mDotImages.length; ++i) {
            this.mDotImages[i] = new ImageView(context);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dp16, dp16);
            lp.setMargins(dp24, 0, dp24, 0);
            this.mDotImages[i].setImageDrawable(SPDrawableUtil.levelList(drawables, new int[]{0, 1, 2}, new int[]{0, 1, 2}));
            rootView.addView((View)this.mDotImages[i], (ViewGroup.LayoutParams)lp);
        }
        return rootView;
    }

    @Override
    public SPPopup setMessage(final CharSequence msg) {
        if (null != this.mMessageText) {
            if (SPSystemUtil.isRunInMainThread()) {
                this.mMessageText.setVisibility(TextUtils.isEmpty((CharSequence)msg) ? 8 : 0);
                this.mMessageText.setText(SPPopupWaiting.tintMessage(msg));
            } else {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPPopupWaiting.this.setMessage(msg);
                    }
                }, 0L);
            }
        } else {
            super.setMessage(msg);
        }
        return this;
    }

    @Override
    public void onShow(DialogInterface dialog) {
        super.onShow(dialog);
        if (null != this.mHandler) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.sendEmptyMessageDelayed(1234, 50L);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1234) {
            if (null != this.mDialog && this.mDialog.isShowing()) {
                this.mLevel = (this.mLevel + 1) % 3;
                this.updateImageLevel();
            }
            this.mHandler.sendEmptyMessageDelayed(1234, 200L);
        }
        return false;
    }

    private void updateImageLevel() {
        this.mDotImages[0].setImageLevel(this.mLevel);
        this.mDotImages[1].setImageLevel((this.mLevel + 1) % 3);
        this.mDotImages[2].setImageLevel((this.mLevel + 2) % 3);
    }

    @Override
    protected void onClosePopup(int which) {
        if (null != this.mHandler) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }
}

