/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.secure.comm.utils.SPViewUtil;
import com.secure.comm.view.SPPopup;

public class SPPopupInputBox
extends SPPopup {
    private SPInputBoxCallback mCallback;
    private LinearLayout mRootView;
    private EditText mEditText;
    private CheckBox mCheckBox;

    public static SPPopupInputBox inputBox(Context context, CharSequence title, CharSequence chkTitle, SPInputBoxCallback callback) {
        return SPPopupInputBox.inputBox(context, title, 1, chkTitle, null, null, callback);
    }

    public static SPPopupInputBox inputBox(Context context, CharSequence title, int inputType, CharSequence chkTitle, CharSequence hint, CharSequence initText, SPInputBoxCallback callback) {
        SPPopupInputBox dlg = new SPPopupInputBox(callback);
        dlg.mRootView = new LinearLayout(context);
        int padding = (int)SPViewUtil.dp2px(context, 16.0f);
        dlg.mRootView.setPadding(padding, padding, padding, padding);
        dlg.mRootView.setOrientation(1);
        dlg.mRootView.setGravity(19);
        dlg.mEditText = new EditText(context);
        dlg.mEditText.setInputType(inputType);
        dlg.mEditText.setHint(null == hint ? title : hint);
        dlg.mEditText.setText(null == initText ? "" : initText);
        dlg.mRootView.addView((View)dlg.mEditText, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)SPViewUtil.dp2px(context, 240.0f), -2));
        dlg.mCheckBox = new CheckBox(context);
        if (!TextUtils.isEmpty((CharSequence)chkTitle)) {
            dlg.mCheckBox.setText(chkTitle);
            dlg.mRootView.addView((View)dlg.mCheckBox, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)SPViewUtil.dp2px(context, 240.0f), -2));
        }
        dlg.build(context, title, null, (View)dlg.mRootView, "\u786e\u5b9a", "\u53d6\u6d88", null).show();
        return dlg;
    }

    protected SPPopupInputBox(SPInputBoxCallback c) {
        super(null);
        this.mCallback = c;
    }

    @Override
    protected void onClosePopup(int which) {
        String text = null;
        if (which == -1) {
            text = this.mEditText.getText().toString();
        }
        if (null != this.mCallback) {
            this.mCallback.OnInputBoxText(text, this.mCheckBox.isChecked());
        }
    }

    public static interface SPInputBoxCallback {
        public void OnInputBoxText(String var1, boolean var2);
    }
}

