/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.view;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.view.SPPopup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class SPPopupChoice
extends SPPopup {
    private SPChoiceCallback mCallback;
    private CharSequence[] mItems;
    private String mRootDir = null;
    private String mCurrentDir = null;
    private String[] mSuffixes = null;

    public static SPPopupChoice singleChoice(Context context, CharSequence title, CharSequence[] items, int checked, SPChoiceCallback callback) {
        SPPopupChoice dlg = new SPPopupChoice(callback);
        dlg.mItems = items;
        dlg.build(context, title, null, null, null, "\u53d6\u6d88", null).setSingleChoiceItems(items, checked, (DialogInterface.OnClickListener)dlg).show();
        return dlg;
    }

    public static SPPopupChoice choiceFile(Context context, String[] suffixes, SPChoiceCallback callback) {
        SPPopupChoice dlg = new SPPopupChoice(callback);
        dlg.listSubFiles(null, null, suffixes);
        dlg.build(context, dlg.mRootDir, null, null, null, "\u53d6\u6d88", null).setSingleChoiceItems(dlg.mItems, 0, (DialogInterface.OnClickListener)dlg).show();
        return dlg;
    }

    private void listSubFiles(String root, String cd, String[] suffixes) {
        String extSDCard;
        this.mSuffixes = suffixes;
        this.mRootDir = TextUtils.isEmpty((CharSequence)root) || root.equals("/") ? (null == (extSDCard = SPFileUtil.getExtSdCardPath(null)) ? SPFileUtil.getSdCardPath() : "/") : root;
        String string2 = this.mCurrentDir = TextUtils.isEmpty((CharSequence)cd) ? this.mRootDir : cd;
        if (this.mCurrentDir.equals("/")) {
            this.mItems = new String[]{"[\u5185\u90e8\u5b58\u50a8]", "[SD \u5361]"};
        } else {
            ArrayList<String> items = new ArrayList<String>();
            File[] files = new File(this.mCurrentDir).listFiles();
            if (null != files) {
                block0: for (File file : files) {
                    if (file.getName().startsWith(".") || !file.canRead()) continue;
                    if (file.isDirectory()) {
                        items.add("[" + file.getName() + "]");
                        continue;
                    }
                    if (!file.isFile()) continue;
                    if (null != this.mSuffixes && this.mSuffixes.length > 0) {
                        for (int i = 0; i < this.mSuffixes.length; ++i) {
                            if (!file.getName().endsWith(this.mSuffixes[i]) && !SPStringUtil.wildcardMatches(file.getName(), this.mSuffixes[i])) continue;
                            items.add(file.getName());
                            continue block0;
                        }
                        continue;
                    }
                    items.add(file.getName());
                }
            }
            Collections.sort(items);
            if (!this.mRootDir.equals(this.mCurrentDir)) {
                items.add(0, "[..]");
            }
            this.mItems = items.toArray(new String[items.size()]);
        }
    }

    protected SPPopupChoice(SPChoiceCallback c) {
        super(null);
        this.mCallback = c;
    }

    @Override
    protected void onClosePopup(int which) {
        if (null != this.mItems && which >= 0 && which < this.mItems.length && null != this.mCallback) {
            if (TextUtils.isEmpty((CharSequence)this.mRootDir) || TextUtils.isEmpty((CharSequence)this.mCurrentDir)) {
                this.mCallback.OnPopupChoicedIndex(which, this.mItems[which]);
            } else {
                File file;
                String name = this.mItems[which].toString();
                File file2 = file = name.startsWith("[") && name.endsWith("]") ? new File(this.mCurrentDir + "/" + name.substring(1, name.length() - 1)) : new File(this.mCurrentDir + "/" + name);
                if (file.isFile()) {
                    this.mCallback.OnPopupChoicedIndex(which, file.getAbsolutePath());
                } else {
                    String cd = null;
                    if (name.equals("[\u5185\u90e8\u5b58\u50a8]")) {
                        cd = SPFileUtil.getSdCardPath();
                    } else if (name.equals("[SD \u5361]")) {
                        cd = SPFileUtil.getExtSdCardPath(null);
                    } else if (name.equals("[..]")) {
                        cd = this.mCurrentDir.equals(SPFileUtil.getSdCardPath()) || this.mCurrentDir.equals(SPFileUtil.getExtSdCardPath(null)) ? this.mRootDir : new File(this.mCurrentDir).getParent();
                    } else if (file.isDirectory()) {
                        cd = file.getAbsolutePath();
                    }
                    if (null != cd) {
                        SPPopupChoice dlg = new SPPopupChoice(this.mCallback);
                        dlg.listSubFiles(this.mRootDir, cd, this.mSuffixes);
                        dlg.build(this.mDialog.getContext(), cd, null, null, null, "\u53d6\u6d88", null).setSingleChoiceItems(dlg.mItems, 0, (DialogInterface.OnClickListener)dlg).show();
                    }
                }
            }
        }
    }

    public static interface SPChoiceCallback {
        public void OnPopupChoicedIndex(int var1, CharSequence var2);
    }
}

