/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.view;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.view.SPPopupClosedListener;

public abstract class SPPopup
implements DialogInterface.OnClickListener,
DialogInterface.OnShowListener {
    protected AlertDialog mDialog = null;
    protected SPPopupClosedListener mListener = null;

    protected SPPopup(SPPopupClosedListener l) {
        this.mListener = l;
    }

    protected abstract void onClosePopup(int var1);

    public static CharSequence tintMessage(CharSequence msg) {
        return Html.fromHtml((String)("<font color='#ff7900'>" + msg + "</font>"));
    }

    public static CharSequence tintButtonText(CharSequence txt) {
        return Html.fromHtml((String)("<font color='#13a0d6'>" + txt + "</font>"));
    }

    public static int theme() {
        return Build.VERSION.SDK_INT < 21 ? 3 : SPPopup.themeL();
    }

    public static int themeFS() {
        return Build.VERSION.SDK_INT < 21 ? 16974065 : SPPopup.themeL();
    }

    @TargetApi(value=21)
    private static int themeL() {
        return 16974394;
    }

    @TargetApi(value=21)
    private static int themeFSL() {
        return 16974402;
    }

    protected AlertDialog.Builder build(Context context, CharSequence title, CharSequence message, View view, CharSequence positive, CharSequence negative, CharSequence neutral) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, SPPopup.theme());
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)message)) {
            builder.setMessage(SPPopup.tintMessage(message));
        }
        builder.setCancelable(false);
        if (null != view) {
            builder.setView(view);
        }
        if (!TextUtils.isEmpty((CharSequence)positive)) {
            builder.setPositiveButton(SPPopup.tintButtonText(positive), (DialogInterface.OnClickListener)this);
        }
        if (!TextUtils.isEmpty((CharSequence)negative)) {
            builder.setNegativeButton(SPPopup.tintButtonText(negative), (DialogInterface.OnClickListener)this);
        }
        if (!TextUtils.isEmpty((CharSequence)neutral)) {
            builder.setNeutralButton(SPPopup.tintButtonText(neutral), (DialogInterface.OnClickListener)this);
        }
        this.mDialog = builder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnShowListener((DialogInterface.OnShowListener)this);
        return builder;
    }

    public AlertDialog dialog() {
        return this.mDialog;
    }

    public void onShow(DialogInterface dialog) {
    }

    public void close(int which) {
        if (null != this.mListener) {
            if (which == -1) {
                this.mListener.onDismissPositive((DialogInterface)this.mDialog);
            } else if (which == -2) {
                this.mListener.onDismissNegative((DialogInterface)this.mDialog);
            } else if (which != 0) {
                this.mListener.onDismissNeutral((DialogInterface)this.mDialog);
            }
        }
        if (null != this.mDialog && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.onClosePopup(which);
    }

    public void onClick(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.close(which);
    }

    public SPPopup setTitle(final CharSequence title) {
        if (null != this.mDialog) {
            if (SPSystemUtil.isRunInMainThread()) {
                this.mDialog.setTitle(title);
            } else {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPPopup.this.setTitle(title);
                    }
                }, 0L);
            }
        }
        return this;
    }

    public SPPopup setMessage(final CharSequence msg) {
        if (null != this.mDialog) {
            if (SPSystemUtil.isRunInMainThread()) {
                this.mDialog.setMessage(SPPopup.tintMessage(msg));
            } else {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        SPPopup.this.setMessage(msg);
                    }
                }, 0L);
            }
        }
        return this;
    }
}

