/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Base64;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.secure.PLog;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SPWebViewUtil {
    public static void stopLoading(WebView webview) {
        try {
            webview.loadUrl("about:blank");
            webview.stopLoading();
            Class.forName("android.webkit.WebView").getMethod("onPause", null).invoke((Object)webview, (Object[])null);
        }
        catch (Throwable ex) {
            PLog.v(ex);
        }
    }

    public static void injectJScriptCode(WebView webview, String jscript) {
        SPWebViewUtil.injectJScriptBase64(webview, Base64.encodeToString((byte[])jscript.getBytes(), (int)2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectJScriptAsset(Context context, WebView webview, String assetsFile) {
        InputStream input = null;
        try {
            input = context.getAssets().open(assetsFile);
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            SPWebViewUtil.injectJScriptBase64(webview, new String(buffer));
        }
        catch (Exception exception) {
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void injectJScriptBase64(WebView webview, String encoded) {
        webview.loadUrl("javascript:(function() {var parent = document.getElementsByTagName('head').item(0);var script = document.createElement('script');script.type = 'text/javascript';script.innerHTML = window.atob('" + encoded + "');parent.appendChild(script)})()");
    }

    @TargetApi(value=19)
    private static void injectJScript(WebView webview, String jscode) {
        webview.evaluateJavascript(jscode, (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
            }
        });
    }

    public static boolean setProxy(WebView webview, String host, int port) {
        try {
            if (Build.VERSION.SDK_INT <= 13) {
                return SPWebViewUtil.setProxyUpToHC(webview, host, port);
            }
            if (Build.VERSION.SDK_INT <= 15) {
                return SPWebViewUtil.setProxyICS(webview, host, port);
            }
            if (Build.VERSION.SDK_INT <= 18) {
                return SPWebViewUtil.setProxyJB(webview, host, port);
            }
            return SPWebViewUtil.setProxyKKPlus(webview, host, port, "android.app.Application");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=13)
    private static boolean setProxyUpToHC(WebView webview, String host, int port) {
        PLog.v("Setting proxy with <= 3.2 API.", new Object[0]);
        try {
            Class<?> HttpPostClass = Class.forName("org.apache.http.HttpHost");
            Constructor<?> c = HttpPostClass.getDeclaredConstructor(String.class, Integer.TYPE);
            Object proxyServer = c.newInstance(host, port);
            Class<?> networkClass = null;
            Object network = null;
            try {
                networkClass = Class.forName("android.webkit.Network");
                if (networkClass == null) {
                    PLog.i("failed to get class for android.webkit.Network", new Object[0]);
                    return false;
                }
                Method getInstanceMethod = networkClass.getMethod("getInstance", Context.class);
                if (getInstanceMethod == null) {
                    PLog.i("failed to get getInstance method", new Object[0]);
                }
                network = getInstanceMethod.invoke(networkClass, webview.getContext());
            }
            catch (Exception ex) {
                PLog.i("error getting network: " + ex, new Object[0]);
                return false;
            }
            if (network == null) {
                PLog.i("error getting network: network is null", new Object[0]);
                return false;
            }
            Object requestQueue = null;
            try {
                Field requestQueueField = networkClass.getDeclaredField("mRequestQueue");
                requestQueue = SPWebViewUtil.getFieldValueSafely(requestQueueField, network);
            }
            catch (Exception ex) {
                PLog.i("error getting field value", new Object[0]);
                return false;
            }
            if (requestQueue == null) {
                PLog.i("Request queue is null", new Object[0]);
                return false;
            }
            Field proxyHostField = null;
            try {
                Class<?> requestQueueClass = Class.forName("android.net.http.RequestQueue");
                proxyHostField = requestQueueClass.getDeclaredField("mProxyHost");
            }
            catch (Exception ex) {
                PLog.i("error getting proxy host field", new Object[0]);
                return false;
            }
            boolean temp = proxyHostField.isAccessible();
            try {
                proxyHostField.setAccessible(true);
                proxyHostField.set(requestQueue, proxyServer);
            }
            catch (Exception ex) {
                PLog.i("error setting proxy host", new Object[0]);
            }
            finally {
                proxyHostField.setAccessible(temp);
            }
            PLog.v("Setting proxy with <= 3.2 API successful!", new Object[0]);
            return true;
        }
        catch (Exception exx) {
            PLog.i("error org.apache.http.HttpHost: " + exx, new Object[0]);
            return false;
        }
    }

    @TargetApi(value=14)
    private static boolean setProxyICS(WebView webview, String host, int port) {
        try {
            PLog.v("Setting proxy with 4.0 API.", new Object[0]);
            Class<?> jwcjb = Class.forName("android.webkit.JWebCoreJavaBridge");
            Class[] params = new Class[]{Class.forName("android.net.ProxyProperties")};
            Method updateProxyInstance = jwcjb.getDeclaredMethod("updateProxy", params);
            Class<?> wv = Class.forName("android.webkit.WebView");
            Field mWebViewCoreField = wv.getDeclaredField("mWebViewCore");
            Object mWebViewCoreFieldInstance = SPWebViewUtil.getFieldValueSafely(mWebViewCoreField, webview);
            Class<?> wvc = Class.forName("android.webkit.WebViewCore");
            Field mBrowserFrameField = wvc.getDeclaredField("mBrowserFrame");
            Object mBrowserFrame = SPWebViewUtil.getFieldValueSafely(mBrowserFrameField, mWebViewCoreFieldInstance);
            Class<?> bf = Class.forName("android.webkit.BrowserFrame");
            Field sJavaBridgeField = bf.getDeclaredField("sJavaBridge");
            Object sJavaBridge = SPWebViewUtil.getFieldValueSafely(sJavaBridgeField, mBrowserFrame);
            Class<?> ppclass = Class.forName("android.net.ProxyProperties");
            Class[] pparams = new Class[]{String.class, Integer.TYPE, String.class};
            Constructor<?> ppcont = ppclass.getConstructor(pparams);
            updateProxyInstance.invoke(sJavaBridge, ppcont.newInstance(host, port, null));
            PLog.v("Setting proxy with 4.0 API successful!", new Object[0]);
            return true;
        }
        catch (Exception ex) {
            PLog.i("failed to set HTTP proxy: " + ex, new Object[0]);
            return false;
        }
    }

    @TargetApi(value=16)
    private static boolean setProxyJB(WebView webview, String host, int port) {
        PLog.v("Setting proxy with 4.1 - 4.3 API.", new Object[0]);
        try {
            Class<?> wvcClass = Class.forName("android.webkit.WebViewClassic");
            Class[] wvParams = new Class[]{Class.forName("android.webkit.WebView")};
            Method fromWebView = wvcClass.getDeclaredMethod("fromWebView", wvParams);
            Object webViewClassic = fromWebView.invoke(null, webview);
            Class<?> wv = Class.forName("android.webkit.WebViewClassic");
            Field mWebViewCoreField = wv.getDeclaredField("mWebViewCore");
            Object mWebViewCoreFieldInstance = SPWebViewUtil.getFieldValueSafely(mWebViewCoreField, webViewClassic);
            Class<?> wvc = Class.forName("android.webkit.WebViewCore");
            Field mBrowserFrameField = wvc.getDeclaredField("mBrowserFrame");
            Object mBrowserFrame = SPWebViewUtil.getFieldValueSafely(mBrowserFrameField, mWebViewCoreFieldInstance);
            Class<?> bf = Class.forName("android.webkit.BrowserFrame");
            Field sJavaBridgeField = bf.getDeclaredField("sJavaBridge");
            Object sJavaBridge = SPWebViewUtil.getFieldValueSafely(sJavaBridgeField, mBrowserFrame);
            Class<?> ppclass = Class.forName("android.net.ProxyProperties");
            Class[] pparams = new Class[]{String.class, Integer.TYPE, String.class};
            Constructor<?> ppcont = ppclass.getConstructor(pparams);
            Class<?> jwcjb = Class.forName("android.webkit.JWebCoreJavaBridge");
            Class[] params = new Class[]{Class.forName("android.net.ProxyProperties")};
            Method updateProxyInstance = jwcjb.getDeclaredMethod("updateProxy", params);
            updateProxyInstance.invoke(sJavaBridge, ppcont.newInstance(host, port, null));
        }
        catch (Exception ex) {
            PLog.i("Setting proxy with >= 4.1 API failed with error: " + ex.getMessage(), new Object[0]);
            return false;
        }
        PLog.v("Setting proxy with 4.1 - 4.3 API successful!", new Object[0]);
        return true;
    }

    @TargetApi(value=19)
    private static boolean setProxyKKPlus(WebView webView, String host, int port, String applicationClassName) {
        PLog.v("Setting proxy with >= 4.4 API.", new Object[0]);
        Context appContext = webView.getContext().getApplicationContext();
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port + "");
        System.setProperty("https.proxyHost", host);
        System.setProperty("https.proxyPort", port + "");
        try {
            Class<?> applictionCls = Class.forName(applicationClassName);
            Field loadedApkField = applictionCls.getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(appContext);
            Class<?> loadedApkCls = Class.forName("android.app.LoadedApk");
            Field receiversField = loadedApkCls.getDeclaredField("mReceivers");
            receiversField.setAccessible(true);
            ArrayMap receivers = (ArrayMap)receiversField.get(loadedApk);
            for (Object receiverMap : receivers.values()) {
                for (Object rec : ((ArrayMap)receiverMap).keySet()) {
                    Class<?> clazz = rec.getClass();
                    if (!clazz.getName().contains("ProxyChangeListener")) continue;
                    Method onReceiveMethod = clazz.getDeclaredMethod("onReceive", Context.class, Intent.class);
                    Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
                    onReceiveMethod.invoke(rec, appContext, intent);
                }
            }
            PLog.v("Setting proxy with >= 4.4 API successful!", new Object[0]);
            return true;
        }
        catch (Exception ex) {
            PLog.i(ex);
            return false;
        }
    }

    private static Object getFieldValueSafely(Field field, Object classInstance) throws IllegalArgumentException, IllegalAccessException {
        boolean oldAccessibleValue = field.isAccessible();
        field.setAccessible(true);
        Object result = field.get(classInstance);
        field.setAccessible(oldAccessibleValue);
        return result;
    }
}

