/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import java.lang.reflect.Method;

public class SPViewUtil {
    private static float density = 0.0f;

    public static float dp2px(Context context, float dp) {
        if (0.0f == density) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return dp * density;
    }

    public static float px2dp(Context context, float px) {
        if (0.0f == density) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return px / density;
    }

    public static Point screenSize(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return SPViewUtil.screenSizeJB(context);
        }
        Point size = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                size.x = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                size.y = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
            }
            catch (Exception ex) {
                size.x = display.getWidth();
                size.y = display.getHeight();
            }
        } else {
            display.getSize(size);
        }
        return size;
    }

    @TargetApi(value=17)
    private static Point screenSizeJB(Context context) {
        Point size = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics realMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getRealMetrics(realMetrics);
        size.x = realMetrics.widthPixels;
        size.y = realMetrics.heightPixels;
        return size;
    }

    public static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static int getStatusBarHeight(Context context) {
        int height = 0;
        try {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                height = context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        catch (Exception ex) {
            height = (int)SPViewUtil.dp2px(context, 25.0f);
        }
        return height;
    }

    public static AlertDialog msgBox(Context context, CharSequence title, CharSequence msg) {
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            return null;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title).setMessage(msg).setCancelable(true);
        builder.setNegativeButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dlg = builder.show();
        dlg.setCanceledOnTouchOutside(true);
        return dlg;
    }

    public static void setBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(background);
        } else {
            SPViewUtil.setBackgroundNew(view, background);
        }
    }

    @TargetApi(value=16)
    public static void setBackgroundNew(View view, Drawable background) {
        view.setBackground(background);
    }

    public static boolean setText(View view, String text) {
        try {
            Class<?> cls = view.getClass();
            Method method = cls.getMethod("setText", CharSequence.class);
            if (null != method) {
                method.invoke((Object)view, text);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void disableAutoKB(Context context, View view) {
        if (null != context && null != view) {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.showSoftInput(view, 1);
        }
    }

    public static void setTextReadonly(TextView view, boolean b) {
        view.setClickable(!b);
        view.setCursorVisible(!b);
        view.setFocusable(!b);
        view.setFocusableInTouchMode(!b);
    }

    public static Activity getActivity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (Build.VERSION.SDK_INT >= 23 && (context = view.findViewById(0x1020002).getContext()) instanceof Activity) {
            return (Activity)context;
        }
        return null;
    }
}

