/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.security.auth.x500.X500Principal;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPSystemUtil {
    public static boolean isRunInMainThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static void sleepEx(long millis) {
        SystemClock.sleep((long)millis);
    }

    public static void sleepEx(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopAndWaitThread(Thread thread, long millis) {
        try {
            thread.interrupt();
            thread.join(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getProperty(String name) {
        String line = "";
        Process ifc = null;
        try {
            ifc = Runtime.getRuntime().exec("getprop " + name);
            BufferedReader bis = new BufferedReader(new InputStreamReader(ifc.getInputStream()));
            line = bis.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != ifc) {
            ifc.destroy();
        }
        return line;
    }

    public static boolean hasPermission(Context context, String permission2) {
        int res = context.checkCallingOrSelfPermission(permission2);
        return res == 0;
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        boolean hasAllPermissions = true;
        for (String permission2 : permissions) {
            if (SPSystemUtil.hasPermission(context, permission2)) continue;
            hasAllPermissions = false;
        }
        return hasAllPermissions;
    }

    public static boolean isApplicationBroughtToBackground(Context context) {
        ComponentName topActivity;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        return !tasks.isEmpty() && !(topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity).getPackageName().equals(SPApplication.getPkgName(context));
    }

    public static String getProcessName(Context context) {
        String currentProcName = "";
        try {
            int pid = android.os.Process.myPid();
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != pid) continue;
                currentProcName = processInfo.processName;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentProcName;
    }

    public static String getNativeLibraryDir(Context context) {
        try {
            int sdk_level = Build.VERSION.SDK_INT;
            if (sdk_level >= 9) {
                return context.getApplicationInfo().nativeLibraryDir;
            }
            if (sdk_level >= 4) {
                return context.getApplicationInfo().dataDir + "/lib";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "/data/data/" + context.getPackageName() + "/lib";
    }

    public static void killProcess(Context context, int pid, String pkgName) {
        if (pid > 0) {
            try {
                android.os.Process.killProcess((int)pid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Runtime.getRuntime().exec("su adb shell kill -9 " + pid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            try {
                ActivityManager manager = (ActivityManager)context.getSystemService("activity");
                manager.killBackgroundProcesses(pkgName);
            }
            catch (Throwable manager) {
                // empty catch block
            }
            try {
                Runtime.getRuntime().exec("su adb shell killall " + pkgName);
            }
            catch (Throwable manager) {
                // empty catch block
            }
            try {
                Process suProcess = Runtime.getRuntime().exec("su");
                DataOutputStream os = new DataOutputStream(suProcess.getOutputStream());
                os.writeBytes("adb shell\n");
                os.flush();
                os.writeBytes("am force-stop " + pkgName + "\n");
                os.flush();
                os.close();
                suProcess.waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static long getAppPackTime(Context context) {
        long time = 0L;
        try {
            PackageManager pkgmgr = context.getPackageManager();
            ApplicationInfo appi = pkgmgr.getApplicationInfo(SPApplication.getPkgName(context), 0);
            time = SPSystemUtil.getAppPackTimeOfApkFile(appi.sourceDir);
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return time;
    }

    public static long getAppPackTimeOfApkFile(String apkfile) {
        long time = 0L;
        try {
            ZipFile zfile = new ZipFile(apkfile);
            time = zfile.getEntry("classes.dex").getTime();
            time -= time % 1000L;
            zfile.close();
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return time;
    }

    public static JSONArray getActiveAdmins(Context context) {
        JSONArray admins = new JSONArray();
        try {
            List<String> pkgnames = SPSystemUtil.getActiveAdminPkgnames(context);
            for (String pkgname : pkgnames) {
                JSONObject admin = new JSONObject();
                SPJSONUtil.put(admin, "pkgname", pkgname);
                String signature = SPSystemUtil.getSignature(context, pkgname);
                SPJSONUtil.put(admin, "sign_hash", SPStringUtil.md5(signature));
                admins.put((Object)admin);
            }
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return admins;
    }

    public static List<String> getActiveAdminPkgnames(Context context) {
        ArrayList<String> pkgnames = new ArrayList<String>();
        try {
            DevicePolicyManager dpm = (DevicePolicyManager)context.getSystemService("device_policy");
            List cnames = dpm.getActiveAdmins();
            if (null != cnames) {
                for (ComponentName cname : cnames) {
                    pkgnames.add(cname.getPackageName());
                }
            }
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return pkgnames;
    }

    public static String getSignature(Context context, String pkgname) {
        String signature = null;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(pkgname, 64);
            StringBuilder sb = new StringBuilder();
            for (Signature sig : pi.signatures) {
                sb.append(sig.toCharsString());
            }
            signature = sb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return signature;
    }

    public static boolean isLegendsecSignature(Context context) {
        String legendsecSig = "308203833082026ba003020102020437b4c4ba300d06092a864886f70d01010b05003072310c300a06035504061303303836310e300c060355040813056368696e613110300e060355040713076368656e67647531123010060355040a13096c6567656e6473656331163014060355040b130d6c6567656e64736563206e6574311430120603550403130b66796e6167206368656e67301e170d3134303630363038343033365a170d3234303630333038343033365a3072310c300a06035504061303303836310e300c060355040813056368696e613110300e060355040713076368656e67647531123010060355040a13096c6567656e6473656331163014060355040b130d6c6567656e64736563206e6574311430120603550403130b66796e6167206368656e6730820122300d06092a864886f70d01010105000382010f003082010a02820101008425b63df87ea2ea6948c3f16c4bd8b19ac3ead1195e6784e1fdc3814a4cba1b2108c5ecb15b556259ef4f02c0130c04a65eb66b12ab6f614882aad2c2635e7b9ce65d25aacde2497f1b4ef0ba725297720f2ac1a68cf1af4dd336fc69aa2c675e68e30fee1c0aff77bd8e69c47be41d6d43ea05372536cbd1d6f600c36b5839e3d4ac68d23fe8a995fb566ecf5a6e02418d3ae9c210f4c884f87e66301f305bb38a76d650ca8382056d39af1744bced46cbca3fc6c171f2bea3ad272e382831be2db3fd287d2a9ced56e2971642d4365a8a45de2ef3a860fbce8ed03a77bfbe3c2dbad266ec03d1fe00c180e1a060cd2580588125a8559ba45a75fc5d01557f0203010001a321301f301d0603551d0e04160414964e5cd8f76413f4a9e4648a14bd831e1df9819d300d06092a864886f70d01010b050003820101006cf8263135cd4bc15d9a2c804d7b3af0cb00addf51450ee979f25d79cee75b806cde5642d9da73543fbbdfbb13ab92bd4e10a1724c5539098a16c1ff92836ced103b7de3946703b2b8c7c5341f0d3bf4c3aea45337f312035b716bc4c5fedb59facc9e57d2704bbac13de0a0d132c4cf73ee8cc8bb783eb1d903c3a09759683947d3b5fd1715e56d3fe6c001856b53e5e246f7546020edd4a3b4ee983251d35d55ad0c374c5a8c5099af53262c4e5a5d4e9199515c3c552e800e55227fe72c220978dedb236978daa910a2b83237a4073d81b2adb1c5742cfb1b9710b8f24ee77e291d0ca977e8522f689dbadc54f3c90c218597e66f5377c15f0cf77eafe8b4";
        return legendsecSig.equalsIgnoreCase(SPSystemUtil.getSignature(context, context.getPackageName()));
    }

    public static boolean isDebugSignature(Context context) {
        boolean debuggable = false;
        try {
            Signature sig;
            ByteArrayInputStream stream;
            X509Certificate cert;
            PackageInfo pinfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X500Principal debugDN = new X500Principal("CN=Android Debug,O=Android,C=US");
            Signature[] signatureArray = pinfo.signatures;
            int n = signatureArray.length;
            for (int i = 0; i < n && !(debuggable = (cert = (X509Certificate)cf.generateCertificate(stream = new ByteArrayInputStream((sig = signatureArray[i]).toByteArray()))).getSubjectX500Principal().equals(debugDN)); ++i) {
            }
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return debuggable;
    }

    public static void getInstalledApps(Context context) {
        PackageManager pm = context.getPackageManager();
        List appInfos = pm.getInstalledApplications(128);
        for (ApplicationInfo applicationInfo : appInfos) {
        }
    }
}

