/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class SPStringUtil {
    public static final SimpleDateFormat FMT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat FMT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final byte[] BOM_UTF8 = new byte[]{-17, -65, -67};

    public static String opt(String str) {
        return TextUtils.isEmpty((CharSequence)str) ? "" : str.trim();
    }

    public static String replaceAll(String subject, String search, String replace) {
        while (subject.indexOf(search) != -1) {
            subject = subject.replace(search, replace);
        }
        return subject;
    }

    public static boolean equals(String s1, String s2) {
        return null == s1 ? null == s2 : null != s2 && s1.equals(s2);
    }

    public static boolean wildcardMatches(String str, String pat) {
        if (TextUtils.isEmpty((CharSequence)str) || TextUtils.isEmpty((CharSequence)pat)) {
            return false;
        }
        int i = 0;
        int j = 0;
        int starIndex = -1;
        int iIndex = -1;
        while (i < str.length()) {
            if (j < pat.length() && (pat.charAt(j) == '?' || pat.charAt(j) == str.charAt(i))) {
                ++i;
                ++j;
                continue;
            }
            if (j < pat.length() && pat.charAt(j) == '*') {
                starIndex = j++;
                iIndex = i;
                continue;
            }
            if (starIndex != -1) {
                j = starIndex + 1;
                i = iIndex + 1;
                ++iIndex;
                continue;
            }
            return false;
        }
        while (j < pat.length() && pat.charAt(j) == '*') {
            ++j;
        }
        return j == pat.length();
    }

    public static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static long parseLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static int propOptInt(Properties props, String key, int defaultValue) {
        try {
            return Integer.parseInt(props.get(key).toString());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static byte[] ticketToBytes(String str) {
        byte[] ticket = new byte[32];
        for (int i = 0; i < ticket.length; ++i) {
            try {
                int ii = i * 2;
                String s = str.substring(ii, ii + 2);
                Integer b = Integer.parseInt(s, 16) & 0xFF;
                ticket[i] = b.byteValue();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ticket;
    }

    public static String md5(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(str.getBytes());
                return SPStringUtil.byte2Hex(md.digest()).toLowerCase(Locale.ENGLISH);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String md5(byte[] bytes) {
        if (null != bytes && bytes.length > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(bytes);
                return SPStringUtil.byte2Hex(md.digest()).toLowerCase(Locale.ENGLISH);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String byte2Hex(byte[] bytes, String splitter) {
        StringBuilder sb = new StringBuilder();
        splitter = TextUtils.isEmpty((CharSequence)splitter) ? "" : splitter;
        String stmp = "";
        for (int n = 0; n < bytes.length; ++n) {
            if (n > 0) {
                sb.append(splitter);
            }
            if ((stmp = Integer.toHexString(bytes[n] & 0xFF)).length() == 1) {
                sb.append("0");
            }
            sb.append(stmp);
        }
        return sb.toString();
    }

    public static String byte2Hex(byte[] bytes) {
        return SPStringUtil.byte2Hex(bytes, "");
    }

    public static String urlEncode(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (Exception exception) {
            return path;
        }
    }

    public static String decodeHexMixed(String hexMixed) {
        if (hexMixed.indexOf("\\x") != -1) {
            byte slash = "\\".getBytes()[0];
            String[] strArr = hexMixed.split("\\\\");
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            for (int i = 0; i < strArr.length; ++i) {
                try {
                    if (strArr[i].charAt(0) == 'x') {
                        String hex = "0" + strArr[i].substring(0, Math.min(3, strArr[i].length()));
                        bo.write(Integer.decode(hex).byteValue());
                        if (strArr.length <= 3) continue;
                        bo.write(strArr[i].substring(3).getBytes());
                        continue;
                    }
                    if (i > 0) {
                        bo.write(slash);
                    }
                    bo.write(strArr[i].getBytes());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            hexMixed = new String(bo.toByteArray());
        }
        return hexMixed;
    }

    public static String ellipsize(String text, int max) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        if (text.length() <= max) {
            return text;
        }
        return text.substring(0, max - 3) + "...";
    }

    public static boolean isUTF8(byte[] pText) {
        int i;
        if (null == pText || pText.length < 1) {
            return false;
        }
        boolean isAscii = true;
        for (i = 0; i < pText.length && isAscii; ++i) {
            isAscii = (pText[i] & 0x80) == 0;
        }
        if (isAscii) {
            return false;
        }
        int expectedLength = 0;
        for (i = 0; i < pText.length; ++i) {
            if ((pText[i] & 0x80) == 0) {
                expectedLength = 1;
            } else if ((pText[i] & 0xE0) == 192) {
                expectedLength = 2;
            } else if ((pText[i] & 0xF0) == 224) {
                expectedLength = 3;
            } else if ((pText[i] & 0xF8) == 240) {
                expectedLength = 4;
            } else if ((pText[i] & 0xFC) == 248) {
                expectedLength = 5;
            } else if ((pText[i] & 0xFE) == 252) {
                expectedLength = 6;
            } else {
                return false;
            }
            while (--expectedLength > 0) {
                if (++i >= pText.length) {
                    return false;
                }
                if ((pText[i] & 0xC0) == 128) continue;
                return false;
            }
        }
        return true;
    }

    public static byte[] removeBOM(byte[] bytes, byte[] bom) {
        if (null == bom) {
            bom = BOM_UTF8;
        }
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            if (i < bytes.length - bom.length && SPStringUtil.arrayEquals(bytes, i, bom, 0, bom.length)) {
                i += bom.length - 1;
                continue;
            }
            bb.put(bytes[i]);
        }
        byte[] b = new byte[bb.position()];
        bb.rewind();
        bb.get(b);
        return b;
    }

    public static boolean arrayEquals(byte[] bytes1, int offset1, byte[] bytes2, int offset2, int n) {
        for (int i = 0; i < n; ++i) {
            if (bytes1[offset1 + i] == bytes2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CharSequence charSequence : elements) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(charSequence);
        }
        return sb.toString();
    }

    public static String formatMills(long mills, boolean dateOnly) {
        Date tm = new Date(mills);
        return dateOnly ? FMT_DATE.format(tm) : FMT_DATETIME.format(tm);
    }

    public static String rdpEncryptPassword(String plainText) {
        return "";
    }

    public static String sha256Encrypt(String plainText) {
        byte[] bt = plainText.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bt);
            byte[] digest = md.digest();
            return SPStringUtil.byte2Hex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static String gestureEncrypt(String plainText) {
        String sha256Pass = SPStringUtil.sha256Encrypt(plainText);
        if (sha256Pass.length() == 64) {
            return SPStringUtil.md5(sha256Pass.substring(0, 29));
        }
        return "";
    }
}

