/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.app.admin.DeviceAdminReceiver;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.NetworkOnMainThreadException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.entry.SPNetworkInfo;
import com.secure.comm.utils.SPSystemUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SPNetUtil {
    private static final String EMPTY_MAC_ADDRESS1 = "00-00-00-00-00-00";
    private static final String EMPTY_MAC_ADDRESS2 = "02-00-00-00-00-00";
    private static Field f_ipaddress = null;
    private static Field f_hostName = null;
    private static AtomicBoolean isAvailable = new AtomicBoolean(true);

    public static boolean isEmptyWifiMAC(String wifimac) {
        return TextUtils.isEmpty((CharSequence)wifimac) || EMPTY_MAC_ADDRESS1.equals(wifimac) || EMPTY_MAC_ADDRESS2.equals(wifimac);
    }

    public static void networkOnMainThreadException() {
        if (SPSystemUtil.isRunInMainThread()) {
            throw new NetworkOnMainThreadException();
        }
    }

    public static int getURLPort(URL url) {
        return url.getPort() > 0 ? url.getPort() : (url.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
    }

    public static boolean isNetworkAvailable(Context context) {
        block4: {
            if (null != context) {
                try {
                    ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkInfo[] nis = connMgr.getAllNetworkInfo();
                    if (null == nis) break block4;
                    for (int i = 0; i < nis.length; ++i) {
                        if (!nis[i].isConnected()) continue;
                        isAvailable.set(true);
                        break;
                    }
                }
                catch (Exception ex) {
                    isAvailable.set(true);
                }
            }
        }
        return isAvailable.get();
    }

    public static boolean isWifiAvailable(Context context) {
        try {
            ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = connMgr.getActiveNetworkInfo();
            if (null != info && info.isConnected()) {
                return info.getType() == 1 && info.getType() == 6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getWifiMac(Context context) {
        WifiManager wifiManager = null;
        boolean wifiDisabled = false;
        String macaddr = null;
        if (null != context) {
            try {
                wifiManager = (WifiManager)context.getSystemService("wifi");
                if (!wifiManager.isWifiEnabled()) {
                    wifiDisabled = true;
                }
                macaddr = wifiManager.getConnectionInfo().getMacAddress();
                macaddr = macaddr.replace(':', '-').toUpperCase(Locale.ENGLISH);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (SPNetUtil.isEmptyWifiMAC(macaddr) && null != context) {
            try {
                ComponentName name1;
                DeviceAdminReceiver admin;
                DevicePolicyManager devicepolicymanager;
                Method method = DevicePolicyManager.class.getMethod("getWifiMacAddress", ComponentName.class);
                if (null != method && (devicepolicymanager = (admin = new DeviceAdminReceiver()).getManager(context)).isAdminActive(name1 = admin.getWho(context))) {
                    macaddr = (String)method.invoke((Object)devicepolicymanager, name1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (SPNetUtil.isEmptyWifiMAC(macaddr)) {
            macaddr = SPNetUtil.getMacAddrEx();
        }
        if (null == wifiManager || wifiDisabled) {
            // empty if block
        }
        return SPNetUtil.isEmptyWifiMAC(macaddr) ? EMPTY_MAC_ADDRESS1 : macaddr;
    }

    private static String getMacAddrEx() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X-", b & 0xFF));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString().replace(':', '-').toUpperCase(Locale.ENGLISH);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EMPTY_MAC_ADDRESS1;
    }

    public static boolean isPhoneNum(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            return SPNetUtil.isMobile((str = str.replaceAll("[^0-9]", "")).replaceAll("[\\-]", "")) || SPNetUtil.isPhone(str);
        }
        return false;
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isPhone(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }

    public static InetAddress buildInet4Address(String hostname, String ip) {
        try {
            String[] strs = ip.split("\\.");
            byte[] bytes = new byte[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                bytes[i] = (byte)Integer.parseInt(strs[i]);
            }
            return InetAddress.getByAddress(hostname, bytes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int htonl(int value) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? value : Integer.reverseBytes(value);
    }

    public static int ntohl(int value) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? value : Integer.reverse(value);
    }

    public static String getPhoneInfo(Context context) {
        StringBuilder sb = new StringBuilder();
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            sb.append("\nDeviceId(IMEI) = " + tm.getDeviceId());
            sb.append("\nDeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion());
            sb.append("\nLine1Number = " + tm.getLine1Number());
            sb.append("\nNetworkCountryIso = " + tm.getNetworkCountryIso());
            sb.append("\nNetworkOperator = " + tm.getNetworkOperator());
            sb.append("\nNetworkOperatorName = " + tm.getNetworkOperatorName());
            sb.append("\nNetworkType = " + tm.getNetworkType());
            sb.append("\nPhoneType = " + tm.getPhoneType());
            sb.append("\nSimCountryIso = " + tm.getSimCountryIso());
            sb.append("\nSimOperator = " + tm.getSimOperator());
            sb.append("\nSimOperatorName = " + tm.getSimOperatorName());
            sb.append("\nSimSerialNumber = " + tm.getSimSerialNumber());
            sb.append("\nSimState = " + tm.getSimState());
            sb.append("\nSubscriberId(IMSI) = " + tm.getSubscriberId());
            sb.append("\nVoiceMailNumber = " + tm.getVoiceMailNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static int getActiveNetInfo(Context context) {
        int netinfo = 0;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo[] nis = cm.getAllNetworkInfo();
            if (null != nis) {
                for (int i = 0; i < nis.length; ++i) {
                    if (nis[i].getState() != NetworkInfo.State.CONNECTED && nis[i].getState() != NetworkInfo.State.CONNECTING) continue;
                    if (nis[i].getType() == 1) {
                        netinfo |= 1;
                        continue;
                    }
                    if (nis[i].getType() == 0) {
                        try {
                            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                            String imsi = tm.getSubscriberId();
                            PLog.v("IMSI=%s", imsi);
                            int carrier = 256;
                            if (null != imsi) {
                                carrier = SPNetworkInfo.parseCarrier(imsi);
                            }
                            if (carrier == 256) {
                                carrier = SPNetworkInfo.parseCarrier(tm.getSimOperator());
                            }
                            netinfo |= carrier;
                        }
                        catch (Exception ex) {
                            PLog.v(ex);
                            netinfo |= 0x100;
                        }
                        continue;
                    }
                    netinfo |= 0x100;
                }
            }
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return netinfo == 0 ? 256 : netinfo;
    }

    static {
        try {
            Class<InetAddress> cls = InetAddress.class;
            f_ipaddress = cls.getDeclaredField("ipaddress");
            f_ipaddress.setAccessible(true);
            f_hostName = cls.getDeclaredField("hostName");
            f_hostName.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

