/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.secure.comm.app.SPApplication;
import com.secure.comm.app.SPOEM;
import com.secure.comm.net.SPHttpClient;
import com.secure.comm.utils.SPIntentUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.comm.view.SPPopupClosedListener;
import com.secure.comm.view.SPPopupMsgBox;
import com.secure.comm.view.SPPopupWaiting;
import com.secure.sportal.entry.SPTunStatus;
import com.secure.sportal.sdk.SPVPNClient;
import com.secure.sportal.secid.uniq.SPUniqueIDUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPLogUtil {
    private static final String TAG = "SPLogUtil";
    private static String[] LOGCAT_CMD = new String[]{"logcat", "-d", "-s", "vpncore:V", "vpnclient:V", "sportal:V", "secm:V", "secmobi:V", "*:F", "*:E", "*:W"};
    private static String title_waiting = "\u8bf7\u7a0d\u540e";
    private static String status = "\u6b63\u5728\u6536\u96c6\u65e5\u5fd7\u4fe1\u606f";
    private static String collect_err = "\u6536\u96c6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25: ";
    private static String uploading_log = "\u6b63\u5728\u4e0a\u4f20\u65e5\u5fd7\u4fe1\u606f";
    private static String upload_err = "\u4e0a\u4f20\u5931\u8d25";
    private static String logserv_err1 = "\u65e5\u5fd7\u670d\u52a1\u5668\u5f02\u5e38(\u9519\u8bef\u7801 ";
    private static String logserv_err2 = "),\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458.";
    private static String tips = "\u63d0\u793a";
    private static String connect_err = "\u65e0\u6cd5\u8fde\u63a5\u65e5\u5fd7\u670d\u52a1\u5668";
    private static String log_err = "\u6536\u96c6\u6216\u4e0a\u4f20\u65e5\u5fd7\u5931\u8d25: ";
    private static String cancel = "\u53d6\u6d88";
    private static String retry = "\u91cd\u8bd5";
    private static String init_log_err = "\u65e5\u5fd7\u6587\u4ef6\u751f\u6210\u5931\u8d25";

    @SuppressLint(value={"TrulyRandom"})
    public static void uploadLog(final Context context, final String log_path, final String svr_host, final int svr_port, final String auth_user, final String ticket) {
        File file;
        if (SPApplication.isLocale_En()) {
            title_waiting = "Waitting";
            status = "Collecting log...";
            collect_err = "Collected log error: ";
            uploading_log = "uploading log info";
            upload_err = "upload error";
            logserv_err1 = "log server error(Error Code ";
            logserv_err2 = "),please contact adminstrator.";
            tips = "Info";
            connect_err = "connect log server error";
            log_err = "collect or upload log error: ";
            cancel = "cancel";
            retry = "retry";
            init_log_err = "megre log file failed";
        }
        if (!(file = new File(log_path)).exists() || file.isDirectory() || file.length() == 0L) {
            Toast.makeText((Context)context.getApplicationContext(), (CharSequence)(init_log_err + ":" + log_path), (int)0).show();
            return;
        }
        Log.d((String)TAG, (String)("uploadLog file path is " + log_path));
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(){

                @Override
                public void run() {
                    SPLogUtil.uploadLog(context, log_path, svr_host, svr_port, auth_user, ticket);
                }
            }.start();
            return;
        }
        final AtomicReference msgbox = new AtomicReference();
        SPIntentUtil.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                msgbox.set(SPPopupWaiting.popup(context, title_waiting, null, null));
                ((SPPopupWaiting)msgbox.get()).setMessage(status);
            }
        }, 0L);
        SPSystemUtil.sleepEx(1000L);
        JSONObject devinfo = SPUniqueIDUtil.getDeviceFP(context);
        SPJSONUtil.put(devinfo, "svr.host", svr_host);
        SPJSONUtil.putStr(devinfo, "svr.port", svr_port);
        SPJSONUtil.put(devinfo, "svr.username", auth_user);
        SPJSONUtil.put(devinfo, "app.oem", SPOEM.oemName());
        SPTunStatus tun = SPVPNClient.getTunnelStatus();
        if (!TextUtils.isEmpty((CharSequence)tun.vpn_host)) {
            SPJSONUtil.put(devinfo, "vpn.tunnel.status", tun.toJSON());
        }
        JSONArray admins = new JSONArray();
        try {
            List<String> pkgnames = SPSystemUtil.getActiveAdminPkgnames(context);
            for (String pkgname : pkgnames) {
                admins.put((Object)pkgname);
            }
        }
        catch (Exception pkgnames) {
            // empty catch block
        }
        SPJSONUtil.put(devinfo, "dev.admins", admins);
        byte[] meta = null;
        try {
            meta = devinfo.toString(2).getBytes();
        }
        catch (Exception ex) {
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ((SPPopupWaiting)msgbox.get()).close(0);
                    SPPopupMsgBox.popup(context, "", collect_err + ex.getLocalizedMessage());
                }
            }, 0L);
            return;
        }
        ((SPPopupWaiting)msgbox.get()).setMessage(uploading_log);
        Log.v((String)TAG, (String)("Upload log ticket is " + ticket));
        if (!TextUtils.isEmpty((CharSequence)ticket) && !TextUtils.isEmpty((CharSequence)svr_host)) {
            SPLogUtil.upLogToVpn(log_path, svr_host, svr_port, auth_user, ticket);
        } else {
            Log.d((String)TAG, (String)"user is not login, do not upload log to vpn");
        }
        try {
            StringBuilder sburl = new StringBuilder();
            sburl.append("https://log.aag.360.net:8443/upload.php");
            String url = sburl.toString();
            Log.v((String)TAG, (String)("Upload log to " + url));
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(8000);
            conn.setRequestProperty("Connection", "Keep-Alive");
            if (url.startsWith("https")) {
                HttpsURLConnection sconn = (HttpsURLConnection)conn;
                TrustManager[] trustAllCerts = new TrustManager[]{new SPHttpClient.SPX509TrustManager()};
                String protocol = Build.VERSION.SDK_INT < 9 ? "TLS" : "SSL";
                SSLContext sc = SSLContext.getInstance(protocol);
                sc.init(null, trustAllCerts, new SecureRandom());
                sconn.setSSLSocketFactory(sc.getSocketFactory());
                sconn.setHostnameVerifier(new SPHttpClient.SPHostnameVerifier());
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date(System.currentTimeMillis());
            String log_filename = "";
            log_filename = !TextUtils.isEmpty((CharSequence)svr_host) ? (!TextUtils.isEmpty((CharSequence)auth_user) ? "vpn-android-" + svr_host + "-" + auth_user + "-" + simpleDateFormat.format(date) + ".txt" : "vpn-android-" + svr_host + "-" + simpleDateFormat.format(date) + ".txt") : (!TextUtils.isEmpty((CharSequence)auth_user) ? "vpn-android-" + auth_user + "-" + simpleDateFormat.format(date) + ".txt" : "vpn-android-" + simpleDateFormat.format(date) + ".txt");
            conn.connect();
            conn.getOutputStream().write(SPLogUtil.uploadLogHeader(log_filename, ticket).getBytes());
            conn.getOutputStream().flush();
            SPLogUtil.writeLog(log_path, conn.getOutputStream());
            conn.getOutputStream().write(SPLogUtil.uploadLogTail().getBytes());
            conn.getOutputStream().close();
            byte[] buffer = new byte[10240];
            final int rspcode = conn.getResponseCode();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Log.v((String)TAG, (String)("Upload " + url + " log response code=" + rspcode));
            if (200 == rspcode) {
                int cur;
                int contentLength = conn.getContentLength();
                InputStream hin = conn.getInputStream();
                for (int recv = 0; (recv < contentLength || contentLength < 1) && (cur = hin.read(buffer)) > 0; recv += cur) {
                    baos.write(buffer, 0, cur);
                }
            } else {
                SPIntentUtil.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        ((SPPopupWaiting)msgbox.get()).close(0);
                        SPPopupMsgBox.popup(context, upload_err, logserv_err1 + rspcode + logserv_err2);
                    }
                }, 0L);
                return;
            }
            conn.getInputStream().close();
            conn.disconnect();
            JSONObject rsp = SPJSONUtil.parseObject(baos.toString());
            Log.v((String)TAG, (String)rsp.toString());
            final StringBuilder msgtitle = new StringBuilder();
            final StringBuilder msgtxt = new StringBuilder();
            String msg = rsp.optString("msg");
            msgtitle.append(tips);
            msgtxt.append("<big>").append(msg).append("</big>");
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ((SPPopupWaiting)msgbox.get()).close(0);
                    SPPopupMsgBox.popup(context, msgtitle.toString(), msgtxt.toString());
                }
            }, 0L);
        }
        catch (Exception ex) {
            final String errmsg = ex instanceof IOException ? connect_err : ex.getLocalizedMessage();
            SPIntentUtil.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ((SPPopupWaiting)msgbox.get()).close(0);
                    SPPopupMsgBox.msgbox(context, tips, log_err + errmsg, new SPPopupClosedListener(){

                        @Override
                        public void onDismissNegative(DialogInterface dialog) {
                            super.onDismissPositive(dialog);
                            SPLogUtil.uploadLog(context, log_path, svr_host, svr_port, auth_user, ticket);
                        }
                    }, cancel, retry, null);
                }
            }, 0L);
        }
    }

    private static void upLogToVpn(String log_path, String svr_host, int svr_port, String username, String ticket) {
        try {
            StringBuilder sburl = new StringBuilder();
            sburl.append("https://" + svr_host + ":" + svr_port + "/rest/log/");
            String url = sburl.toString();
            Log.v((String)TAG, (String)("Upload log to " + url));
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(8000);
            conn.setRequestProperty("Connection", "Keep-Alive");
            if (url.startsWith("https")) {
                HttpsURLConnection sconn = (HttpsURLConnection)conn;
                TrustManager[] trustAllCerts = new TrustManager[]{new SPHttpClient.SPX509TrustManager()};
                String protocol = Build.VERSION.SDK_INT < 9 ? "TLS" : "SSL";
                SSLContext sc = SSLContext.getInstance(protocol);
                sc.init(null, trustAllCerts, new SecureRandom());
                sconn.setSSLSocketFactory(sc.getSocketFactory());
                sconn.setHostnameVerifier(new SPHttpClient.SPHostnameVerifier());
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date(System.currentTimeMillis());
            String log_filename = "";
            log_filename = !TextUtils.isEmpty((CharSequence)svr_host) ? (!TextUtils.isEmpty((CharSequence)username) ? "vpn-android-" + svr_host + "-" + username + "-" + simpleDateFormat.format(date) + ".txt" : "vpn-android-" + svr_host + "-" + simpleDateFormat.format(date) + ".txt") : (!TextUtils.isEmpty((CharSequence)username) ? "vpn-android-" + username + "-" + simpleDateFormat.format(date) + ".txt" : "vpn-android-" + simpleDateFormat.format(date) + ".txt");
            conn.connect();
            conn.getOutputStream().write(SPLogUtil.uploadLogHeader(log_filename, ticket).getBytes());
            conn.getOutputStream().flush();
            SPLogUtil.writeLog(log_path, conn.getOutputStream());
            conn.getOutputStream().write(SPLogUtil.uploadLogTail().getBytes());
            conn.getOutputStream().close();
            int rspcode = conn.getResponseCode();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Log.v((String)TAG, (String)("Upload " + url + " log response code=" + rspcode));
            byte[] buffer = new byte[10240];
            if (200 == rspcode) {
                int cur;
                int contentLength = conn.getContentLength();
                InputStream hin = conn.getInputStream();
                for (int recv = 0; (recv < contentLength || contentLength < 1) && (cur = hin.read(buffer)) > 0; recv += cur) {
                    baos.write(buffer, 0, cur);
                }
            } else {
                Log.v((String)TAG, (String)"Upload log to vpn error.");
                return;
            }
            conn.getInputStream().close();
            conn.disconnect();
            JSONObject rsp = SPJSONUtil.parseObject(baos.toString());
            Log.v((String)TAG, (String)("upload log to vpn response: " + rsp.toString()));
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)"Upload log to vpn Exception error");
        }
    }

    private static String uploadLogHeader(String log_filename, String ticket) {
        String crlf = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        StringBuilder content = new StringBuilder();
        content.append(twoHyphens + boundary + crlf);
        content.append("Content-Disposition: form-data; name=\"method\"" + crlf);
        content.append(crlf);
        content.append("upload-clientlog");
        content.append(crlf);
        content.append(twoHyphens + boundary + crlf);
        content.append("Content-Disposition: form-data; name=\"token\"" + crlf);
        content.append(crlf);
        content.append(ticket);
        content.append(crlf);
        content.append(twoHyphens + boundary + crlf);
        content.append("Content-Disposition: form-data; name=\"file\";filename=\"" + log_filename + "\"" + crlf);
        content.append("Content-Type: text/plain" + crlf);
        content.append(crlf);
        return content.toString();
    }

    private static String uploadLogTail() {
        String crlf = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        StringBuilder content = new StringBuilder();
        content.append(crlf);
        content.append(twoHyphens + boundary + twoHyphens + crlf);
        return content.toString();
    }

    private static void writeLog(String log_path, OutputStream out) throws IOException {
        Log.v((String)TAG, (String)("upload file " + log_path));
        FileInputStream fin = new FileInputStream(log_path);
        byte[] buffer = new byte[10240];
        int len = 0;
        while (-1 != (len = ((InputStream)fin).read(buffer))) {
            out.write(buffer, 0, len);
            out.flush();
        }
        ((InputStream)fin).close();
    }

    public static String toGBK(String str) {
        String result = null;
        try {
            result = new String(str.getBytes(), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] toUtf8(byte[] str) {
        String result = null;
        try {
            result = new String(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result.getBytes();
    }
}

