/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.text.TextUtils;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public final class SPJSONUtil {
    public static JSONObject mapToObject(Map<String, String> map) {
        JSONObject json = new JSONObject();
        for (String key : map.keySet()) {
            SPJSONUtil.put(json, key, map.get(key));
        }
        return json;
    }

    public static JSONObject propertiesToObject(Properties properties) {
        JSONObject json = new JSONObject();
        if (null != properties) {
            for (Object key : properties.keySet()) {
                try {
                    SPJSONUtil.put(json, key.toString(), properties.get(key).toString());
                }
                catch (Exception exception) {}
            }
        }
        return json;
    }

    public static JSONObject parseObject(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                return new JSONObject(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new JSONObject();
    }

    public static JSONArray parseArray(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                return new JSONArray(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new JSONArray();
    }

    public static void put(JSONObject json, String name, Object value) {
        try {
            if (null != value) {
                if (value instanceof Integer) {
                    json.put(name, ((Integer)value).intValue());
                } else if (value instanceof Long) {
                    json.put(name, ((Long)value).longValue());
                } else if (value instanceof Number) {
                    json.put(name, ((Number)value).intValue());
                } else if (value instanceof Boolean) {
                    json.put(name, ((Boolean)value).booleanValue());
                } else {
                    json.put(name, value);
                }
            } else {
                json.put(name, (Object)"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void put(JSONObject json, String name, int value) {
        try {
            json.put(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putStr(JSONObject json, String name, int value) {
        try {
            json.put(name, (Object)String.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putProperties(JSONObject json, Properties properties) {
        if (null != properties) {
            for (Object key : properties.keySet()) {
                SPJSONUtil.put(json, key.toString(), properties.getProperty(key.toString()));
            }
        }
    }

    public static int optInt(JSONObject json, String name, int fallback, int min, int max) {
        int v = json.optInt(name, fallback);
        return v == fallback ? v : Math.max(min, Math.min(v, max));
    }

    public static String toString(JSONObject json) {
        try {
            return json.toString(4);
        }
        catch (Exception ex) {
            return json.toString();
        }
    }

    public static String toString(JSONArray json) {
        try {
            return json.toString(4);
        }
        catch (Exception ex) {
            return json.toString();
        }
    }
}

