/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.widget.Toast;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPSystemUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class SPIntentUtil {
    private static AtomicReference<Handler> mMainHandler = new AtomicReference<Object>(null);

    public static synchronized void runOnMainThread(Runnable r, long delayMillis) {
        if (null != r) {
            if (null == mMainHandler.get()) {
                mMainHandler.set(new Handler(Looper.getMainLooper()));
            }
            mMainHandler.get().postDelayed(r, delayMillis > 0L ? delayMillis : 0L);
        }
    }

    public static synchronized void removeMainCallbacks(Runnable r) {
        if (null != mMainHandler.get() && null != r) {
            mMainHandler.get().removeCallbacks(r);
        }
    }

    public static void runOnNoneMainThread(Runnable r) {
        if (SPSystemUtil.isRunInMainThread()) {
            new Thread(r).run();
        } else {
            r.run();
        }
    }

    public static void gotoHome(Context context) {
        if (context instanceof Activity) {
            ((Activity)context).moveTaskToBack(true);
        } else {
            Intent startMain = new Intent("android.intent.action.MAIN");
            startMain.addCategory("android.intent.category.HOME");
            startMain.setFlags(0x10000000);
            context.getApplicationContext().startActivity(startMain);
        }
    }

    public static boolean isInTianjiSpace(Context context, String packageName) {
        boolean isInTianji = false;
        try {
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                packageName = context.getPackageName();
            }
            Intent intentToResolve = new Intent("android.intent.action.MAIN");
            intentToResolve.addCategory("android.intent.category.360BYOD_LAUNCHER");
            intentToResolve.setPackage(packageName);
            PackageManager pm = context.getApplicationContext().getPackageManager();
            List ris = pm.queryIntentActivities(intentToResolve, 0);
            if (ris != null && ris.size() > 0) {
                isInTianji = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInTianji;
    }

    public static boolean chooseFile(Activity activity, int requestCode, String action) {
        Intent intent = TextUtils.isEmpty((CharSequence)action) ? new Intent("android.intent.action.GET_CONTENT") : new Intent(action);
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        Intent chooserIntent = Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6");
        Intent sIntent = new Intent("com.sec.android.app.myfiles.PICK_DATA");
        sIntent.putExtra("CONTENT_TYPE", "*/*");
        sIntent.addCategory("android.intent.category.DEFAULT");
        if (activity.getPackageManager().resolveActivity(sIntent, 0) != null) {
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])new Intent[]{sIntent});
        }
        try {
            activity.startActivityForResult(chooserIntent, requestCode);
            return true;
        }
        catch (ActivityNotFoundException ex) {
            Toast.makeText((Context)activity, (CharSequence)"\u6ca1\u6709\u5408\u9002\u7684\u6587\u4ef6\u7ba1\u7406\u5668", (int)0).show();
            return false;
        }
    }

    public static Intent createExplicitFromImplicitIntent(Context context, Intent implicitIntent) {
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent, 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return null;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        return explicitIntent;
    }

    public static void uninstall(Context context, String pkgName) {
        try {
            Uri uri = Uri.fromParts((String)"package", (String)pkgName, null);
            Intent intent = new Intent("android.intent.action.DELETE", uri);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registLocalReceiver(Context context, String action, BroadcastReceiver receiver) {
        try {
            LocalBroadcastManager.getInstance((Context)context).registerReceiver(receiver, new IntentFilter(action));
        }
        catch (Throwable ex) {
            PLog.v(ex);
        }
    }

    public static void unregistLocalReceiver(Context context, BroadcastReceiver receiver) {
        try {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver(receiver);
        }
        catch (Throwable ex) {
            PLog.v(ex);
        }
    }

    public static void sendLocalBroadcast(final Context context, final String action, final Bundle extras) {
        SPIntentUtil.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Intent intent = new Intent(action);
                    intent.putExtras(extras);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }
                catch (Throwable ex) {
                    PLog.v(ex);
                }
            }
        }, 0L);
    }

    public static void loadApp(Context context, String pkgname, String clsname, Bundle extras) {
        try {
            PackageManager pm = context.getPackageManager();
            Intent intent = null;
            if (!TextUtils.isEmpty((CharSequence)clsname)) {
                intent = new Intent("android.intent.action.MAIN");
                intent.setComponent(new ComponentName(pkgname, clsname));
            } else {
                intent = pm.getLaunchIntentForPackage(pkgname);
            }
            intent.addFlags(0x10000000);
            if (null != extras) {
                intent.putExtras(extras);
            }
            context.startActivity(intent);
        }
        catch (Exception ex) {
            Toast.makeText((Context)context, (CharSequence)"\u542f\u52a8\u5931\u8d25", (int)0).show();
        }
    }

    public static void openFile(Context context, String filepath) {
        try {
            Uri uri = null;
            if (Build.VERSION.SDK_INT >= 24) {
                uri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileProvider"), (File)new File(filepath));
                Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
                intent.setData(uri);
                intent.setFlags(0x10000001);
                context.startActivity(intent);
            } else {
                uri = Uri.fromFile((File)new File(filepath));
                Intent i = new Intent("android.intent.action.VIEW");
                i.addFlags(0x10000000);
                i.setDataAndType(uri, "application/vnd.android.package-archive");
                context.startActivity(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = ex.getMessage();
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                Toast.makeText((Context)context, (CharSequence)("\u6253\u5f00\u5931\u8d25: " + msg), (int)0).show();
            }
            Toast.makeText((Context)context, (CharSequence)"\u6253\u5f00\u5931\u8d25", (int)0).show();
        }
    }

    public static void requestPermission(Activity activity, String[] permissions, int reqcode) {
        int targetSdkVersion = 0;
        try {
            PackageManager pm = activity.getPackageManager();
            ApplicationInfo appinfo = pm.getApplicationInfo(SPApplication.getPkgName((Context)activity), 0);
            if (appinfo != null) {
                targetSdkVersion = appinfo.targetSdkVersion;
            }
        }
        catch (Exception pm) {
            // empty catch block
        }
        if (targetSdkVersion > 22 && Build.VERSION.SDK_INT > 21) {
            try {
                for (int i = 0; i < permissions.length; ++i) {
                    try {
                        int pcode = ContextCompat.checkSelfPermission((Context)activity, (String)permissions[i]);
                        if (pcode == 0) continue;
                        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)reqcode);
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean startActivity(Object carrier, Intent intent) {
        try {
            Method sar = carrier.getClass().getDeclaredMethod("startActivity", Intent.class);
            if (null != sar) {
                sar.invoke(carrier, intent);
                return true;
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean startActivityForResult(Object carrier, Intent intent, int requestCode) {
        try {
            Method sar = carrier.getClass().getDeclaredMethod("startActivityForResult", Intent.class, Integer.TYPE);
            if (null != sar) {
                sar.invoke(carrier, intent, requestCode);
                return true;
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean startActivityForResult(Object carrier, Intent intent, int requestCode, Bundle options) {
        try {
            Method sar = carrier.getClass().getDeclaredMethod("startActivityForResult", Intent.class, Integer.TYPE, Bundle.class);
            if (null != sar) {
                sar.invoke(carrier, intent, requestCode, options);
                return true;
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

