/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.text.TextUtils;
import com.secure.comm.net.SPIPCIDR;
import com.secure.comm.net.SPIPPool;
import com.secure.comm.net.SPIPRouteItem;
import com.secure.comm.utils.SPStringUtil;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class SPIPUtil {
    public static String nameToIP(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (Exception ex) {
            return hostname;
        }
    }

    public static boolean isIPv4(String host) {
        try {
            String[] segments = host.split("\\.", -1);
            if (segments.length == 4) {
                for (String seg : segments) {
                    int v = Integer.parseInt(seg);
                    if (v >= 0 && v <= 255) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int validateIP(String ipstr) {
        try {
            InetAddress addr = InetAddress.getByName(ipstr);
            if (addr instanceof Inet4Address) {
                return 4;
            }
            if (addr instanceof Inet6Address) {
                return 6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static long bytesToLong(byte[] bytes) {
        long ip = 0L;
        if (null != bytes && bytes.length == 4) {
            ip += (long)bytes[0] << 24;
            ip += (long)bytes[1] << 16;
            ip += (long)bytes[2] << 8;
            ip += (long)bytes[3];
        }
        return ip & 0xFFFFFFFFL;
    }

    public static long ipToLong(String ipAddress) {
        long result = 0L;
        try {
            String[] segments = ipAddress.split("\\.");
            result += Long.parseLong(segments[0]) << 24;
            result += (long)(Integer.parseInt(segments[1]) << 16);
            result += (long)(Integer.parseInt(segments[2]) << 8);
            result += (long)Integer.parseInt(segments[3]);
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result & 0xFFFFFFFFL;
    }

    public static int maskToLen(String mask) {
        long netmask = SPIPUtil.ipToLong(mask);
        netmask += 0x100000000L;
        int lenZeros = 0;
        while ((netmask & 1L) == 0L) {
            ++lenZeros;
            netmask >>= 1;
        }
        if (netmask != 0x1FFFFFFFFL >> lenZeros) {
            return 32;
        }
        return 32 - lenZeros;
    }

    public static String lenToMask(int len) {
        long mask = 0xFFFFFFFFL & (0xFFFFFFFFL >> len ^ 0xFFFFFFFFFFFFFFFFL);
        return SPIPUtil.longToIP(mask);
    }

    public static byte[] ipToBytes(String ip) {
        String[] strs = ip.split("\\.");
        byte[] ipAddress = new byte[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            ipAddress[i] = (byte)Integer.parseInt(strs[i]);
        }
        return ipAddress;
    }

    public static String longToIP(long ip) {
        StringBuilder result = new StringBuilder();
        result.append(ip >> 24 & 0xFFL).append(".").append(ip >> 16 & 0xFFL).append(".");
        result.append(ip >> 8 & 0xFFL).append(".").append(ip & 0xFFL);
        return result.toString();
    }

    public static void ipRangeToCIDR(List<SPIPCIDR> ipCIDRs, long start, long end) {
        int prefixLength = 32;
        long hostCount = 1L;
        long subnet = start;
        long maxCount = end - start + 1L;
        while ((subnet & 1L) == 0L && hostCount * 2L <= maxCount) {
            --prefixLength;
            hostCount *= 2L;
            subnet >>= 1;
        }
        ipCIDRs.add(new SPIPCIDR(start, prefixLength));
        if ((start += hostCount) <= end) {
            SPIPUtil.ipRangeToCIDR(ipCIDRs, start, end);
        }
    }

    public static SPIPRouteItem cidrToRoute(SPIPCIDR cidr) {
        SPIPRouteItem route = new SPIPRouteItem();
        route.network = SPIPUtil.longToIP(cidr.address);
        route.mask = SPIPUtil.lenToMask(cidr.prefix);
        return route;
    }

    public static SPIPPool ipRulesToPool(String rules, String splitter) {
        String[] ruleList;
        SPIPPool pool = new SPIPPool();
        for (String rule : ruleList = rules.split(Pattern.quote(splitter))) {
            if (TextUtils.isEmpty((CharSequence)(rule = rule.trim()))) continue;
            int pos = -1;
            pos = rule.indexOf("/");
            if (pos != -1) {
                pool.pushIPMask(rule.substring(0, pos), rule.substring(pos + 1));
                continue;
            }
            pos = rule.indexOf("-");
            if (pos != -1) {
                pool.pushIPRange(rule.substring(0, pos), rule.substring(pos + 1));
                continue;
            }
            long ip = SPIPUtil.ipToLong(rule);
            if (ip <= 0L || ip >= 0xFFFFFFFFL) continue;
            pool.pushIP(ip);
        }
        return pool;
    }

    public static long getStartAddress(long network, long mask) {
        return network & mask;
    }

    public static long getEndAddress(long network, long mask) {
        return (network & mask | mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    public static String logIPHead(byte[] bytes, int offset) {
        return IPHeader.parse(bytes, offset).toString();
    }

    public static boolean isLoopback(long ip) {
        return ip >= 0x7F000000L && ip <= Integer.MAX_VALUE;
    }

    public static boolean isMulticast(long ip) {
        return ip >= 0xE0000000L && ip <= 0xEFFFFFFFL;
    }

    public static Set<String> getSystemDnsList() {
        HashSet<String> servers = new HashSet<String>();
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            for (String name : new String[]{"net.dns1", "net.dns2", "net.eth0.dns1", "net.eth0.dns2", "net.rmnet0.dns1", "net.rmnet0.dns2", "dhcp.tiwlan0.dns1", "dhcp.tiwlan0.dns2"}) {
                try {
                    String value = SPStringUtil.opt((String)method.invoke(null, name));
                    if (value.length() <= 0 || servers.contains(value)) continue;
                    servers.add(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return servers;
    }

    public static long getDstIP(byte[] packet, int offset) {
        long[] dstip = new long[]{packet[offset + 16] & 0xFF, packet[offset + 17] & 0xFF, packet[offset + 18] & 0xFF, packet[offset + 19] & 0xFF};
        return (dstip[0] << 24) + (dstip[1] << 16) + (dstip[2] << 8) + dstip[3];
    }

    public static void fixIPPacketMSS(byte[] packet, int offset, int count) {
        if (count > 48) {
            ByteBuffer ipbuf = ByteBuffer.wrap(packet, offset, count);
            int version = packet[offset] >> 4 & 0xF;
            int ip_len = (packet[offset] & 0xF) * 4;
            int protocol = packet[offset + 9] & 0xFF;
            int flags = packet[offset + ip_len + 13] & 0xF;
            if (version == 4 && protocol == 6 && (flags & 2) > 0) {
                int msspos = offset + ip_len + 22;
                int chksumpos = offset + ip_len + 16;
                ipbuf.position(offset + msspos);
                short mss = ipbuf.getShort();
                if (mss > 1400) {
                    mss = 1360;
                    ipbuf.position(offset + msspos);
                    ipbuf.putShort(mss);
                    short checksum = 0;
                    ipbuf.position(offset + chksumpos);
                    ipbuf.putShort(checksum);
                    ipbuf.position(offset + 12);
                    checksum = SPIPUtil.checksum(ipbuf, count, ip_len);
                    ipbuf.position(offset + chksumpos);
                    ipbuf.putShort(checksum);
                }
            }
        }
    }

    private static short checksum(ByteBuffer buf, int total, int iplen) {
        int sum = 0;
        while (buf.remaining() > 1) {
            sum += (buf.get() << 8 & 0xFF00) + (buf.get() & 0xFF);
        }
        if (buf.remaining() > 0) {
            sum += buf.get() << 8 & 0xFF00;
        }
        sum += total - iplen + 6;
        while (sum >> 16 > 0) {
            sum = (sum >> 16) + (sum & 0xFFFF);
        }
        return (short)((sum ^= 0xFFFFFFFF) & 0xFFFF);
    }

    public static class IPHeader {
        public int version;
        public int headerLength;
        public int serviceType;
        public int packetLength;
        public int id;
        public int flag;
        public int offset;
        public int ttl;
        public int protocol;
        public int checksum;
        public String src_ip;
        public String dst_ip;
        public int src_port;
        public int dst_port;
        public String protocolName;

        public static IPHeader parse(byte[] bytes, int offset) {
            ByteBuffer packet = ByteBuffer.allocate(24);
            packet.put(bytes, offset, Math.min(bytes.length - offset, 24));
            packet.rewind();
            IPHeader header = new IPHeader();
            byte first = packet.get();
            header.version = first >> 4 & 0xF;
            header.headerLength = first & 0xF;
            header.serviceType = packet.get() & 0xFF;
            header.packetLength = packet.getShort() & 0xFFFF;
            header.id = packet.getShort() & 0xFFFF;
            short flagPosition = packet.getShort();
            header.flag = flagPosition >> 13 & 0xF;
            header.offset = flagPosition & 0x1FFF;
            header.ttl = packet.get() & 0xFF;
            header.protocol = packet.get() & 0xFF;
            header.protocolName = header.protocol == 6 ? "TCP" : (header.protocol == 17 ? "UDP" : String.valueOf(header.protocol));
            header.checksum = packet.getShort() & 0xFFFF;
            header.src_ip = header.ip2Str(packet);
            header.dst_ip = header.ip2Str(packet);
            if (header.protocol == 6 || header.protocol == 17) {
                header.src_port = packet.getShort();
                header.dst_port = packet.getShort();
            }
            return header;
        }

        public void str2IP(ByteBuffer packet, String ip) {
            String[] split = ip.split("\\.");
            for (int i = 0; i < 4; ++i) {
                packet.put(Byte.parseByte(split[i]));
            }
        }

        public String ip2Str(ByteBuffer packet) {
            return String.format(Locale.ENGLISH, "%d.%d.%d.%d", packet.get() & 0xFF, packet.get() & 0xFF, packet.get() & 0xFF, packet.get() & 0xFF);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("IPHeader[").append(this.protocolName).append(" ");
            sb.append(this.src_ip).append("->").append(this.dst_ip).append("]");
            return sb.toString();
        }
    }
}

