/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.os.Build;
import com.secure.PLog;
import com.secure.comm.utils.SPNetUtil;
import com.secure.sportal.entry.IPHost;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SPHostsCache {
    private Object addressCache = null;
    private Method put1 = null;
    private Method put2 = null;
    private Map<String, InetAddress[]> localCache;

    public SPHostsCache() {
        try {
            Class klass;
            this.localCache = new HashMap<String, InetAddress[]>();
            Field faddressCache = null;
            if (Build.VERSION.SDK_INT < 24) {
                klass = InetAddress.class;
                faddressCache = klass.getDeclaredField("addressCache");
            } else {
                klass = Class.forName("java.net.Inet6AddressImpl");
                faddressCache = klass.getDeclaredField("addressCache");
            }
            faddressCache.setAccessible(true);
            this.addressCache = faddressCache.get(null);
            Class<?> cacheKlass = this.addressCache.getClass();
            try {
                this.put1 = cacheKlass.getDeclaredMethod("put", String.class, InetAddress[].class);
            }
            catch (NoSuchMethodException exx) {
                this.put2 = cacheKlass.getDeclaredMethod("put", String.class, Integer.TYPE, InetAddress[].class);
            }
        }
        catch (Exception ex) {
            PLog.i(ex.getLocalizedMessage(), new Object[0]);
            PLog.v(ex);
        }
    }

    public void flushCache(List<IPHost> iphosts) {
        for (IPHost iphost : iphosts) {
            this.put(iphost.host, iphost.ip);
        }
    }

    public void put(String hostname, String ip) {
        InetAddress[] addr = this.localCache.get(hostname);
        if (null == addr) {
            addr = new InetAddress[]{SPNetUtil.buildInet4Address(hostname, ip)};
            this.localCache.put(hostname, addr);
        }
        this.put(hostname, addr);
    }

    public void clear() {
        this.localCache.clear();
    }

    private void put(String hostname, InetAddress[] addresses) {
        try {
            if (null != this.put1) {
                this.put1.invoke(this.addressCache, hostname, addresses);
            } else if (null != this.put2) {
                this.put2.invoke(this.addressCache, hostname, 0, addresses);
            }
        }
        catch (Exception ex) {
            PLog.i(ex.getLocalizedMessage(), new Object[0]);
            PLog.v(ex);
        }
    }
}

