/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.app.Activity;
import android.content.Context;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import android.support.v4.os.CancellationSignal;
import com.secure.PLog;
import com.secure.comm.utils.SPFingerprintCallback;
import com.secure.comm.utils.SPIntentUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class SPFingerprintUtil {
    private static final String USE_FINGERPRINT = "android.permission.USE_FINGERPRINT";
    private static final int FINGERPRINT_PERMISSION_REQUEST_CODE = 0;
    private static CancellationSignal cs = null;
    private static AtomicBoolean authenticating = new AtomicBoolean(false);

    public static void requestPermission(Activity activity) {
        SPIntentUtil.requestPermission(activity, new String[]{USE_FINGERPRINT}, 0);
    }

    public static boolean isAvailable(Context context) {
        FingerprintManagerCompat fpm = FingerprintManagerCompat.from((Context)context);
        return fpm.isHardwareDetected() && fpm.hasEnrolledFingerprints();
    }

    public static boolean isHardwareDetected(Context context) {
        return FingerprintManagerCompat.from((Context)context).isHardwareDetected();
    }

    public static void authenticate(Context context, SPFingerprintCallback callback) {
        FingerprintManagerCompat fpm = FingerprintManagerCompat.from((Context)context);
        FPAuthCallback cb = new FPAuthCallback(callback);
        if (!fpm.isHardwareDetected()) {
            cb.onAuthenticationError(0, "\u60a8\u7684\u624b\u673a\u6ca1\u6709\u6307\u7eb9\u8bbe\u5907");
        } else if (!fpm.hasEnrolledFingerprints()) {
            cb.onAuthenticationError(0, "\u60a8\u7684\u624b\u673a\u5185\u8fd8\u6ca1\u6709\u5f55\u5165\u6ca1\u6709\u6307\u7eb9\uff0c\u65e0\u6cd5\u8fdb\u884c\u9a8c\u8bc1");
        } else {
            if (null != cs) {
                cs.cancel();
            }
            cs = new CancellationSignal();
            authenticating.set(true);
            fpm.authenticate(null, 0, cs, (FingerprintManagerCompat.AuthenticationCallback)cb, null);
        }
    }

    public static void cancel() {
        authenticating.set(false);
        if (null != cs) {
            cs.cancel();
        }
        cs = null;
    }

    private static class FPAuthCallback
    extends FingerprintManagerCompat.AuthenticationCallback {
        private SPFingerprintCallback mCallback;

        public FPAuthCallback(SPFingerprintCallback callback) {
            this.mCallback = callback;
        }

        public void onAuthenticationError(int errMsgId, CharSequence errString) {
            if (authenticating.get()) {
                PLog.v("onAuthenticationError errMsgId=%d, errString=%s", errMsgId, errString);
                if (errMsgId != 5 && null != this.mCallback) {
                    this.mCallback.onFPAuthBlocked(errMsgId, errString);
                }
            }
        }

        public void onAuthenticationFailed() {
            if (authenticating.get() && null != this.mCallback) {
                this.mCallback.onFPAuthFailed("\u6307\u7eb9\u9a8c\u8bc1\u5931\u8d25");
            }
        }

        public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
            super.onAuthenticationHelp(helpMsgId, helpString);
        }

        public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
            if (authenticating.get() && null != this.mCallback) {
                this.mCallback.onFPAuthSucceeded();
            }
        }
    }
}

