/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.entry.SPApkInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.net.ssl.KeyManagerFactory;

public class SPFileUtil {
    private static final int REQUEST_EXTERNAL_STORAGE = 1;
    @SuppressLint(value={"InlinedApi"})
    private static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};

    public static String getSdCardPath() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return null;
    }

    public static String getExtSdCardPath(Context context) {
        try {
            String state = Environment.getExternalStorageState();
            if ("mounted".equals(state) || "mounted_ro".equals(state)) {
                File[] dirs;
                String sdcard = Environment.getExternalStorageDirectory().getAbsolutePath();
                File[] fileList = new File("/storage/").listFiles();
                if (null != fileList) {
                    for (File file : fileList) {
                        String ext_sdcard = file.getAbsolutePath();
                        if (ext_sdcard.equalsIgnoreCase(sdcard) || sdcard.startsWith(ext_sdcard) || !file.isDirectory() || !file.canRead()) continue;
                        return file.getAbsolutePath();
                    }
                }
                ArrayList<String> sdCardPossiblePath = new ArrayList<String>();
                sdCardPossiblePath.add("/storage/extSdCard");
                sdCardPossiblePath.add("/mnt/external_sd");
                sdCardPossiblePath.add("/mnt/ext_sd");
                sdCardPossiblePath.add("/mnt/external");
                sdCardPossiblePath.add("/mnt/extSdCard");
                sdCardPossiblePath.add("/mnt/sdcard2");
                if (null != context && Build.VERSION.SDK_INT >= 19 && null != (dirs = SPFileUtil.probeStorage(context)) && dirs.length > 1 && null != dirs[1]) {
                    sdCardPossiblePath.add(dirs[1].getAbsolutePath());
                }
                for (String path : sdCardPossiblePath) {
                    File ext_file = new File(path);
                    if (!ext_file.isDirectory() || !ext_file.canWrite()) continue;
                    File testWritable = new File(path, ".test_" + System.currentTimeMillis());
                    testWritable.delete();
                    if (!testWritable.mkdirs()) continue;
                    testWritable.delete();
                    return path;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @TargetApi(value=19)
    public static File[] probeStorage(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            return context.getExternalFilesDirs(null);
        }
        return null;
    }

    public static String realpath(String filepath) {
        return TextUtils.isEmpty((CharSequence)filepath) ? filepath : new File(filepath).getPath();
    }

    public static String getMimeType(String path) {
        if (!TextUtils.isEmpty((CharSequence)path) && path.startsWith("/")) {
            path = "file://" + path;
        }
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)path);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        return null != mimeType ? mimeType : "text/html";
    }

    public static boolean appendFile(String filepath, byte[] data) {
        return SPFileUtil.appendFile(filepath, data, 0, data.length);
    }

    public static boolean appendFile(String filepath, byte[] data, int offset, int count) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.seek(file.length());
            if (count == 0) {
                count = data.length - offset;
            }
            raf.write(data, offset, count);
            raf.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String readAssetsText(Context context, String filepath) {
        return SPFileUtil.readAssetsBin(context, filepath).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream readAssetsBin(Context context, String filepath) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream ins = null;
        try {
            ins = context.getAssets().open(filepath);
            BufferedInputStream bis = new BufferedInputStream(ins);
            byte[] buffer = new byte[1024];
            int len = 0;
            while (-1 != (len = bis.read(buffer))) {
                baos.write(buffer, 0, len);
            }
            bis.close();
        }
        catch (Exception exx) {
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Exception exx) {
                PLog.v(exx);
            }
        }
        return baos;
    }

    public static Drawable readAssetsDrawable(Context context, String filepath) {
        try {
            InputStream ins = context.getAssets().open(filepath);
            return Drawable.createFromStream((InputStream)ins, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Bitmap readAssetsBitmap(Context context, String filepath) {
        try {
            InputStream ins = context.getAssets().open(filepath);
            return BitmapFactory.decodeStream((InputStream)ins);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Bitmap readAssetsBitmapWithSize(Context context, String filepath, int width, int height) {
        Bitmap ret = null;
        try {
            Bitmap bmp = SPFileUtil.readAssetsBitmap(context, filepath);
            if (null != bmp) {
                if (bmp.getWidth() != width || bmp.getHeight() != height) {
                    ret = Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)true);
                    bmp.recycle();
                } else {
                    ret = bmp;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static SPApkInfo loadApkInfo(PackageManager pkgmgr, String apkpath) {
        SPApkInfo apk = new SPApkInfo();
        apk.apkpath = apkpath;
        SPFileUtil.loadApkInfo(apk, pkgmgr);
        return apk;
    }

    public static void loadApkInfo(SPApkInfo apk, PackageManager pkgmgr) {
        try {
            PackageInfo pi = pkgmgr.getPackageArchiveInfo(apk.apkpath, 0);
            ApplicationInfo appInfo = pi.applicationInfo;
            appInfo.publicSourceDir = apk.apkpath;
            apk.pkgname = appInfo.packageName;
            apk.appname = appInfo.loadLabel(pkgmgr).toString();
            apk.icon = appInfo.loadIcon(pkgmgr);
            apk.desc = appInfo.loadDescription(pkgmgr);
            if (null == apk.desc) {
                apk.desc = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeFile(String filename, byte[] data) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(data);
            fos.close();
        }
        catch (Exception ex) {
            PLog.i(ex.getLocalizedMessage(), new Object[0]);
            PLog.v(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String filename) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            int len = 0;
            while (-1 != (len = ((InputStream)ins).read(buffer))) {
                baos.write(buffer, 0, len);
            }
            ((InputStream)ins).close();
        }
        catch (Exception ex) {
            PLog.i(ex.getLocalizedMessage(), new Object[0]);
            PLog.v(ex);
        }
        finally {
            try {
                if (ins != null) {
                    ((InputStream)ins).close();
                }
            }
            catch (Exception exx) {
                PLog.i(exx.getLocalizedMessage(), new Object[0]);
                PLog.v(exx);
            }
        }
        return baos.toByteArray();
    }

    public static void writeObject(Context context, String name, Object object) {
        if (null != object) {
            try {
                FileOutputStream fos = context.openFileOutput(name, 0);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(object);
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                PLog.v(ex);
            }
        }
    }

    public static <T> T readObject(Context context, String name) {
        try {
            FileInputStream fis = context.openFileInput(name);
            ObjectInputStream ois = new ObjectInputStream(fis);
            return (T)ois.readObject();
        }
        catch (FileNotFoundException fis) {
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return null;
    }

    public static void deletePrivateFile(Context context, String name) {
        try {
            context.deleteFile(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyFileOrDirectory(String srcDir, String dstDir) {
        try {
            File src = new File(srcDir);
            File dst = new File(dstDir, src.getName());
            if (src.isDirectory()) {
                String[] files = src.list();
                int filesLength = files.length;
                for (int i = 0; i < filesLength; ++i) {
                    String src1 = new File(src, files[i]).getPath();
                    String dst1 = dst.getPath();
                    SPFileUtil.copyFileOrDirectory(src1, dst1);
                }
            } else {
                SPFileUtil.copyFile(src, dst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAssetsToFile(Context context, String name, File dstFile) {
        try {
            dstFile.delete();
            InputStream ins = null;
            FileOutputStream outs = null;
            try {
                int len;
                ins = context.getAssets().open(name);
                outs = new FileOutputStream(dstFile);
                byte[] buf = new byte[10240];
                do {
                    if ((len = ins.read(buf)) <= 0) continue;
                    outs.write(buf, 0, len);
                } while (len >= buf.length);
            }
            finally {
                if (null != ins) {
                    ins.close();
                }
                if (null != outs) {
                    outs.close();
                }
            }
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) {
        try {
            PLog.v("copyFile %s -> %s", sourceFile.getAbsolutePath(), destFile.getAbsolutePath());
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            if (destFile.exists()) {
                destFile.delete();
            } else {
                destFile.createNewFile();
            }
            AbstractInterruptibleChannel source = null;
            AbstractInterruptibleChannel destination = null;
            FileInputStream fins = null;
            FileOutputStream fouts = null;
            try {
                fins = new FileInputStream(sourceFile);
                fouts = new FileOutputStream(destFile);
                source = fins.getChannel();
                destination = fouts.getChannel();
                ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
                if (null != fins) {
                    fins.close();
                }
                if (null != fouts) {
                    fouts.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkKeyStoreCertFile(String filepath, String password) {
        try {
            String type = filepath.endsWith(".pfx") || filepath.endsWith(".p12") ? "PKCS12" : KeyStore.getDefaultType();
            KeyStore keystore = KeyStore.getInstance(type);
            FileInputStream ins = new FileInputStream(new File(filepath));
            keystore.load(ins, password.toCharArray());
            ins.close();
            KeyManagerFactory.getInstance("X509").init(keystore, password.toCharArray());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void verifyStoragePermissions(Activity activity) {
        int targetSdkVersion = 0;
        try {
            PackageManager pm = activity.getPackageManager();
            ApplicationInfo appinfo = pm.getApplicationInfo(SPApplication.getPkgName((Context)activity), 0);
            if (appinfo != null) {
                targetSdkVersion = appinfo.targetSdkVersion;
            }
        }
        catch (Exception pm) {
            // empty catch block
        }
        if (targetSdkVersion > 22 && Build.VERSION.SDK_INT > 21) {
            try {
                int permission2 = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                if (permission2 != 0) {
                    ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_STORAGE, (int)1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static HashSet<String> getExternalMounts() {
        String[] lines;
        HashSet<String> out = new HashSet<String>();
        String reg = "(?i).*vold.*(vfat|ntfs|exfat|fat32|ext3|ext4).*rw.*";
        String s = "";
        try {
            Process process = new ProcessBuilder(new String[0]).command("mount").redirectErrorStream(true).start();
            process.waitFor();
            InputStream is = process.getInputStream();
            byte[] buffer = new byte[1024];
            while (is.read(buffer) != -1) {
                s = s + new String(buffer);
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String line : lines = s.split("\n")) {
            String[] parts;
            if (line.toLowerCase(Locale.US).contains("asec") || !line.matches(reg)) continue;
            for (String part : parts = line.split(" ")) {
                if (!part.startsWith("/") || part.toLowerCase(Locale.US).contains("vold")) continue;
                out.add(part);
            }
        }
        return out;
    }

    public static boolean checkDirExist(String dirPath) {
        boolean ret = true;
        File file = new File(dirPath);
        if (!file.exists()) {
            ret = file.mkdirs();
        }
        return ret;
    }

    public static boolean checkFileExist(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

