/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.content.Context;
import android.os.Build;
import com.secure.comm.utils.SPFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SPErrorHandler
implements Thread.UncaughtExceptionHandler {
    private static SimpleDateFormat FMT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
    private Thread.UncaughtExceptionHandler mPrevExpHdr = Thread.getDefaultUncaughtExceptionHandler();
    private String mErrorFile = SPFileUtil.getSdCardPath() + "/sp_error.txt";
    private static SPErrorHandler _instance = null;

    public static SPErrorHandler instance() {
        return null == _instance ? (_instance = new SPErrorHandler()) : _instance;
    }

    public static void commitError(Context context, String url, String extra) {
        String path = SPFileUtil.getSdCardPath() + "/sp_error.txt";
        File errfile = new File(path);
        if (errfile.exists()) {
            // empty if block
        }
    }

    private SPErrorHandler() {
        System.out.println(this.mErrorFile);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            File file = new File(this.mErrorFile);
            if (!file.exists() || file.length() > 0x200000L) {
                file.delete();
                file.getParentFile().mkdirs();
                file.createNewFile();
                StringBuilder sb = new StringBuilder();
                sb.append("\nDISPLAY=").append(Build.DISPLAY);
                sb.append("\nPRODUCT=").append(Build.PRODUCT);
                sb.append("\nMODEL=").append(Build.MODEL);
                sb.append("\nDEVICE=").append(Build.DEVICE);
                sb.append("\nMANUFACTURER=").append(Build.MANUFACTURER);
                sb.append("\nVERSION=").append(Build.VERSION.SDK_INT);
                FileWriter writer = new FileWriter(file);
                writer.write(sb.toString());
                writer.close();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.mErrorFile, true)));
            out.println("\n\n  ----===================----- ");
            out.println(FMT_DATETIME.format(new Date()));
            ex.printStackTrace(out);
            if (null != ex.getCause()) {
                ex.getCause().printStackTrace(out);
            }
            out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

