/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.secure.PLog;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPFileUtil;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPNetUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.json.JSONObject;

public class SPDeviceUtil {
    public static final String exteranlStorageDirName = "secqax";

    private SPDeviceUtil() {
    }

    public static Map<String, String> getDeviceInfo(Context context) {
        HashMap<String, String> devinfos = new HashMap<String, String>();
        try {
            if (null == context) {
                context = SPApplication.appContext();
            }
            devinfos.put("os", "Android");
            devinfos.put("os_version", Build.VERSION.RELEASE);
            devinfos.put("model", Build.MODEL);
            devinfos.put("product", Build.PRODUCT);
            devinfos.put("name", SPDeviceUtil.getDeviceName(context));
            devinfos.put("wifi_address", SPNetUtil.getWifiMac(context));
            devinfos.put("imei", SPDeviceUtil.getIMEI(context));
            devinfos.put("serial", Build.SERIAL);
            devinfos.put("manufacturer", Build.MANUFACTURER);
            devinfos.put("devid", SPDeviceUtil.getDevID_Lagged(context));
            devinfos.put("antivirus", "1");
            devinfos.put("rooted", SPDeviceUtil.isRooted() ? "1" : "0");
            devinfos.put("package_name", SPApplication.getPkgName(context));
        }
        catch (Exception ex) {
            PLog.v(ex);
        }
        return devinfos;
    }

    private static String getDevID_Lagged(Context context) {
        String devid = SPDeviceUtil.devidLoad(context);
        if (TextUtils.isEmpty((CharSequence)devid) || devid.length() != 32) {
            String wifi = SPNetUtil.getWifiMac(context);
            String imei = SPDeviceUtil.getIMEI(context);
            devid = TextUtils.isEmpty((CharSequence)imei) && SPNetUtil.isEmptyWifiMAC(wifi) ? Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id") : wifi + imei + SPApplication.getSdkDevIDSuffix();
            devid = SPStringUtil.md5(devid);
            SPDeviceUtil.devidStore(context, devid);
        }
        return devid;
    }

    public static String getDevID_Enhanced(Context context) {
        String devid = SPDeviceUtil.devidLoad(context);
        if (TextUtils.isEmpty((CharSequence)devid) || devid.length() != 32) {
            String wifi = SPNetUtil.getWifiMac(context);
            String imei = SPDeviceUtil.getIMEI(context);
            String serial = Build.SERIAL;
            StringBuffer buf = new StringBuffer();
            if (!SPNetUtil.isEmptyWifiMAC(wifi)) {
                buf.append(wifi).append("-");
            }
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                buf.append(imei).append("-");
            }
            if (!TextUtils.isEmpty((CharSequence)serial)) {
                buf.append(serial).append("-");
            }
            buf.append(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
            devid = SPStringUtil.md5(buf.toString() + "_secureportal");
            devid = SPStringUtil.md5(devid);
            SPDeviceUtil.devidStore(context, devid);
        }
        return devid;
    }

    private static void devidStore(Context context, String devid) {
        SPDeviceUtil.saveDevidEStorage(context, devid);
        if (!TextUtils.isEmpty((CharSequence)SPApplication.getSdkDevIDSuffix())) {
            return;
        }
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "model", Build.MODEL);
        SPJSONUtil.put(json, "wifi", SPNetUtil.getWifiMac(context));
        devid = SPStringUtil.opt(devid);
        if (devid.length() > 8) {
            SPJSONUtil.put(json, "did", devid);
            CRC32 crc32 = new CRC32();
            crc32.update(devid.substring(8).getBytes());
            SPJSONUtil.put(json, "crc32", String.valueOf(crc32.getValue()));
        }
        String jstr = Base64.encodeToString((byte[])json.toString().getBytes(), (int)2);
        SharedPreferences.Editor spe = context.getSharedPreferences("sportal_devinfo", 0).edit();
        spe.putString("devid", jstr);
        spe.commit();
    }

    private static String devidLoad(Context context) {
        String didStr = "";
        didStr = SPDeviceUtil.getDevidEStorage(context);
        if (!TextUtils.isEmpty((CharSequence)didStr)) {
            return didStr;
        }
        if (!TextUtils.isEmpty((CharSequence)SPApplication.getSdkDevIDSuffix())) {
            return "";
        }
        SharedPreferences sp = context.getSharedPreferences("sportal_devinfo", 0);
        String jstr = sp.getString("devid", "");
        if ((jstr = new String(Base64.decode((String)jstr, (int)2))).length() > 1 && jstr.charAt(0) == '{') {
            String devid;
            JSONObject json = SPJSONUtil.parseObject(jstr);
            if (json.optString("model").equalsIgnoreCase(Build.MODEL) && (devid = json.optString("did")).length() > 8) {
                CRC32 crc32 = new CRC32();
                crc32.update(devid.substring(8).getBytes());
                if (crc32.getValue() == SPStringUtil.parseLong(json.optString("crc32"))) {
                    didStr = devid;
                    SPDeviceUtil.devidStore(context, didStr);
                }
            }
        } else {
            didStr = jstr;
            SPDeviceUtil.devidStore(context, didStr);
        }
        return didStr;
    }

    public static String getDeviceName(Context context) {
        String devname = "";
        try {
            devname = SPStringUtil.opt(BluetoothAdapter.getDefaultAdapter().getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (SPStringUtil.opt(devname).length() < 1) {
            try {
                devname = SPStringUtil.opt(Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"device_name"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (devname = SPStringUtil.opt(devname)).length() > 0 ? devname : Build.BRAND + " " + Build.MODEL;
    }

    public static String getIMEI(Context context) {
        String imei = "";
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            imei = SPStringUtil.opt(tm.getDeviceId());
            if (imei.length() < 1 || "000000000000000".equals(imei)) {
                imei = SPStringUtil.opt(SPSystemUtil.getProperty("ro.gsm.imei"));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imei;
    }

    public static String getIMSI(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getSubscriberId();
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getBluetoothAddress(Context context) {
        String macaddr = "";
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        try {
            Method getAddress;
            Object address;
            Object mService = BluetoothAdapter.class.getDeclaredField("mService").get(bluetoothAdapter);
            if (null != mService && null != (address = (getAddress = mService.getClass().getDeclaredMethod("getAddress", new Class[0])).invoke(mService, new Object[0])) && address instanceof String) {
                macaddr = SPStringUtil.opt((String)address);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (macaddr.isEmpty()) {
            macaddr = SPStringUtil.opt(SPSystemUtil.getProperty("persist.service.bdroid.bdaddr"));
        }
        if (macaddr.isEmpty() && null != context) {
            macaddr = SPStringUtil.opt(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"bluetooth_address"));
        }
        return macaddr;
    }

    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isEmulator() {
        String product = Build.PRODUCT;
        boolean isEmulator = false;
        if (product != null) {
            isEmulator = product.equals("sdk") || product.contains("_sdk") || product.contains("sdk_");
        }
        return isEmulator;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static boolean isRooted() {
        return SPDeviceUtil.checkRootMethod2() || SPDeviceUtil.checkRootMethod3() || SPDeviceUtil.checkRootMethod4();
    }

    private static boolean checkRootMethod1() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    private static boolean checkRootMethod2() {
        return new File("/system/app/Superuser.apk").exists();
    }

    private static boolean checkRootMethod3() {
        String[] paths;
        for (String path : paths = new String[]{"/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su"}) {
            if (!new File(path).exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkRootMethod4() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"/system/xbin/which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            if (in.readLine() != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static String getDevidEStorage(Context context) {
        String devidFilePath = "";
        devidFilePath = SPDeviceUtil.isExternalStorageReady(context);
        if (TextUtils.isEmpty((CharSequence)devidFilePath)) {
            return "";
        }
        String id = new String(SPFileUtil.readFile(devidFilePath));
        return id;
    }

    private static boolean saveDevidEStorage(Context context, String devid) {
        String devidFilePath = "";
        devidFilePath = SPDeviceUtil.isExternalStorageReady(context);
        if (TextUtils.isEmpty((CharSequence)devidFilePath)) {
            return false;
        }
        Log.d((String)"sdk", (String)("save DeviceID to ExternalStorage " + devid));
        SPFileUtil.writeFile(devidFilePath, devid.getBytes());
        return true;
    }

    private static String isExternalStorageReady(Context context) {
        String eStorage = "";
        String eStorageDir = "";
        String devidFilePath = "";
        if (!SPDeviceUtil.hasStoragePermission(context)) {
            Log.i((String)"sdk", (String)"no storagePermission granted");
            return "";
        }
        eStorage = SPFileUtil.getSdCardPath();
        if (TextUtils.isEmpty((CharSequence)eStorage)) {
            return "";
        }
        eStorageDir = eStorage + "/" + exteranlStorageDirName;
        if (!SPFileUtil.checkDirExist(eStorageDir)) {
            return "";
        }
        devidFilePath = eStorageDir + "/" + SPStringUtil.md5(exteranlStorageDirName + SPApplication.getSdkDevIDSuffix());
        if (!SPFileUtil.checkFileExist(devidFilePath)) {
            return "";
        }
        return devidFilePath;
    }

    public static boolean hasStoragePermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            int readPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE");
            int writePermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            return readPermission == 0 && writePermission == 0;
        }
        return true;
    }
}

