/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.utils;

import com.secure.comm.utils.SPFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SPDebugUtil {
    private static final SimpleDateFormat FMT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
    private static String _errorFile = null;

    public static synchronized void dumpError(Throwable ex) {
        try {
            PrintWriter out = SPDebugUtil.getOutput();
            ex.printStackTrace(out);
            if (null != ex.getCause()) {
                out.println("\n---\n");
                ex.getCause().printStackTrace(out);
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void dumpMsg(String msg) {
        try {
            PrintWriter out = SPDebugUtil.getOutput();
            out.println(msg);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static PrintWriter getOutput() throws IOException {
        File file;
        if (null == _errorFile) {
            _errorFile = SPFileUtil.getSdCardPath() + "/debug_msg.txt";
        }
        if ((file = new File(_errorFile)).length() > 10000000L) {
            file.delete();
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(_errorFile, true)));
        out.println("\n\n -------------------------------- \n");
        out.println(FMT_DATETIME.format(new Date()));
        return out;
    }
}

