/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.net;

import java.io.Serializable;

public class SPPortRange
implements Comparable<SPPortRange>,
Serializable {
    private static final long serialVersionUID = 1926521600259308772L;
    public static final int PROTO_ANY = 0;
    public static final int PROTO_TCP = 1;
    public static final int PROTO_UDP = 2;
    public static final int PROTO_ICMP = 3;
    public int proto = 0;
    public int from = 0;
    public int to = 0;

    public SPPortRange() {
        this(0, 0, 0);
    }

    public SPPortRange(int port1, int port2, int protocol) {
        this.proto = protocol;
        if (port1 > port2) {
            this.from = port2;
            this.to = port1;
        } else {
            this.from = port1;
            this.to = port2;
        }
    }

    @Override
    public int compareTo(SPPortRange another) {
        if (this.from == another.from) {
            return this.to < another.to ? -1 : (this.to == another.to ? 0 : 1);
        }
        return this.from < another.from ? -1 : 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.proto) {
            case 1: {
                sb.append("tcp");
                break;
            }
            case 2: {
                sb.append("udp");
                break;
            }
            case 3: {
                sb.append("icmp");
                break;
            }
            default: {
                sb.append("any");
            }
        }
        sb.append(":").append(this.from).append("-").append(this.to).append(";");
        return sb.toString();
    }
}

