/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.net;

import com.secure.comm.net.SPIPCIDR;
import com.secure.comm.net.SPIPRange;
import com.secure.comm.utils.SPIPUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SPIPPool {
    public static final long LOOPBACK_MIN = 0x7F000000L;
    public static final long LOOPBACK_MAX = Integer.MAX_VALUE;
    public static final long MULTICAST_MIN = 0xE0000000L;
    public static final long MULTICAST_MAX = 0xEFFFFFFFL;
    private List<SPIPRange> pool = new ArrayList<SPIPRange>();
    private List<SPIPRange> exclusions = new ArrayList<SPIPRange>();

    public static SPIPPool exclusionPool() {
        SPIPPool pool = new SPIPPool();
        pool.pushIPRange(0x7F000000L, Integer.MAX_VALUE);
        pool.pushIPRange(0xE0000000L, 0xEFFFFFFFL);
        pool.pushIP("220.181.171.126");
        return pool.combine();
    }

    public List<SPIPRange> getIPRanges() {
        return this.pool;
    }

    public void clear() {
        this.pool.clear();
    }

    public SPIPPool setExclusions(List<SPIPRange> ipranges) {
        this.exclusions.clear();
        if (null != ipranges) {
            this.exclusions.addAll(ipranges);
        }
        return this;
    }

    public SPIPPool pushIP(String ip) {
        this.pushIP(SPIPUtil.ipToLong(ip));
        return this;
    }

    public SPIPPool pushIP(long ip) {
        this.pushIPRange(ip, ip);
        return this;
    }

    public SPIPPool pushIPRange(String startIp, String endIp) {
        this.pushIPRange(SPIPUtil.ipToLong(startIp), SPIPUtil.ipToLong(endIp));
        return this;
    }

    public SPIPPool pushIPMask(String netip, String mask) {
        long ip = SPIPUtil.ipToLong(netip);
        long m = SPIPUtil.ipToLong(mask);
        this.pushIPRange(SPIPUtil.getStartAddress(ip, m), SPIPUtil.getEndAddress(ip, m));
        return this;
    }

    public SPIPPool pushIPRange(long startIp, long endIp) {
        if (startIp >= 0L && startIp <= endIp) {
            for (SPIPRange exclusion : this.exclusions) {
                if (!exclusion.isIntersecting(startIp, endIp)) continue;
                this.pushIPRange(startIp, exclusion.start - 1L);
                this.pushIPRange(exclusion.end + 1L, endIp);
                return this;
            }
            this.pool.add(new SPIPRange(startIp, endIp));
        }
        return this;
    }

    public SPIPPool combine() {
        ArrayList<SPIPRange> items = new ArrayList<SPIPRange>(this.pool);
        Collections.sort(items);
        block0: for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                if (((SPIPRange)items.get((int)j)).start < 0L || ((SPIPRange)items.get((int)i)).end < 0L) continue;
                if (((SPIPRange)items.get((int)i)).end + 1L < ((SPIPRange)items.get((int)j)).start) continue block0;
                ((SPIPRange)items.get((int)i)).end = Math.max(((SPIPRange)items.get((int)i)).end, ((SPIPRange)items.get((int)j)).end);
                ((SPIPRange)items.get((int)j)).end = -1L;
                ((SPIPRange)items.get((int)j)).start = -1L;
            }
        }
        this.pool.clear();
        for (SPIPRange item : items) {
            if (item.start < 0L) continue;
            this.pool.add(item);
        }
        return this;
    }

    public List<SPIPCIDR> makeRouteTable() {
        ArrayList<SPIPCIDR> routes = new ArrayList<SPIPCIDR>();
        for (SPIPRange item : this.pool) {
            SPIPUtil.ipRangeToCIDR(routes, item.start, item.end);
        }
        return routes;
    }

    public boolean containtsIP(long ip) {
        for (SPIPRange ipr : this.pool) {
            if (ip < ipr.start) break;
            if (ip > ipr.end) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SPIPPool[");
        for (SPIPRange ipr : this.pool) {
            sb.append(SPIPUtil.longToIP(ipr.start)).append("-");
            sb.append(SPIPUtil.longToIP(ipr.end)).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

