/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.net;

import android.text.TextUtils;
import com.secure.PLog;
import com.secure.comm.net.SPHttpClient;
import com.secure.comm.net.SPHttpResponse;
import com.secure.comm.utils.SPFileUtil;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SPHttpDownloadTask
implements Runnable {
    public static final int STATE_PROGRESS = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_OVER = 2;
    public static final int STATE_CANCEL = 10;
    public String url;
    public String filepath;
    public long totalBytes;
    public long recvBytes;
    public int progress;
    private AtomicInteger state;
    private SPHttpResponse httpRsp;
    private AtomicBoolean running = new AtomicBoolean(false);
    private OnStateListener listener;

    public static SPHttpDownloadTask execute(String url, String dstpath, OnStateListener listener) {
        return new SPHttpDownloadTask(url, dstpath, listener).start();
    }

    private SPHttpDownloadTask(String url, String dstpath, OnStateListener listener) {
        this.state = new AtomicInteger(0);
        this.url = url;
        this.filepath = dstpath;
        this.listener = listener;
    }

    public void cancel() {
        if (this.running.get() && this.progress < 100) {
            this.running.set(false);
            this.state.set(10);
            this.close();
        }
    }

    public int getState() {
        return this.state.get();
    }

    private SPHttpDownloadTask start() {
        new Thread(this).start();
        return this;
    }

    @Override
    public void run() {
        this.running.set(true);
        PLog.v("SPHttpDownload url=%s", this.url);
        this.httpRsp = SPHttpClient.download(this.url, 0L, 0L, 0L);
        if (this.httpRsp.isOK()) {
            if (TextUtils.isEmpty((CharSequence)this.filepath)) {
                this.filepath = SPFileUtil.getSdCardPath() + "/secdownloads/" + this.httpRsp.filename;
            }
            this.totalBytes = this.httpRsp.contentLength;
            this.recvBytes = 0L;
            this.progress = -1;
            this.udpateState(0, 0);
            try {
                File file = new File(this.filepath);
                file.delete();
                file.getParentFile().mkdirs();
                file.createNewFile();
                InputStream ins = this.httpRsp.conn.getInputStream();
                byte[] buffer = new byte[102400];
                while (this.running.get() && this.progress >= 0 && this.progress < 100 && this.readBlock(ins, file, buffer)) {
                }
                if (this.progress == 100) {
                    this.udpateState(2, 100);
                } else if (this.running.get()) {
                    this.udpateState(1, this.progress);
                }
            }
            catch (Exception ex) {
                PLog.i(ex);
                this.udpateState(1, this.progress);
            }
        } else {
            this.udpateState(1, this.progress);
        }
        this.close();
        this.running.set(false);
    }

    private void udpateState(int state, int progress) {
        if (this.state.get() != 10) {
            if (this.state.get() != state) {
                this.state.set(state);
                if (null != this.listener) {
                    this.listener.onTaskState(this, state);
                }
            } else if (state == 0 && this.progress != progress) {
                this.progress = progress;
                this.listener.onTaskState(this, 0);
            }
        }
    }

    private boolean readBlock(InputStream input, File file, byte[] buffer) throws Exception {
        int recv_cur = input.read(buffer);
        if (recv_cur > 0) {
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            raf.seek(this.recvBytes);
            raf.write(buffer, 0, recv_cur);
            raf.close();
            this.recvBytes += (long)recv_cur;
            if (this.totalBytes > 0L) {
                if (this.recvBytes >= this.totalBytes) {
                    this.udpateState(0, 100);
                } else {
                    int prog = this.totalBytes > 0L ? (int)(this.recvBytes * 100L / this.totalBytes & 0xFFL) : 0;
                    this.udpateState(0, prog);
                }
            }
        } else if (recv_cur == -1) {
            if (this.totalBytes < 1L || this.recvBytes >= this.totalBytes) {
                this.udpateState(0, 100);
            } else {
                return false;
            }
        }
        return true;
    }

    private void close() {
        if (null != this.httpRsp) {
            try {
                this.httpRsp.conn.getInputStream().close();
                this.httpRsp.conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.httpRsp = null;
        }
    }

    public static interface OnStateListener {
        public void onTaskState(SPHttpDownloadTask var1, int var2);
    }
}

