/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.net;

import android.annotation.SuppressLint;
import android.os.Build;
import com.secure.PLog;
import com.secure.comm.app.SPOEM;
import com.secure.comm.net.SPHttpResponse;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.jni.SPLibBridge;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class SPHttpClient {
    public static final int TIMEOUT_CONN = 8000;
    public static final int TIMEOUT_READ = 8000;
    private static Map<String, String> cookies = Collections.synchronizedMap(new HashMap());

    public static SPHttpResponse download(String url, long ifModifiedSince, long firstBytePos, long lastBytePos) {
        SPHttpResponse hr = new SPHttpResponse();
        hr.url = url;
        try {
            SPHttpClient.pretreatmentConn(hr, url);
            if (firstBytePos > 0L) {
                hr.conn.setRequestProperty("Range", "bytes=" + firstBytePos + "-" + lastBytePos);
            }
            if (ifModifiedSince > 0L) {
                hr.conn.setIfModifiedSince(ifModifiedSince);
            }
            hr.conn.connect();
            return SPHttpClient.parseResponseHeader(hr, hr.conn);
        }
        catch (Exception exception) {
            return hr;
        }
    }

    public static void post(String url, String data) {
        SPHttpResponse hr = new SPHttpResponse();
        hr.url = url;
        try {
            SPHttpClient.pretreatmentConn(hr, url);
            hr.conn.setRequestMethod("POST");
            hr.conn.setDoOutput(true);
            hr.conn.connect();
            hr.conn.getOutputStream().write(data.getBytes());
            hr.conn.getOutputStream().flush();
            hr.conn.getOutputStream().close();
            SPHttpClient.parseResponseHeader(hr, hr.conn);
            hr.conn.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getPage(String url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SPHttpResponse hr = SPHttpClient.download(url, 0L, 0L, 0L);
        if (hr.isOK()) {
            try {
                int cur;
                byte[] buffer = new byte[102400];
                InputStream input = hr.conn.getInputStream();
                for (long recv = 0L; (recv < hr.contentLength || hr.contentLength < 1L) && (cur = input.read(buffer)) > 0; recv += (long)cur) {
                    baos.write(buffer, 0, cur);
                }
                hr.conn.getInputStream().close();
                hr.conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baos.toString();
    }

    @SuppressLint(value={"TrulyRandom"})
    private static void pretreatmentConn(SPHttpResponse hr, String url) throws Exception {
        int proxy_port = SPLibBridge.getProxyPort();
        if (SPOEM.oemName().equals("main_cntls") || SPOEM.isOEM_MPolicyZJ() || SPLibBridge.isNetHooking() || url.indexOf("127.0.0.1") > 0) {
            if (SPOEM.isOEM_MPolicyZJ() || SPOEM.oemName().equals("main_cntls")) {
                StringBuilder sb = new StringBuilder();
                sb.append("http://127.0.0.1:").append(proxy_port).append("/_proxy/");
                JSONObject json = new JSONObject();
                SPJSONUtil.put(json, "url", url);
                sb.append(SPStringUtil.byte2Hex(json.toString().getBytes()));
                url = sb.toString();
            }
            hr.conn = (HttpURLConnection)new URL(url).openConnection();
        } else {
            InetSocketAddress sa = new InetSocketAddress("127.0.0.1", proxy_port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, sa);
            hr.conn = (HttpURLConnection)new URL(url).openConnection(proxy);
        }
        hr.conn.setConnectTimeout(8000);
        hr.conn.setReadTimeout(8000);
        hr.conn.setRequestProperty("Connection", "Keep-Alive");
        if (url.startsWith("https")) {
            HttpsURLConnection sconn = (HttpsURLConnection)hr.conn;
            TrustManager[] trustAllCerts = new TrustManager[]{new SPX509TrustManager()};
            String protocol = Build.VERSION.SDK_INT < 9 ? "TLS" : "SSL";
            SSLContext sc = SSLContext.getInstance(protocol);
            sc.init(null, trustAllCerts, new SecureRandom());
            sconn.setSSLSocketFactory(sc.getSocketFactory());
            sconn.setHostnameVerifier(new SPHostnameVerifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildCookie(HttpURLConnection conn) {
        if (null != conn) {
            StringBuilder sb = new StringBuilder();
            Map<String, String> map = cookies;
            synchronized (map) {
                for (Map.Entry<String, String> entry : cookies.entrySet()) {
                    sb.append(entry.getKey());
                    if (entry.getValue().length() > 0) {
                        sb.append("=").append(entry.getValue());
                    }
                    sb.append("; ");
                }
            }
            String cookie = sb.toString().trim();
            if (cookie.length() > 0) {
                conn.setRequestProperty("Cookie", cookie);
            }
        }
    }

    private static SPHttpResponse parseResponseHeader(SPHttpResponse hr, HttpURLConnection conn) {
        String key;
        if (null == hr) {
            hr = new SPHttpResponse();
        }
        hr.conn = conn;
        try {
            hr.code = conn.getResponseCode();
        }
        catch (Exception ex) {
            PLog.i(ex);
        }
        hr.lastModified = conn.getLastModified();
        hr.contentLength = conn.getContentLength();
        String contentType = conn.getContentType();
        if (contentType.toLowerCase(Locale.ENGLISH).indexOf("utf-8") >= 0) {
            hr.charset = "UTF-8";
        }
        int i = 1;
        while (null != (key = conn.getHeaderFieldKey(i))) {
            String value = conn.getHeaderField(i);
            if (key.equalsIgnoreCase("Content-Disposition")) {
                SPHttpClient.parseFilename(hr, value);
            }
            ++i;
        }
        return hr;
    }

    private static void parseFilename(SPHttpResponse hr, String value) {
        String[] values;
        System.out.println("SPHttpClient parseFilename " + value);
        block6: for (String v : values = value.split(";")) {
            if ((v = v.trim()).startsWith("filename=")) {
                if ((v = v.substring(9)).length() <= 3) break;
                hr.filename = v.replaceAll("\"", "");
                try {
                    byte[] bytes = hr.filename.getBytes("ISO-8859-1");
                    hr.filename = new String(bytes, SPStringUtil.isUTF8(bytes) ? "UTF-8" : "GBK");
                    if (null == hr.url || hr.filename.indexOf("?") < 0) break;
                    URL url = new URL(hr.url);
                    String[] pairs = url.getQuery().split("&");
                    for (int i = pairs.length - 1; i >= 0; --i) {
                        try {
                            String qv;
                            int idx = pairs[i].indexOf("=");
                            if (idx < 0 || (qv = URLDecoder.decode(pairs[i].substring(idx + 1), "GBK")).indexOf(".") <= 0) continue;
                            hr.filename = qv;
                            break block6;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    PLog.v(ex);
                    break;
                }
            }
            if (!v.startsWith("filename*=")) continue;
            hr.filename = v.substring(v.indexOf("''", 10) + 2);
            try {
                hr.filename = URLDecoder.decode(hr.filename, "UTF-8");
            }
            catch (Exception exception) {}
            break;
        }
    }

    public static String getProxyUrl(String url) {
        int proxy_port = SPLibBridge.getProxyPort();
        StringBuilder sb = new StringBuilder();
        sb.append("http://127.0.0.1:").append(proxy_port).append("/_proxy/");
        JSONObject json = new JSONObject();
        SPJSONUtil.put(json, "url", url);
        sb.append(SPStringUtil.byte2Hex(json.toString().getBytes()));
        return sb.toString();
    }

    public static class SPHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String urlHostName, SSLSession session) {
            return true;
        }
    }

    public static class SPX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

